<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$clientpartners_list = new clientpartners_list();

// Run the page
$clientpartners_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clientpartners_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$clientpartners->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fclientpartnerslist = currentForm = new ew.Form("fclientpartnerslist", "list");
fclientpartnerslist.formKeyCountName = '<?php echo $clientpartners_list->FormKeyCountName ?>';

// Form_CustomValidate event
fclientpartnerslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclientpartnerslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclientpartnerslist.lists["x_ClientID"] = <?php echo $clientpartners_list->ClientID->Lookup->toClientList() ?>;
fclientpartnerslist.lists["x_ClientID"].options = <?php echo JsonEncode($clientpartners_list->ClientID->lookupOptions()) ?>;
fclientpartnerslist.lists["x_TitleID"] = <?php echo $clientpartners_list->TitleID->Lookup->toClientList() ?>;
fclientpartnerslist.lists["x_TitleID"].options = <?php echo JsonEncode($clientpartners_list->TitleID->lookupOptions()) ?>;
fclientpartnerslist.lists["x_MaritalStatusID"] = <?php echo $clientpartners_list->MaritalStatusID->Lookup->toClientList() ?>;
fclientpartnerslist.lists["x_MaritalStatusID"].options = <?php echo JsonEncode($clientpartners_list->MaritalStatusID->lookupOptions()) ?>;
fclientpartnerslist.autoSuggests["x_MaritalStatusID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fclientpartnerslistsrch = currentSearchForm = new ew.Form("fclientpartnerslistsrch");

// Filters
fclientpartnerslistsrch.filterList = <?php echo $clientpartners_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$clientpartners->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($clientpartners_list->TotalRecs > 0 && $clientpartners_list->ExportOptions->visible()) { ?>
<?php $clientpartners_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($clientpartners_list->ImportOptions->visible()) { ?>
<?php $clientpartners_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($clientpartners_list->SearchOptions->visible()) { ?>
<?php $clientpartners_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($clientpartners_list->FilterOptions->visible()) { ?>
<?php $clientpartners_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$clientpartners->isExport() || EXPORT_MASTER_RECORD && $clientpartners->isExport("print")) { ?>
<?php
if ($clientpartners_list->DbMasterFilter <> "" && $clientpartners->getCurrentMasterTable() == "clients") {
	if ($clientpartners_list->MasterRecordExists) {
		include_once "clientsmaster.php";
	}
}
?>
<?php } ?>
<?php
$clientpartners_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$clientpartners->isExport() && !$clientpartners->CurrentAction) { ?>
<form name="fclientpartnerslistsrch" id="fclientpartnerslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($clientpartners_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fclientpartnerslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="clientpartners">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($clientpartners_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($clientpartners_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $clientpartners_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($clientpartners_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($clientpartners_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($clientpartners_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($clientpartners_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $clientpartners_list->showPageHeader(); ?>
<?php
$clientpartners_list->showMessage();
?>
<?php if ($clientpartners_list->TotalRecs > 0 || $clientpartners->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($clientpartners_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> clientpartners">
<?php if (!$clientpartners->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$clientpartners->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($clientpartners_list->Pager)) $clientpartners_list->Pager = new PrevNextPager($clientpartners_list->StartRec, $clientpartners_list->DisplayRecs, $clientpartners_list->TotalRecs, $clientpartners_list->AutoHidePager) ?>
<?php if ($clientpartners_list->Pager->RecordCount > 0 && $clientpartners_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clientpartners_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clientpartners_list->pageUrl() ?>start=<?php echo $clientpartners_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clientpartners_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clientpartners_list->pageUrl() ?>start=<?php echo $clientpartners_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clientpartners_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clientpartners_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clientpartners_list->pageUrl() ?>start=<?php echo $clientpartners_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clientpartners_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clientpartners_list->pageUrl() ?>start=<?php echo $clientpartners_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clientpartners_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($clientpartners_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $clientpartners_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $clientpartners_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $clientpartners_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($clientpartners_list->TotalRecs > 0 && (!$clientpartners_list->AutoHidePageSizeSelector || $clientpartners_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="clientpartners">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($clientpartners_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($clientpartners_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($clientpartners_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($clientpartners_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($clientpartners_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($clientpartners_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($clientpartners_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($clientpartners_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($clientpartners_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($clientpartners->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $clientpartners_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fclientpartnerslist" id="fclientpartnerslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($clientpartners_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $clientpartners_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="clientpartners">
<?php if ($clientpartners->getCurrentMasterTable() == "clients" && $clientpartners->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="clients">
<input type="hidden" name="fk_ClientID" value="<?php echo $clientpartners->ClientID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_clientpartners" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($clientpartners_list->TotalRecs > 0 || $clientpartners->isGridEdit()) { ?>
<table id="tbl_clientpartnerslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$clientpartners_list->RowType = ROWTYPE_HEADER;

// Render list options
$clientpartners_list->renderListOptions();

// Render list options (header, left)
$clientpartners_list->ListOptions->render("header", "left");
?>
<?php if ($clientpartners->ClientID->Visible) { // ClientID ?>
	<?php if ($clientpartners->sortUrl($clientpartners->ClientID) == "") { ?>
		<th data-name="ClientID" class="<?php echo $clientpartners->ClientID->headerCellClass() ?>"><div id="elh_clientpartners_ClientID" class="clientpartners_ClientID"><div class="ew-table-header-caption"><?php echo $clientpartners->ClientID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientID" class="<?php echo $clientpartners->ClientID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->ClientID) ?>',2);"><div id="elh_clientpartners_ClientID" class="clientpartners_ClientID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->ClientID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->ClientID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->ClientID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->TitleID->Visible) { // TitleID ?>
	<?php if ($clientpartners->sortUrl($clientpartners->TitleID) == "") { ?>
		<th data-name="TitleID" class="<?php echo $clientpartners->TitleID->headerCellClass() ?>"><div id="elh_clientpartners_TitleID" class="clientpartners_TitleID"><div class="ew-table-header-caption"><?php echo $clientpartners->TitleID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID" class="<?php echo $clientpartners->TitleID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->TitleID) ?>',2);"><div id="elh_clientpartners_TitleID" class="clientpartners_TitleID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->TitleID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->TitleID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->TitleID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->FirstName->Visible) { // FirstName ?>
	<?php if ($clientpartners->sortUrl($clientpartners->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $clientpartners->FirstName->headerCellClass() ?>"><div id="elh_clientpartners_FirstName" class="clientpartners_FirstName"><div class="ew-table-header-caption"><?php echo $clientpartners->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $clientpartners->FirstName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->FirstName) ?>',2);"><div id="elh_clientpartners_FirstName" class="clientpartners_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->MiddleName->Visible) { // MiddleName ?>
	<?php if ($clientpartners->sortUrl($clientpartners->MiddleName) == "") { ?>
		<th data-name="MiddleName" class="<?php echo $clientpartners->MiddleName->headerCellClass() ?>"><div id="elh_clientpartners_MiddleName" class="clientpartners_MiddleName"><div class="ew-table-header-caption"><?php echo $clientpartners->MiddleName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName" class="<?php echo $clientpartners->MiddleName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->MiddleName) ?>',2);"><div id="elh_clientpartners_MiddleName" class="clientpartners_MiddleName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->MiddleName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->MiddleName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->MiddleName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->LastName->Visible) { // LastName ?>
	<?php if ($clientpartners->sortUrl($clientpartners->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $clientpartners->LastName->headerCellClass() ?>"><div id="elh_clientpartners_LastName" class="clientpartners_LastName"><div class="ew-table-header-caption"><?php echo $clientpartners->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $clientpartners->LastName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->LastName) ?>',2);"><div id="elh_clientpartners_LastName" class="clientpartners_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->JobTitle->Visible) { // JobTitle ?>
	<?php if ($clientpartners->sortUrl($clientpartners->JobTitle) == "") { ?>
		<th data-name="JobTitle" class="<?php echo $clientpartners->JobTitle->headerCellClass() ?>"><div id="elh_clientpartners_JobTitle" class="clientpartners_JobTitle"><div class="ew-table-header-caption"><?php echo $clientpartners->JobTitle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JobTitle" class="<?php echo $clientpartners->JobTitle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->JobTitle) ?>',2);"><div id="elh_clientpartners_JobTitle" class="clientpartners_JobTitle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->JobTitle->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->JobTitle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->JobTitle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->Photo->Visible) { // Photo ?>
	<?php if ($clientpartners->sortUrl($clientpartners->Photo) == "") { ?>
		<th data-name="Photo" class="<?php echo $clientpartners->Photo->headerCellClass() ?>"><div id="elh_clientpartners_Photo" class="clientpartners_Photo"><div class="ew-table-header-caption"><?php echo $clientpartners->Photo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Photo" class="<?php echo $clientpartners->Photo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->Photo) ?>',2);"><div id="elh_clientpartners_Photo" class="clientpartners_Photo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->Photo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->Photo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->Photo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->BirthDate->Visible) { // BirthDate ?>
	<?php if ($clientpartners->sortUrl($clientpartners->BirthDate) == "") { ?>
		<th data-name="BirthDate" class="<?php echo $clientpartners->BirthDate->headerCellClass() ?>"><div id="elh_clientpartners_BirthDate" class="clientpartners_BirthDate"><div class="ew-table-header-caption"><?php echo $clientpartners->BirthDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BirthDate" class="<?php echo $clientpartners->BirthDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->BirthDate) ?>',2);"><div id="elh_clientpartners_BirthDate" class="clientpartners_BirthDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->BirthDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->BirthDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->BirthDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->MaritalStatusID->Visible) { // MaritalStatusID ?>
	<?php if ($clientpartners->sortUrl($clientpartners->MaritalStatusID) == "") { ?>
		<th data-name="MaritalStatusID" class="<?php echo $clientpartners->MaritalStatusID->headerCellClass() ?>"><div id="elh_clientpartners_MaritalStatusID" class="clientpartners_MaritalStatusID"><div class="ew-table-header-caption"><?php echo $clientpartners->MaritalStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MaritalStatusID" class="<?php echo $clientpartners->MaritalStatusID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->MaritalStatusID) ?>',2);"><div id="elh_clientpartners_MaritalStatusID" class="clientpartners_MaritalStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->MaritalStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->MaritalStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->MaritalStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->CivilStatus23->Visible) { // CivilStatus# ?>
	<?php if ($clientpartners->sortUrl($clientpartners->CivilStatus23) == "") { ?>
		<th data-name="CivilStatus23" class="<?php echo $clientpartners->CivilStatus23->headerCellClass() ?>"><div id="elh_clientpartners_CivilStatus23" class="clientpartners_CivilStatus23"><div class="ew-table-header-caption"><?php echo $clientpartners->CivilStatus23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CivilStatus23" class="<?php echo $clientpartners->CivilStatus23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->CivilStatus23) ?>',2);"><div id="elh_clientpartners_CivilStatus23" class="clientpartners_CivilStatus23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->CivilStatus23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->CivilStatus23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->CivilStatus23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->CivilStatusPlace->Visible) { // CivilStatusPlace ?>
	<?php if ($clientpartners->sortUrl($clientpartners->CivilStatusPlace) == "") { ?>
		<th data-name="CivilStatusPlace" class="<?php echo $clientpartners->CivilStatusPlace->headerCellClass() ?>"><div id="elh_clientpartners_CivilStatusPlace" class="clientpartners_CivilStatusPlace"><div class="ew-table-header-caption"><?php echo $clientpartners->CivilStatusPlace->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CivilStatusPlace" class="<?php echo $clientpartners->CivilStatusPlace->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->CivilStatusPlace) ?>',2);"><div id="elh_clientpartners_CivilStatusPlace" class="clientpartners_CivilStatusPlace">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->CivilStatusPlace->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->CivilStatusPlace->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->CivilStatusPlace->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->IdCard23->Visible) { // IdCard# ?>
	<?php if ($clientpartners->sortUrl($clientpartners->IdCard23) == "") { ?>
		<th data-name="IdCard23" class="<?php echo $clientpartners->IdCard23->headerCellClass() ?>"><div id="elh_clientpartners_IdCard23" class="clientpartners_IdCard23"><div class="ew-table-header-caption"><?php echo $clientpartners->IdCard23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IdCard23" class="<?php echo $clientpartners->IdCard23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->IdCard23) ?>',2);"><div id="elh_clientpartners_IdCard23" class="clientpartners_IdCard23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->IdCard23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->IdCard23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->IdCard23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->Nationality1->Visible) { // Nationality1 ?>
	<?php if ($clientpartners->sortUrl($clientpartners->Nationality1) == "") { ?>
		<th data-name="Nationality1" class="<?php echo $clientpartners->Nationality1->headerCellClass() ?>"><div id="elh_clientpartners_Nationality1" class="clientpartners_Nationality1"><div class="ew-table-header-caption"><?php echo $clientpartners->Nationality1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nationality1" class="<?php echo $clientpartners->Nationality1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->Nationality1) ?>',2);"><div id="elh_clientpartners_Nationality1" class="clientpartners_Nationality1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->Nationality1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->Nationality1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->Nationality1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->Nationality2->Visible) { // Nationality2 ?>
	<?php if ($clientpartners->sortUrl($clientpartners->Nationality2) == "") { ?>
		<th data-name="Nationality2" class="<?php echo $clientpartners->Nationality2->headerCellClass() ?>"><div id="elh_clientpartners_Nationality2" class="clientpartners_Nationality2"><div class="ew-table-header-caption"><?php echo $clientpartners->Nationality2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nationality2" class="<?php echo $clientpartners->Nationality2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->Nationality2) ?>',2);"><div id="elh_clientpartners_Nationality2" class="clientpartners_Nationality2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->Nationality2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->Nationality2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->Nationality2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientpartners->Extra23->Visible) { // Extra# ?>
	<?php if ($clientpartners->sortUrl($clientpartners->Extra23) == "") { ?>
		<th data-name="Extra23" class="<?php echo $clientpartners->Extra23->headerCellClass() ?>"><div id="elh_clientpartners_Extra23" class="clientpartners_Extra23"><div class="ew-table-header-caption"><?php echo $clientpartners->Extra23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Extra23" class="<?php echo $clientpartners->Extra23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clientpartners->SortUrl($clientpartners->Extra23) ?>',2);"><div id="elh_clientpartners_Extra23" class="clientpartners_Extra23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientpartners->Extra23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientpartners->Extra23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clientpartners->Extra23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$clientpartners_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($clientpartners->ExportAll && $clientpartners->isExport()) {
	$clientpartners_list->StopRec = $clientpartners_list->TotalRecs;
} else {

	// Set the last record to display
	if ($clientpartners_list->TotalRecs > $clientpartners_list->StartRec + $clientpartners_list->DisplayRecs - 1)
		$clientpartners_list->StopRec = $clientpartners_list->StartRec + $clientpartners_list->DisplayRecs - 1;
	else
		$clientpartners_list->StopRec = $clientpartners_list->TotalRecs;
}
$clientpartners_list->RecCnt = $clientpartners_list->StartRec - 1;
if ($clientpartners_list->Recordset && !$clientpartners_list->Recordset->EOF) {
	$clientpartners_list->Recordset->moveFirst();
	$selectLimit = $clientpartners_list->UseSelectLimit;
	if (!$selectLimit && $clientpartners_list->StartRec > 1)
		$clientpartners_list->Recordset->move($clientpartners_list->StartRec - 1);
} elseif (!$clientpartners->AllowAddDeleteRow && $clientpartners_list->StopRec == 0) {
	$clientpartners_list->StopRec = $clientpartners->GridAddRowCount;
}

// Initialize aggregate
$clientpartners->RowType = ROWTYPE_AGGREGATEINIT;
$clientpartners->resetAttributes();
$clientpartners_list->renderRow();
while ($clientpartners_list->RecCnt < $clientpartners_list->StopRec) {
	$clientpartners_list->RecCnt++;
	if ($clientpartners_list->RecCnt >= $clientpartners_list->StartRec) {
		$clientpartners_list->RowCnt++;

		// Set up key count
		$clientpartners_list->KeyCount = $clientpartners_list->RowIndex;

		// Init row class and style
		$clientpartners->resetAttributes();
		$clientpartners->CssClass = "";
		if ($clientpartners->isGridAdd()) {
		} else {
			$clientpartners_list->loadRowValues($clientpartners_list->Recordset); // Load row values
		}
		$clientpartners->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$clientpartners->RowAttrs = array_merge($clientpartners->RowAttrs, array('data-rowindex'=>$clientpartners_list->RowCnt, 'id'=>'r' . $clientpartners_list->RowCnt . '_clientpartners', 'data-rowtype'=>$clientpartners->RowType));

		// Render row
		$clientpartners_list->renderRow();

		// Render list options
		$clientpartners_list->renderListOptions();
?>
	<tr<?php echo $clientpartners->rowAttributes() ?>>
<?php

// Render list options (body, left)
$clientpartners_list->ListOptions->render("body", "left", $clientpartners_list->RowCnt);
?>
	<?php if ($clientpartners->ClientID->Visible) { // ClientID ?>
		<td data-name="ClientID"<?php echo $clientpartners->ClientID->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_ClientID" class="clientpartners_ClientID">
<span<?php echo $clientpartners->ClientID->viewAttributes() ?>>
<?php echo $clientpartners->ClientID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->TitleID->Visible) { // TitleID ?>
		<td data-name="TitleID"<?php echo $clientpartners->TitleID->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_TitleID" class="clientpartners_TitleID">
<span<?php echo $clientpartners->TitleID->viewAttributes() ?>>
<?php echo $clientpartners->TitleID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $clientpartners->FirstName->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_FirstName" class="clientpartners_FirstName">
<span<?php echo $clientpartners->FirstName->viewAttributes() ?>>
<?php echo $clientpartners->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->MiddleName->Visible) { // MiddleName ?>
		<td data-name="MiddleName"<?php echo $clientpartners->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_MiddleName" class="clientpartners_MiddleName">
<span<?php echo $clientpartners->MiddleName->viewAttributes() ?>>
<?php echo $clientpartners->MiddleName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $clientpartners->LastName->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_LastName" class="clientpartners_LastName">
<span<?php echo $clientpartners->LastName->viewAttributes() ?>>
<?php echo $clientpartners->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->JobTitle->Visible) { // JobTitle ?>
		<td data-name="JobTitle"<?php echo $clientpartners->JobTitle->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_JobTitle" class="clientpartners_JobTitle">
<span<?php echo $clientpartners->JobTitle->viewAttributes() ?>>
<?php echo $clientpartners->JobTitle->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->Photo->Visible) { // Photo ?>
		<td data-name="Photo"<?php echo $clientpartners->Photo->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_Photo" class="clientpartners_Photo">
<span>
<?php echo GetFileViewTag($clientpartners->Photo, $clientpartners->Photo->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->BirthDate->Visible) { // BirthDate ?>
		<td data-name="BirthDate"<?php echo $clientpartners->BirthDate->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_BirthDate" class="clientpartners_BirthDate">
<span<?php echo $clientpartners->BirthDate->viewAttributes() ?>>
<?php echo $clientpartners->BirthDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->MaritalStatusID->Visible) { // MaritalStatusID ?>
		<td data-name="MaritalStatusID"<?php echo $clientpartners->MaritalStatusID->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_MaritalStatusID" class="clientpartners_MaritalStatusID">
<span<?php echo $clientpartners->MaritalStatusID->viewAttributes() ?>>
<?php echo $clientpartners->MaritalStatusID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->CivilStatus23->Visible) { // CivilStatus# ?>
		<td data-name="CivilStatus23"<?php echo $clientpartners->CivilStatus23->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_CivilStatus23" class="clientpartners_CivilStatus23">
<span<?php echo $clientpartners->CivilStatus23->viewAttributes() ?>>
<?php echo $clientpartners->CivilStatus23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->CivilStatusPlace->Visible) { // CivilStatusPlace ?>
		<td data-name="CivilStatusPlace"<?php echo $clientpartners->CivilStatusPlace->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_CivilStatusPlace" class="clientpartners_CivilStatusPlace">
<span<?php echo $clientpartners->CivilStatusPlace->viewAttributes() ?>>
<?php echo $clientpartners->CivilStatusPlace->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->IdCard23->Visible) { // IdCard# ?>
		<td data-name="IdCard23"<?php echo $clientpartners->IdCard23->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_IdCard23" class="clientpartners_IdCard23">
<span<?php echo $clientpartners->IdCard23->viewAttributes() ?>>
<?php echo $clientpartners->IdCard23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->Nationality1->Visible) { // Nationality1 ?>
		<td data-name="Nationality1"<?php echo $clientpartners->Nationality1->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_Nationality1" class="clientpartners_Nationality1">
<span<?php echo $clientpartners->Nationality1->viewAttributes() ?>>
<?php echo $clientpartners->Nationality1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->Nationality2->Visible) { // Nationality2 ?>
		<td data-name="Nationality2"<?php echo $clientpartners->Nationality2->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_Nationality2" class="clientpartners_Nationality2">
<span<?php echo $clientpartners->Nationality2->viewAttributes() ?>>
<?php echo $clientpartners->Nationality2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientpartners->Extra23->Visible) { // Extra# ?>
		<td data-name="Extra23"<?php echo $clientpartners->Extra23->cellAttributes() ?>>
<span id="el<?php echo $clientpartners_list->RowCnt ?>_clientpartners_Extra23" class="clientpartners_Extra23">
<span<?php echo $clientpartners->Extra23->viewAttributes() ?>>
<?php echo $clientpartners->Extra23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$clientpartners_list->ListOptions->render("body", "right", $clientpartners_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$clientpartners->isGridAdd())
		$clientpartners_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$clientpartners->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($clientpartners_list->Recordset)
	$clientpartners_list->Recordset->Close();
?>
<?php if (!$clientpartners->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$clientpartners->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($clientpartners_list->Pager)) $clientpartners_list->Pager = new PrevNextPager($clientpartners_list->StartRec, $clientpartners_list->DisplayRecs, $clientpartners_list->TotalRecs, $clientpartners_list->AutoHidePager) ?>
<?php if ($clientpartners_list->Pager->RecordCount > 0 && $clientpartners_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clientpartners_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clientpartners_list->pageUrl() ?>start=<?php echo $clientpartners_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clientpartners_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clientpartners_list->pageUrl() ?>start=<?php echo $clientpartners_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clientpartners_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clientpartners_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clientpartners_list->pageUrl() ?>start=<?php echo $clientpartners_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clientpartners_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clientpartners_list->pageUrl() ?>start=<?php echo $clientpartners_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clientpartners_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($clientpartners_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $clientpartners_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $clientpartners_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $clientpartners_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($clientpartners_list->TotalRecs > 0 && (!$clientpartners_list->AutoHidePageSizeSelector || $clientpartners_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="clientpartners">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($clientpartners_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($clientpartners_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($clientpartners_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($clientpartners_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($clientpartners_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($clientpartners_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($clientpartners_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($clientpartners_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($clientpartners_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($clientpartners->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $clientpartners_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($clientpartners_list->TotalRecs == 0 && !$clientpartners->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $clientpartners_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$clientpartners_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$clientpartners->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$clientpartners->isExport()) { ?>
<script>
ew.scrollableTable("gmp_clientpartners", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$clientpartners_list->terminate();
?>
