<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$clients_view = new clients_view();

// Run the page
$clients_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clients_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$clients->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fclientsview = currentForm = new ew.Form("fclientsview", "view");

// Form_CustomValidate event
fclientsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclientsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclientsview.lists["x_ClientTypeID"] = <?php echo $clients_view->ClientTypeID->Lookup->toClientList() ?>;
fclientsview.lists["x_ClientTypeID"].options = <?php echo JsonEncode($clients_view->ClientTypeID->lookupOptions()) ?>;
fclientsview.lists["x_ClientGroupID"] = <?php echo $clients_view->ClientGroupID->Lookup->toClientList() ?>;
fclientsview.lists["x_ClientGroupID"].options = <?php echo JsonEncode($clients_view->ClientGroupID->lookupOptions()) ?>;
fclientsview.autoSuggests["x_ClientGroupID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclientsview.lists["x_TitleID"] = <?php echo $clients_view->TitleID->Lookup->toClientList() ?>;
fclientsview.lists["x_TitleID"].options = <?php echo JsonEncode($clients_view->TitleID->lookupOptions()) ?>;
fclientsview.lists["x_Gender"] = <?php echo $clients_view->Gender->Lookup->toClientList() ?>;
fclientsview.lists["x_Gender"].options = <?php echo JsonEncode($clients_view->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$clients->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $clients_view->ExportOptions->render("body") ?>
<?php $clients_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $clients_view->showPageHeader(); ?>
<?php
$clients_view->showMessage();
?>
<?php if (!$clients_view->IsModal) { ?>
<?php if (!$clients->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($clients_view->Pager)) $clients_view->Pager = new PrevNextPager($clients_view->StartRec, $clients_view->DisplayRecs, $clients_view->TotalRecs, $clients_view->AutoHidePager) ?>
<?php if ($clients_view->Pager->RecordCount > 0 && $clients_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clients_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clients_view->pageUrl() ?>start=<?php echo $clients_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clients_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clients_view->pageUrl() ?>start=<?php echo $clients_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clients_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clients_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clients_view->pageUrl() ?>start=<?php echo $clients_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clients_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clients_view->pageUrl() ?>start=<?php echo $clients_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clients_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fclientsview" id="fclientsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($clients_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $clients_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="clients">
<input type="hidden" name="modal" value="<?php echo (int)$clients_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($clients->ClientID->Visible) { // ClientID ?>
	<tr id="r_ClientID">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_ClientID"><?php echo $clients->ClientID->caption() ?></span></td>
		<td data-name="ClientID"<?php echo $clients->ClientID->cellAttributes() ?>>
<span id="el_clients_ClientID">
<span<?php echo $clients->ClientID->viewAttributes() ?>>
<?php echo $clients->ClientID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->ClientTypeID->Visible) { // ClientTypeID ?>
	<tr id="r_ClientTypeID">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_ClientTypeID"><?php echo $clients->ClientTypeID->caption() ?></span></td>
		<td data-name="ClientTypeID"<?php echo $clients->ClientTypeID->cellAttributes() ?>>
<span id="el_clients_ClientTypeID">
<span<?php echo $clients->ClientTypeID->viewAttributes() ?>>
<?php echo $clients->ClientTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->ClientGroupID->Visible) { // ClientGroupID ?>
	<tr id="r_ClientGroupID">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_ClientGroupID"><?php echo $clients->ClientGroupID->caption() ?></span></td>
		<td data-name="ClientGroupID"<?php echo $clients->ClientGroupID->cellAttributes() ?>>
<span id="el_clients_ClientGroupID">
<span<?php echo $clients->ClientGroupID->viewAttributes() ?>>
<?php echo $clients->ClientGroupID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->TitleID->Visible) { // TitleID ?>
	<tr id="r_TitleID">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_TitleID"><?php echo $clients->TitleID->caption() ?></span></td>
		<td data-name="TitleID"<?php echo $clients->TitleID->cellAttributes() ?>>
<span id="el_clients_TitleID">
<span<?php echo $clients->TitleID->viewAttributes() ?>>
<?php echo $clients->TitleID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->FirstName->Visible) { // FirstName ?>
	<tr id="r_FirstName">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_FirstName"><?php echo $clients->FirstName->caption() ?></span></td>
		<td data-name="FirstName"<?php echo $clients->FirstName->cellAttributes() ?>>
<span id="el_clients_FirstName">
<span<?php echo $clients->FirstName->viewAttributes() ?>>
<?php echo $clients->FirstName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->MiddleName->Visible) { // MiddleName ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_MiddleName"><?php echo $clients->MiddleName->caption() ?></span></td>
		<td data-name="MiddleName"<?php echo $clients->MiddleName->cellAttributes() ?>>
<span id="el_clients_MiddleName">
<span<?php echo $clients->MiddleName->viewAttributes() ?>>
<?php echo $clients->MiddleName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->LastName->Visible) { // LastName ?>
	<tr id="r_LastName">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_LastName"><?php echo $clients->LastName->caption() ?></span></td>
		<td data-name="LastName"<?php echo $clients->LastName->cellAttributes() ?>>
<span id="el_clients_LastName">
<span<?php echo $clients->LastName->viewAttributes() ?>>
<?php echo $clients->LastName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->PartnersName->Visible) { // PartnersName ?>
	<tr id="r_PartnersName">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_PartnersName"><?php echo $clients->PartnersName->caption() ?></span></td>
		<td data-name="PartnersName"<?php echo $clients->PartnersName->cellAttributes() ?>>
<span id="el_clients_PartnersName">
<span<?php echo $clients->PartnersName->viewAttributes() ?>>
<?php echo $clients->PartnersName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->CompanyName->Visible) { // CompanyName ?>
	<tr id="r_CompanyName">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_CompanyName"><?php echo $clients->CompanyName->caption() ?></span></td>
		<td data-name="CompanyName"<?php echo $clients->CompanyName->cellAttributes() ?>>
<span id="el_clients_CompanyName">
<span<?php echo $clients->CompanyName->viewAttributes() ?>>
<?php echo $clients->CompanyName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->ContactPerson->Visible) { // ContactPerson ?>
	<tr id="r_ContactPerson">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_ContactPerson"><?php echo $clients->ContactPerson->caption() ?></span></td>
		<td data-name="ContactPerson"<?php echo $clients->ContactPerson->cellAttributes() ?>>
<span id="el_clients_ContactPerson">
<span<?php echo $clients->ContactPerson->viewAttributes() ?>>
<?php echo $clients->ContactPerson->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->WorkNature->Visible) { // WorkNature ?>
	<tr id="r_WorkNature">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_WorkNature"><?php echo $clients->WorkNature->caption() ?></span></td>
		<td data-name="WorkNature"<?php echo $clients->WorkNature->cellAttributes() ?>>
<span id="el_clients_WorkNature">
<span<?php echo $clients->WorkNature->viewAttributes() ?>>
<?php echo $clients->WorkNature->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->JobTitle->Visible) { // JobTitle ?>
	<tr id="r_JobTitle">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_JobTitle"><?php echo $clients->JobTitle->caption() ?></span></td>
		<td data-name="JobTitle"<?php echo $clients->JobTitle->cellAttributes() ?>>
<span id="el_clients_JobTitle">
<span<?php echo $clients->JobTitle->viewAttributes() ?>>
<?php echo $clients->JobTitle->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->Photo->Visible) { // Photo ?>
	<tr id="r_Photo">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_Photo"><?php echo $clients->Photo->caption() ?></span></td>
		<td data-name="Photo"<?php echo $clients->Photo->cellAttributes() ?>>
<span id="el_clients_Photo">
<span>
<?php echo GetFileViewTag($clients->Photo, $clients->Photo->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->BirthDate->Visible) { // BirthDate ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_BirthDate"><?php echo $clients->BirthDate->caption() ?></span></td>
		<td data-name="BirthDate"<?php echo $clients->BirthDate->cellAttributes() ?>>
<span id="el_clients_BirthDate">
<span<?php echo $clients->BirthDate->viewAttributes() ?>>
<?php echo $clients->BirthDate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->Gender->Visible) { // Gender ?>
	<tr id="r_Gender">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_Gender"><?php echo $clients->Gender->caption() ?></span></td>
		<td data-name="Gender"<?php echo $clients->Gender->cellAttributes() ?>>
<span id="el_clients_Gender">
<span<?php echo $clients->Gender->viewAttributes() ?>>
<?php echo $clients->Gender->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($clients->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $clients_view->TableLeftColumnClass ?>"><span id="elh_clients_Notes"><?php echo $clients->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $clients->Notes->cellAttributes() ?>>
<span id="el_clients_Notes">
<span<?php echo $clients->Notes->viewAttributes() ?>>
<?php echo $clients->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$clients_view->IsModal) { ?>
<?php if (!$clients->isExport()) { ?>
<?php if (!isset($clients_view->Pager)) $clients_view->Pager = new PrevNextPager($clients_view->StartRec, $clients_view->DisplayRecs, $clients_view->TotalRecs, $clients_view->AutoHidePager) ?>
<?php if ($clients_view->Pager->RecordCount > 0 && $clients_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clients_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clients_view->pageUrl() ?>start=<?php echo $clients_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clients_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clients_view->pageUrl() ?>start=<?php echo $clients_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clients_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clients_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clients_view->pageUrl() ?>start=<?php echo $clients_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clients_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clients_view->pageUrl() ?>start=<?php echo $clients_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clients_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php if ($clients->getCurrentDetailTable() <> "") { ?>
<?php
	$clients_view->DetailPages->ValidKeys = explode(",", $clients->getCurrentDetailTable());
	$firstActiveDetailTable = $clients_view->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="clients_view_details"><!-- tabs -->
	<ul class="<?php echo $clients_view->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("cases", explode(",", $clients->getCurrentDetailTable())) && $cases->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "cases") {
			$firstActiveDetailTable = "cases";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_view->DetailPages->pageStyle("cases") ?>" href="#tab_cases" data-toggle="tab"><?php echo $Language->TablePhrase("cases", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $clients_view->cases_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("clientadditinalinfo", explode(",", $clients->getCurrentDetailTable())) && $clientadditinalinfo->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientadditinalinfo") {
			$firstActiveDetailTable = "clientadditinalinfo";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_view->DetailPages->pageStyle("clientadditinalinfo") ?>" href="#tab_clientadditinalinfo" data-toggle="tab"><?php echo $Language->TablePhrase("clientadditinalinfo", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $clients_view->clientadditinalinfo_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("clientaddress", explode(",", $clients->getCurrentDetailTable())) && $clientaddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientaddress") {
			$firstActiveDetailTable = "clientaddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_view->DetailPages->pageStyle("clientaddress") ?>" href="#tab_clientaddress" data-toggle="tab"><?php echo $Language->TablePhrase("clientaddress", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $clients_view->clientaddress_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("clientcontact", explode(",", $clients->getCurrentDetailTable())) && $clientcontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientcontact") {
			$firstActiveDetailTable = "clientcontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_view->DetailPages->pageStyle("clientcontact") ?>" href="#tab_clientcontact" data-toggle="tab"><?php echo $Language->TablePhrase("clientcontact", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $clients_view->clientcontact_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("clientpartners", explode(",", $clients->getCurrentDetailTable())) && $clientpartners->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientpartners") {
			$firstActiveDetailTable = "clientpartners";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_view->DetailPages->pageStyle("clientpartners") ?>" href="#tab_clientpartners" data-toggle="tab"><?php echo $Language->TablePhrase("clientpartners", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $clients_view->clientpartners_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("cases", explode(",", $clients->getCurrentDetailTable())) && $cases->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "cases")
			$firstActiveDetailTable = "cases";
?>
		<div class="tab-pane<?php echo $clients_view->DetailPages->pageStyle("cases") ?>" id="tab_cases"><!-- page* -->
<?php include_once "casesgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("clientadditinalinfo", explode(",", $clients->getCurrentDetailTable())) && $clientadditinalinfo->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientadditinalinfo")
			$firstActiveDetailTable = "clientadditinalinfo";
?>
		<div class="tab-pane<?php echo $clients_view->DetailPages->pageStyle("clientadditinalinfo") ?>" id="tab_clientadditinalinfo"><!-- page* -->
<?php include_once "clientadditinalinfogrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("clientaddress", explode(",", $clients->getCurrentDetailTable())) && $clientaddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientaddress")
			$firstActiveDetailTable = "clientaddress";
?>
		<div class="tab-pane<?php echo $clients_view->DetailPages->pageStyle("clientaddress") ?>" id="tab_clientaddress"><!-- page* -->
<?php include_once "clientaddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("clientcontact", explode(",", $clients->getCurrentDetailTable())) && $clientcontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientcontact")
			$firstActiveDetailTable = "clientcontact";
?>
		<div class="tab-pane<?php echo $clients_view->DetailPages->pageStyle("clientcontact") ?>" id="tab_clientcontact"><!-- page* -->
<?php include_once "clientcontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("clientpartners", explode(",", $clients->getCurrentDetailTable())) && $clientpartners->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientpartners")
			$firstActiveDetailTable = "clientpartners";
?>
		<div class="tab-pane<?php echo $clients_view->DetailPages->pageStyle("clientpartners") ?>" id="tab_clientpartners"><!-- page* -->
<?php include_once "clientpartnersgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
</form>
<?php
$clients_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$clients->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$clients_view->terminate();
?>
