<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$complaints_edit = new complaints_edit();

// Run the page
$complaints_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$complaints_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fcomplaintsedit = currentForm = new ew.Form("fcomplaintsedit", "edit");

// Validate form
fcomplaintsedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($complaints_edit->ComplaintID->Required) { ?>
			elm = this.getElements("x" + infix + "_ComplaintID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->ComplaintID->caption(), $complaints->ComplaintID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($complaints_edit->CaseNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->CaseNumber->caption(), $complaints->CaseNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($complaints_edit->FileNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_FileNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->FileNumber->caption(), $complaints->FileNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($complaints_edit->ComplaintDate->Required) { ?>
			elm = this.getElements("x" + infix + "_ComplaintDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->ComplaintDate->caption(), $complaints->ComplaintDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ComplaintDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($complaints->ComplaintDate->errorMessage()) ?>");
		<?php if ($complaints_edit->ComplaintTime->Required) { ?>
			elm = this.getElements("x" + infix + "_ComplaintTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->ComplaintTime->caption(), $complaints->ComplaintTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ComplaintTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($complaints->ComplaintTime->errorMessage()) ?>");
		<?php if ($complaints_edit->Complaint->Required) { ?>
			elm = this.getElements("x" + infix + "_Complaint");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->Complaint->caption(), $complaints->Complaint->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($complaints_edit->NextComplaintTime->Required) { ?>
			elm = this.getElements("x" + infix + "_NextComplaintTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->NextComplaintTime->caption(), $complaints->NextComplaintTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NextComplaintTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($complaints->NextComplaintTime->errorMessage()) ?>");
		<?php if ($complaints_edit->CaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->CaseID->caption(), $complaints->CaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_CaseID");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($complaints->CaseID->errorMessage()) ?>");
		<?php if ($complaints_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $complaints->Notes->caption(), $complaints->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcomplaintsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcomplaintsedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $complaints_edit->showPageHeader(); ?>
<?php
$complaints_edit->showMessage();
?>
<?php if (!$complaints_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($complaints_edit->Pager)) $complaints_edit->Pager = new PrevNextPager($complaints_edit->StartRec, $complaints_edit->DisplayRecs, $complaints_edit->TotalRecs, $complaints_edit->AutoHidePager) ?>
<?php if ($complaints_edit->Pager->RecordCount > 0 && $complaints_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($complaints_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $complaints_edit->pageUrl() ?>start=<?php echo $complaints_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($complaints_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $complaints_edit->pageUrl() ?>start=<?php echo $complaints_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $complaints_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($complaints_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $complaints_edit->pageUrl() ?>start=<?php echo $complaints_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($complaints_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $complaints_edit->pageUrl() ?>start=<?php echo $complaints_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $complaints_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fcomplaintsedit" id="fcomplaintsedit" class="<?php echo $complaints_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($complaints_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $complaints_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="complaints">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$complaints_edit->IsModal ?>">
<?php if ($complaints->getCurrentMasterTable() == "cases") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="cases">
<input type="hidden" name="fk_CaseID" value="<?php echo $complaints->CaseID->getSessionValue() ?>">
<?php } ?>
<?php if (!$complaints_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_complaintsedit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($complaints->CaseNumber->Visible) { // CaseNumber ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
	<div id="r_CaseNumber" class="form-group row">
		<label id="elh_complaints_CaseNumber" for="x_CaseNumber" class="<?php echo $complaints_edit->LeftColumnClass ?>"><?php echo $complaints->CaseNumber->caption() ?><?php echo ($complaints->CaseNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $complaints_edit->RightColumnClass ?>"><div<?php echo $complaints->CaseNumber->cellAttributes() ?>>
<span id="el_complaints_CaseNumber">
<input type="text" data-table="complaints" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseNumber->EditValue ?>"<?php echo $complaints->CaseNumber->editAttributes() ?>>
</span>
<?php echo $complaints->CaseNumber->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseNumber">
		<td class="<?php echo $complaints_edit->TableLeftColumnClass ?>"><span id="elh_complaints_CaseNumber"><?php echo $complaints->CaseNumber->caption() ?><?php echo ($complaints->CaseNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $complaints->CaseNumber->cellAttributes() ?>>
<span id="el_complaints_CaseNumber">
<input type="text" data-table="complaints" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseNumber->EditValue ?>"<?php echo $complaints->CaseNumber->editAttributes() ?>>
</span>
<?php echo $complaints->CaseNumber->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->FileNumber->Visible) { // FileNumber ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
	<div id="r_FileNumber" class="form-group row">
		<label id="elh_complaints_FileNumber" for="x_FileNumber" class="<?php echo $complaints_edit->LeftColumnClass ?>"><?php echo $complaints->FileNumber->caption() ?><?php echo ($complaints->FileNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $complaints_edit->RightColumnClass ?>"><div<?php echo $complaints->FileNumber->cellAttributes() ?>>
<span id="el_complaints_FileNumber">
<input type="text" data-table="complaints" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->FileNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->FileNumber->EditValue ?>"<?php echo $complaints->FileNumber->editAttributes() ?>>
</span>
<?php echo $complaints->FileNumber->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileNumber">
		<td class="<?php echo $complaints_edit->TableLeftColumnClass ?>"><span id="elh_complaints_FileNumber"><?php echo $complaints->FileNumber->caption() ?><?php echo ($complaints->FileNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $complaints->FileNumber->cellAttributes() ?>>
<span id="el_complaints_FileNumber">
<input type="text" data-table="complaints" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->FileNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->FileNumber->EditValue ?>"<?php echo $complaints->FileNumber->editAttributes() ?>>
</span>
<?php echo $complaints->FileNumber->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->ComplaintDate->Visible) { // ComplaintDate ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
	<div id="r_ComplaintDate" class="form-group row">
		<label id="elh_complaints_ComplaintDate" for="x_ComplaintDate" class="<?php echo $complaints_edit->LeftColumnClass ?>"><?php echo $complaints->ComplaintDate->caption() ?><?php echo ($complaints->ComplaintDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $complaints_edit->RightColumnClass ?>"><div<?php echo $complaints->ComplaintDate->cellAttributes() ?>>
<span id="el_complaints_ComplaintDate">
<input type="text" data-table="complaints" data-field="x_ComplaintDate" data-format="7" name="x_ComplaintDate" id="x_ComplaintDate" placeholder="<?php echo HtmlEncode($complaints->ComplaintDate->getPlaceHolder()) ?>" value="<?php echo $complaints->ComplaintDate->EditValue ?>"<?php echo $complaints->ComplaintDate->editAttributes() ?>>
<?php if (!$complaints->ComplaintDate->ReadOnly && !$complaints->ComplaintDate->Disabled && !isset($complaints->ComplaintDate->EditAttrs["readonly"]) && !isset($complaints->ComplaintDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcomplaintsedit", "x_ComplaintDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $complaints->ComplaintDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ComplaintDate">
		<td class="<?php echo $complaints_edit->TableLeftColumnClass ?>"><span id="elh_complaints_ComplaintDate"><?php echo $complaints->ComplaintDate->caption() ?><?php echo ($complaints->ComplaintDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $complaints->ComplaintDate->cellAttributes() ?>>
<span id="el_complaints_ComplaintDate">
<input type="text" data-table="complaints" data-field="x_ComplaintDate" data-format="7" name="x_ComplaintDate" id="x_ComplaintDate" placeholder="<?php echo HtmlEncode($complaints->ComplaintDate->getPlaceHolder()) ?>" value="<?php echo $complaints->ComplaintDate->EditValue ?>"<?php echo $complaints->ComplaintDate->editAttributes() ?>>
<?php if (!$complaints->ComplaintDate->ReadOnly && !$complaints->ComplaintDate->Disabled && !isset($complaints->ComplaintDate->EditAttrs["readonly"]) && !isset($complaints->ComplaintDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcomplaintsedit", "x_ComplaintDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $complaints->ComplaintDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->ComplaintTime->Visible) { // ComplaintTime ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
	<div id="r_ComplaintTime" class="form-group row">
		<label id="elh_complaints_ComplaintTime" for="x_ComplaintTime" class="<?php echo $complaints_edit->LeftColumnClass ?>"><?php echo $complaints->ComplaintTime->caption() ?><?php echo ($complaints->ComplaintTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $complaints_edit->RightColumnClass ?>"><div<?php echo $complaints->ComplaintTime->cellAttributes() ?>>
<span id="el_complaints_ComplaintTime">
<input type="text" data-table="complaints" data-field="x_ComplaintTime" name="x_ComplaintTime" id="x_ComplaintTime" placeholder="<?php echo HtmlEncode($complaints->ComplaintTime->getPlaceHolder()) ?>" value="<?php echo $complaints->ComplaintTime->EditValue ?>"<?php echo $complaints->ComplaintTime->editAttributes() ?>>
<?php if (!$complaints->ComplaintTime->ReadOnly && !$complaints->ComplaintTime->Disabled && !isset($complaints->ComplaintTime->EditAttrs["readonly"]) && !isset($complaints->ComplaintTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fcomplaintsedit", "x_ComplaintTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $complaints->ComplaintTime->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ComplaintTime">
		<td class="<?php echo $complaints_edit->TableLeftColumnClass ?>"><span id="elh_complaints_ComplaintTime"><?php echo $complaints->ComplaintTime->caption() ?><?php echo ($complaints->ComplaintTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $complaints->ComplaintTime->cellAttributes() ?>>
<span id="el_complaints_ComplaintTime">
<input type="text" data-table="complaints" data-field="x_ComplaintTime" name="x_ComplaintTime" id="x_ComplaintTime" placeholder="<?php echo HtmlEncode($complaints->ComplaintTime->getPlaceHolder()) ?>" value="<?php echo $complaints->ComplaintTime->EditValue ?>"<?php echo $complaints->ComplaintTime->editAttributes() ?>>
<?php if (!$complaints->ComplaintTime->ReadOnly && !$complaints->ComplaintTime->Disabled && !isset($complaints->ComplaintTime->EditAttrs["readonly"]) && !isset($complaints->ComplaintTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fcomplaintsedit", "x_ComplaintTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $complaints->ComplaintTime->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->Complaint->Visible) { // Complaint ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
	<div id="r_Complaint" class="form-group row">
		<label id="elh_complaints_Complaint" for="x_Complaint" class="<?php echo $complaints_edit->LeftColumnClass ?>"><?php echo $complaints->Complaint->caption() ?><?php echo ($complaints->Complaint->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $complaints_edit->RightColumnClass ?>"><div<?php echo $complaints->Complaint->cellAttributes() ?>>
<span id="el_complaints_Complaint">
<textarea data-table="complaints" data-field="x_Complaint" name="x_Complaint" id="x_Complaint" cols="35" rows="2" placeholder="<?php echo HtmlEncode($complaints->Complaint->getPlaceHolder()) ?>"<?php echo $complaints->Complaint->editAttributes() ?>><?php echo $complaints->Complaint->EditValue ?></textarea>
</span>
<?php echo $complaints->Complaint->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Complaint">
		<td class="<?php echo $complaints_edit->TableLeftColumnClass ?>"><span id="elh_complaints_Complaint"><?php echo $complaints->Complaint->caption() ?><?php echo ($complaints->Complaint->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $complaints->Complaint->cellAttributes() ?>>
<span id="el_complaints_Complaint">
<textarea data-table="complaints" data-field="x_Complaint" name="x_Complaint" id="x_Complaint" cols="35" rows="2" placeholder="<?php echo HtmlEncode($complaints->Complaint->getPlaceHolder()) ?>"<?php echo $complaints->Complaint->editAttributes() ?>><?php echo $complaints->Complaint->EditValue ?></textarea>
</span>
<?php echo $complaints->Complaint->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->NextComplaintTime->Visible) { // NextComplaintTime ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
	<div id="r_NextComplaintTime" class="form-group row">
		<label id="elh_complaints_NextComplaintTime" for="x_NextComplaintTime" class="<?php echo $complaints_edit->LeftColumnClass ?>"><?php echo $complaints->NextComplaintTime->caption() ?><?php echo ($complaints->NextComplaintTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $complaints_edit->RightColumnClass ?>"><div<?php echo $complaints->NextComplaintTime->cellAttributes() ?>>
<span id="el_complaints_NextComplaintTime">
<input type="text" data-table="complaints" data-field="x_NextComplaintTime" name="x_NextComplaintTime" id="x_NextComplaintTime" placeholder="<?php echo HtmlEncode($complaints->NextComplaintTime->getPlaceHolder()) ?>" value="<?php echo $complaints->NextComplaintTime->EditValue ?>"<?php echo $complaints->NextComplaintTime->editAttributes() ?>>
<?php if (!$complaints->NextComplaintTime->ReadOnly && !$complaints->NextComplaintTime->Disabled && !isset($complaints->NextComplaintTime->EditAttrs["readonly"]) && !isset($complaints->NextComplaintTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fcomplaintsedit", "x_NextComplaintTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $complaints->NextComplaintTime->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_NextComplaintTime">
		<td class="<?php echo $complaints_edit->TableLeftColumnClass ?>"><span id="elh_complaints_NextComplaintTime"><?php echo $complaints->NextComplaintTime->caption() ?><?php echo ($complaints->NextComplaintTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $complaints->NextComplaintTime->cellAttributes() ?>>
<span id="el_complaints_NextComplaintTime">
<input type="text" data-table="complaints" data-field="x_NextComplaintTime" name="x_NextComplaintTime" id="x_NextComplaintTime" placeholder="<?php echo HtmlEncode($complaints->NextComplaintTime->getPlaceHolder()) ?>" value="<?php echo $complaints->NextComplaintTime->EditValue ?>"<?php echo $complaints->NextComplaintTime->editAttributes() ?>>
<?php if (!$complaints->NextComplaintTime->ReadOnly && !$complaints->NextComplaintTime->Disabled && !isset($complaints->NextComplaintTime->EditAttrs["readonly"]) && !isset($complaints->NextComplaintTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fcomplaintsedit", "x_NextComplaintTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $complaints->NextComplaintTime->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->CaseID->Visible) { // CaseID ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
	<div id="r_CaseID" class="form-group row">
		<label id="elh_complaints_CaseID" for="x_CaseID" class="<?php echo $complaints_edit->LeftColumnClass ?>"><?php echo $complaints->CaseID->caption() ?><?php echo ($complaints->CaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $complaints_edit->RightColumnClass ?>"><div<?php echo $complaints->CaseID->cellAttributes() ?>>
<?php if ($complaints->CaseID->getSessionValue() <> "") { ?>
<span id="el_complaints_CaseID">
<span<?php echo $complaints->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($complaints->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_CaseID" name="x_CaseID" value="<?php echo HtmlEncode($complaints->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_complaints_CaseID">
<input type="text" data-table="complaints" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" size="30" placeholder="<?php echo HtmlEncode($complaints->CaseID->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseID->EditValue ?>"<?php echo $complaints->CaseID->editAttributes() ?>>
</span>
<?php } ?>
<?php echo $complaints->CaseID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseID">
		<td class="<?php echo $complaints_edit->TableLeftColumnClass ?>"><span id="elh_complaints_CaseID"><?php echo $complaints->CaseID->caption() ?><?php echo ($complaints->CaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $complaints->CaseID->cellAttributes() ?>>
<?php if ($complaints->CaseID->getSessionValue() <> "") { ?>
<span id="el_complaints_CaseID">
<span<?php echo $complaints->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($complaints->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_CaseID" name="x_CaseID" value="<?php echo HtmlEncode($complaints->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_complaints_CaseID">
<input type="text" data-table="complaints" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" size="30" placeholder="<?php echo HtmlEncode($complaints->CaseID->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseID->EditValue ?>"<?php echo $complaints->CaseID->editAttributes() ?>>
</span>
<?php } ?>
<?php echo $complaints->CaseID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->Notes->Visible) { // Notes ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_complaints_Notes" class="<?php echo $complaints_edit->LeftColumnClass ?>"><?php echo $complaints->Notes->caption() ?><?php echo ($complaints->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $complaints_edit->RightColumnClass ?>"><div<?php echo $complaints->Notes->cellAttributes() ?>>
<span id="el_complaints_Notes">
<?php AppendClass($complaints->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="complaints" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($complaints->Notes->getPlaceHolder()) ?>"<?php echo $complaints->Notes->editAttributes() ?>><?php echo $complaints->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcomplaintsedit", "x_Notes", 35, 4, <?php echo ($complaints->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $complaints->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $complaints_edit->TableLeftColumnClass ?>"><span id="elh_complaints_Notes"><?php echo $complaints->Notes->caption() ?><?php echo ($complaints->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $complaints->Notes->cellAttributes() ?>>
<span id="el_complaints_Notes">
<?php AppendClass($complaints->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="complaints" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($complaints->Notes->getPlaceHolder()) ?>"<?php echo $complaints->Notes->editAttributes() ?>><?php echo $complaints->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcomplaintsedit", "x_Notes", 35, 4, <?php echo ($complaints->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $complaints->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<span id="el_complaints_ComplaintID">
<input type="hidden" data-table="complaints" data-field="x_ComplaintID" name="x_ComplaintID" id="x_ComplaintID" value="<?php echo HtmlEncode($complaints->ComplaintID->CurrentValue) ?>">
</span>
<?php if (!$complaints_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $complaints_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $complaints_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$complaints_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$complaints_edit->IsModal) { ?>
<?php if (!isset($complaints_edit->Pager)) $complaints_edit->Pager = new PrevNextPager($complaints_edit->StartRec, $complaints_edit->DisplayRecs, $complaints_edit->TotalRecs, $complaints_edit->AutoHidePager) ?>
<?php if ($complaints_edit->Pager->RecordCount > 0 && $complaints_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($complaints_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $complaints_edit->pageUrl() ?>start=<?php echo $complaints_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($complaints_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $complaints_edit->pageUrl() ?>start=<?php echo $complaints_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $complaints_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($complaints_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $complaints_edit->pageUrl() ?>start=<?php echo $complaints_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($complaints_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $complaints_edit->pageUrl() ?>start=<?php echo $complaints_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $complaints_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$complaints_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$complaints_edit->terminate();
?>
