<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$contacts_add = new contacts_add();

// Run the page
$contacts_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$contacts_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcontactsadd = currentForm = new ew.Form("fcontactsadd", "add");

// Validate form
fcontactsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($contacts_add->ContactTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_ContactTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $contacts->ContactTypeID->caption(), $contacts->ContactTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($contacts_add->Contact->Required) { ?>
			elm = this.getElements("x" + infix + "_Contact");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $contacts->Contact->caption(), $contacts->Contact->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($contacts_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $contacts->Notes->caption(), $contacts->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($contacts_add->Primary->Required) { ?>
			elm = this.getElements("x" + infix + "_Primary[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $contacts->Primary->caption(), $contacts->Primary->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcontactsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcontactsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcontactsadd.lists["x_ContactTypeID"] = <?php echo $contacts_add->ContactTypeID->Lookup->toClientList() ?>;
fcontactsadd.lists["x_ContactTypeID"].options = <?php echo JsonEncode($contacts_add->ContactTypeID->lookupOptions()) ?>;
fcontactsadd.lists["x_Primary[]"] = <?php echo $contacts_add->Primary->Lookup->toClientList() ?>;
fcontactsadd.lists["x_Primary[]"].options = <?php echo JsonEncode($contacts_add->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $contacts_add->showPageHeader(); ?>
<?php
$contacts_add->showMessage();
?>
<form name="fcontactsadd" id="fcontactsadd" class="<?php echo $contacts_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($contacts_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $contacts_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="contacts">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$contacts_add->IsModal ?>">
<?php if (!$contacts_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($contacts_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_contactsadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($contacts->ContactTypeID->Visible) { // ContactTypeID ?>
<?php if ($contacts_add->IsMobileOrModal) { ?>
	<div id="r_ContactTypeID" class="form-group row">
		<label id="elh_contacts_ContactTypeID" for="x_ContactTypeID" class="<?php echo $contacts_add->LeftColumnClass ?>"><?php echo $contacts->ContactTypeID->caption() ?><?php echo ($contacts->ContactTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $contacts_add->RightColumnClass ?>"><div<?php echo $contacts->ContactTypeID->cellAttributes() ?>>
<span id="el_contacts_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="contacts" data-field="x_ContactTypeID" data-value-separator="<?php echo $contacts->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x_ContactTypeID" name="x_ContactTypeID"<?php echo $contacts->ContactTypeID->editAttributes() ?>>
		<?php echo $contacts->ContactTypeID->selectOptionListHtml("x_ContactTypeID") ?>
	</select>
</div>
<?php echo $contacts->ContactTypeID->Lookup->getParamTag("p_x_ContactTypeID") ?>
</span>
<?php echo $contacts->ContactTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ContactTypeID">
		<td class="<?php echo $contacts_add->TableLeftColumnClass ?>"><span id="elh_contacts_ContactTypeID"><?php echo $contacts->ContactTypeID->caption() ?><?php echo ($contacts->ContactTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $contacts->ContactTypeID->cellAttributes() ?>>
<span id="el_contacts_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="contacts" data-field="x_ContactTypeID" data-value-separator="<?php echo $contacts->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x_ContactTypeID" name="x_ContactTypeID"<?php echo $contacts->ContactTypeID->editAttributes() ?>>
		<?php echo $contacts->ContactTypeID->selectOptionListHtml("x_ContactTypeID") ?>
	</select>
</div>
<?php echo $contacts->ContactTypeID->Lookup->getParamTag("p_x_ContactTypeID") ?>
</span>
<?php echo $contacts->ContactTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($contacts->Contact->Visible) { // Contact ?>
<?php if ($contacts_add->IsMobileOrModal) { ?>
	<div id="r_Contact" class="form-group row">
		<label id="elh_contacts_Contact" for="x_Contact" class="<?php echo $contacts_add->LeftColumnClass ?>"><?php echo $contacts->Contact->caption() ?><?php echo ($contacts->Contact->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $contacts_add->RightColumnClass ?>"><div<?php echo $contacts->Contact->cellAttributes() ?>>
<span id="el_contacts_Contact">
<input type="text" data-table="contacts" data-field="x_Contact" name="x_Contact" id="x_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($contacts->Contact->getPlaceHolder()) ?>" value="<?php echo $contacts->Contact->EditValue ?>"<?php echo $contacts->Contact->editAttributes() ?>>
</span>
<?php echo $contacts->Contact->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Contact">
		<td class="<?php echo $contacts_add->TableLeftColumnClass ?>"><span id="elh_contacts_Contact"><?php echo $contacts->Contact->caption() ?><?php echo ($contacts->Contact->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $contacts->Contact->cellAttributes() ?>>
<span id="el_contacts_Contact">
<input type="text" data-table="contacts" data-field="x_Contact" name="x_Contact" id="x_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($contacts->Contact->getPlaceHolder()) ?>" value="<?php echo $contacts->Contact->EditValue ?>"<?php echo $contacts->Contact->editAttributes() ?>>
</span>
<?php echo $contacts->Contact->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($contacts->Notes->Visible) { // Notes ?>
<?php if ($contacts_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_contacts_Notes" for="x_Notes" class="<?php echo $contacts_add->LeftColumnClass ?>"><?php echo $contacts->Notes->caption() ?><?php echo ($contacts->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $contacts_add->RightColumnClass ?>"><div<?php echo $contacts->Notes->cellAttributes() ?>>
<span id="el_contacts_Notes">
<input type="text" data-table="contacts" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($contacts->Notes->getPlaceHolder()) ?>" value="<?php echo $contacts->Notes->EditValue ?>"<?php echo $contacts->Notes->editAttributes() ?>>
</span>
<?php echo $contacts->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $contacts_add->TableLeftColumnClass ?>"><span id="elh_contacts_Notes"><?php echo $contacts->Notes->caption() ?><?php echo ($contacts->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $contacts->Notes->cellAttributes() ?>>
<span id="el_contacts_Notes">
<input type="text" data-table="contacts" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($contacts->Notes->getPlaceHolder()) ?>" value="<?php echo $contacts->Notes->EditValue ?>"<?php echo $contacts->Notes->editAttributes() ?>>
</span>
<?php echo $contacts->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($contacts->Primary->Visible) { // Primary ?>
<?php if ($contacts_add->IsMobileOrModal) { ?>
	<div id="r_Primary" class="form-group row">
		<label id="elh_contacts_Primary" class="<?php echo $contacts_add->LeftColumnClass ?>"><?php echo $contacts->Primary->caption() ?><?php echo ($contacts->Primary->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $contacts_add->RightColumnClass ?>"><div<?php echo $contacts->Primary->cellAttributes() ?>>
<span id="el_contacts_Primary">
<?php
$selwrk = (ConvertToBool($contacts->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="contacts" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $contacts->Primary->editAttributes() ?>>
</span>
<?php echo $contacts->Primary->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Primary">
		<td class="<?php echo $contacts_add->TableLeftColumnClass ?>"><span id="elh_contacts_Primary"><?php echo $contacts->Primary->caption() ?><?php echo ($contacts->Primary->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $contacts->Primary->cellAttributes() ?>>
<span id="el_contacts_Primary">
<?php
$selwrk = (ConvertToBool($contacts->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="contacts" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $contacts->Primary->editAttributes() ?>>
</span>
<?php echo $contacts->Primary->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($contacts_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$contacts_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $contacts_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $contacts_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$contacts_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$contacts_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$contacts_add->terminate();
?>
