<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$courtcontact_preview = new courtcontact_preview();

// Run the page
$courtcontact_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courtcontact_preview->Page_Render();
?>
<?php $courtcontact_preview->showPageHeader(); ?>
<div class="card ew-grid courtcontact"><!-- .card -->
<?php if ($courtcontact_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$courtcontact_preview->renderListOptions();

// Render list options (header, left)
$courtcontact_preview->ListOptions->render("header", "left");
?>
<?php if ($courtcontact->CourtID->Visible) { // CourtID ?>
	<?php if ($courtcontact->SortUrl($courtcontact->CourtID) == "") { ?>
		<th class="<?php echo $courtcontact->CourtID->headerCellClass() ?>"><?php echo $courtcontact->CourtID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $courtcontact->CourtID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $courtcontact->CourtID->Name ?>" data-sort-order="<?php echo $courtcontact_preview->SortField == $courtcontact->CourtID->Name && $courtcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $courtcontact->CourtID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($courtcontact_preview->SortField == $courtcontact->CourtID->Name) { ?><?php if ($courtcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($courtcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($courtcontact->SortUrl($courtcontact->ContactTypeID) == "") { ?>
		<th class="<?php echo $courtcontact->ContactTypeID->headerCellClass() ?>"><?php echo $courtcontact->ContactTypeID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $courtcontact->ContactTypeID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $courtcontact->ContactTypeID->Name ?>" data-sort-order="<?php echo $courtcontact_preview->SortField == $courtcontact->ContactTypeID->Name && $courtcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $courtcontact->ContactTypeID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($courtcontact_preview->SortField == $courtcontact->ContactTypeID->Name) { ?><?php if ($courtcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($courtcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Contact->Visible) { // Contact ?>
	<?php if ($courtcontact->SortUrl($courtcontact->Contact) == "") { ?>
		<th class="<?php echo $courtcontact->Contact->headerCellClass() ?>"><?php echo $courtcontact->Contact->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $courtcontact->Contact->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $courtcontact->Contact->Name ?>" data-sort-order="<?php echo $courtcontact_preview->SortField == $courtcontact->Contact->Name && $courtcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $courtcontact->Contact->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($courtcontact_preview->SortField == $courtcontact->Contact->Name) { ?><?php if ($courtcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($courtcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Notes->Visible) { // Notes ?>
	<?php if ($courtcontact->SortUrl($courtcontact->Notes) == "") { ?>
		<th class="<?php echo $courtcontact->Notes->headerCellClass() ?>"><?php echo $courtcontact->Notes->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $courtcontact->Notes->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $courtcontact->Notes->Name ?>" data-sort-order="<?php echo $courtcontact_preview->SortField == $courtcontact->Notes->Name && $courtcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $courtcontact->Notes->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($courtcontact_preview->SortField == $courtcontact->Notes->Name) { ?><?php if ($courtcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($courtcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Primary->Visible) { // Primary ?>
	<?php if ($courtcontact->SortUrl($courtcontact->Primary) == "") { ?>
		<th class="<?php echo $courtcontact->Primary->headerCellClass() ?>"><?php echo $courtcontact->Primary->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $courtcontact->Primary->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $courtcontact->Primary->Name ?>" data-sort-order="<?php echo $courtcontact_preview->SortField == $courtcontact->Primary->Name && $courtcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $courtcontact->Primary->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($courtcontact_preview->SortField == $courtcontact->Primary->Name) { ?><?php if ($courtcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($courtcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$courtcontact_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$courtcontact_preview->RecCount = 0;
$courtcontact_preview->RowCnt = 0;
while ($courtcontact_preview->Recordset && !$courtcontact_preview->Recordset->EOF) {

	// Init row class and style
	$courtcontact_preview->RecCount++;
	$courtcontact_preview->RowCnt++;
	$courtcontact_preview->CssStyle = "";
	$courtcontact_preview->loadListRowValues($courtcontact_preview->Recordset);

	// Render row
	$courtcontact_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$courtcontact_preview->resetAttributes();
	$courtcontact_preview->renderListRow();

	// Render list options
	$courtcontact_preview->renderListOptions();
?>
	<tr<?php echo $courtcontact_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$courtcontact_preview->ListOptions->render("body", "left", $courtcontact_preview->RowCnt);
?>
<?php if ($courtcontact->CourtID->Visible) { // CourtID ?>
		<!-- CourtID -->
		<td<?php echo $courtcontact->CourtID->cellAttributes() ?>>
<span<?php echo $courtcontact->CourtID->viewAttributes() ?>>
<?php echo $courtcontact->CourtID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($courtcontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<!-- ContactTypeID -->
		<td<?php echo $courtcontact->ContactTypeID->cellAttributes() ?>>
<span<?php echo $courtcontact->ContactTypeID->viewAttributes() ?>>
<?php echo $courtcontact->ContactTypeID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($courtcontact->Contact->Visible) { // Contact ?>
		<!-- Contact -->
		<td<?php echo $courtcontact->Contact->cellAttributes() ?>>
<span<?php echo $courtcontact->Contact->viewAttributes() ?>>
<?php echo $courtcontact->Contact->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($courtcontact->Notes->Visible) { // Notes ?>
		<!-- Notes -->
		<td<?php echo $courtcontact->Notes->cellAttributes() ?>>
<span<?php echo $courtcontact->Notes->viewAttributes() ?>>
<?php echo $courtcontact->Notes->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($courtcontact->Primary->Visible) { // Primary ?>
		<!-- Primary -->
		<td<?php echo $courtcontact->Primary->cellAttributes() ?>>
<span<?php echo $courtcontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($courtcontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$courtcontact_preview->ListOptions->render("body", "right", $courtcontact_preview->RowCnt);
?>
	</tr>
<?php
	$courtcontact_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($courtcontact_preview->TotalRecs > 0) { ?>
<?php if (!isset($courtcontact_preview->Pager)) $courtcontact_preview->Pager = new PrevNextPager($courtcontact_preview->StartRec, $courtcontact_preview->DisplayRecs, $courtcontact_preview->TotalRecs) ?>
<?php if ($courtcontact_preview->Pager->RecordCount > 0 && $courtcontact_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($courtcontact_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $courtcontact_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($courtcontact_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $courtcontact_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($courtcontact_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $courtcontact_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($courtcontact_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $courtcontact_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $courtcontact_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $courtcontact_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $courtcontact_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($courtcontact_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$courtcontact_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($courtcontact_preview->Recordset)
	$courtcontact_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$courtcontact_preview->terminate();
?>
