<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courts_add = new courts_add();

// Run the page
$courts_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courts_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcourtsadd = currentForm = new ew.Form("fcourtsadd", "add");

// Validate form
fcourtsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($courts_add->Court->Required) { ?>
			elm = this.getElements("x" + infix + "_Court");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->Court->caption(), $courts->Court->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_add->CourtTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->CourtTypeID->caption(), $courts->CourtTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_add->ChamberID->Required) { ?>
			elm = this.getElements("x" + infix + "_ChamberID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->ChamberID->caption(), $courts->ChamberID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_add->CourtLocationID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtLocationID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->CourtLocationID->caption(), $courts->CourtLocationID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_add->GovernorateID->Required) { ?>
			elm = this.getElements("x" + infix + "_GovernorateID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->GovernorateID->caption(), $courts->GovernorateID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_add->SectionID->Required) { ?>
			elm = this.getElements("x" + infix + "_SectionID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->SectionID->caption(), $courts->SectionID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->Notes->caption(), $courts->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcourtsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtsadd.lists["x_CourtTypeID"] = <?php echo $courts_add->CourtTypeID->Lookup->toClientList() ?>;
fcourtsadd.lists["x_CourtTypeID"].options = <?php echo JsonEncode($courts_add->CourtTypeID->lookupOptions()) ?>;
fcourtsadd.lists["x_ChamberID"] = <?php echo $courts_add->ChamberID->Lookup->toClientList() ?>;
fcourtsadd.lists["x_ChamberID"].options = <?php echo JsonEncode($courts_add->ChamberID->lookupOptions()) ?>;
fcourtsadd.lists["x_CourtLocationID"] = <?php echo $courts_add->CourtLocationID->Lookup->toClientList() ?>;
fcourtsadd.lists["x_CourtLocationID"].options = <?php echo JsonEncode($courts_add->CourtLocationID->lookupOptions()) ?>;
fcourtsadd.lists["x_GovernorateID"] = <?php echo $courts_add->GovernorateID->Lookup->toClientList() ?>;
fcourtsadd.lists["x_GovernorateID"].options = <?php echo JsonEncode($courts_add->GovernorateID->lookupOptions()) ?>;
fcourtsadd.lists["x_SectionID"] = <?php echo $courts_add->SectionID->Lookup->toClientList() ?>;
fcourtsadd.lists["x_SectionID"].options = <?php echo JsonEncode($courts_add->SectionID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $courts_add->showPageHeader(); ?>
<?php
$courts_add->showMessage();
?>
<form name="fcourtsadd" id="fcourtsadd" class="<?php echo $courts_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courts_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courts_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courts">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$courts_add->IsModal ?>">
<?php if (!$courts_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_courtsadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($courts->Court->Visible) { // Court ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
	<div id="r_Court" class="form-group row">
		<label id="elh_courts_Court" for="x_Court" class="<?php echo $courts_add->LeftColumnClass ?>"><?php echo $courts->Court->caption() ?><?php echo ($courts->Court->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courts_add->RightColumnClass ?>"><div<?php echo $courts->Court->cellAttributes() ?>>
<span id="el_courts_Court">
<input type="text" data-table="courts" data-field="x_Court" name="x_Court" id="x_Court" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courts->Court->getPlaceHolder()) ?>" value="<?php echo $courts->Court->EditValue ?>"<?php echo $courts->Court->editAttributes() ?>>
</span>
<?php echo $courts->Court->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Court">
		<td class="<?php echo $courts_add->TableLeftColumnClass ?>"><span id="elh_courts_Court"><?php echo $courts->Court->caption() ?><?php echo ($courts->Court->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courts->Court->cellAttributes() ?>>
<span id="el_courts_Court">
<input type="text" data-table="courts" data-field="x_Court" name="x_Court" id="x_Court" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courts->Court->getPlaceHolder()) ?>" value="<?php echo $courts->Court->EditValue ?>"<?php echo $courts->Court->editAttributes() ?>>
</span>
<?php echo $courts->Court->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->CourtTypeID->Visible) { // CourtTypeID ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
	<div id="r_CourtTypeID" class="form-group row">
		<label id="elh_courts_CourtTypeID" for="x_CourtTypeID" class="<?php echo $courts_add->LeftColumnClass ?>"><?php echo $courts->CourtTypeID->caption() ?><?php echo ($courts->CourtTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courts_add->RightColumnClass ?>"><div<?php echo $courts->CourtTypeID->cellAttributes() ?>>
<span id="el_courts_CourtTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_CourtTypeID" data-value-separator="<?php echo $courts->CourtTypeID->displayValueSeparatorAttribute() ?>" id="x_CourtTypeID" name="x_CourtTypeID"<?php echo $courts->CourtTypeID->editAttributes() ?>>
		<?php echo $courts->CourtTypeID->selectOptionListHtml("x_CourtTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "courttype") && !$courts->CourtTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $courts->CourtTypeID->caption() ?>" data-title="<?php echo $courts->CourtTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtTypeID',url:'courttypeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $courts->CourtTypeID->Lookup->getParamTag("p_x_CourtTypeID") ?>
</span>
<?php echo $courts->CourtTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtTypeID">
		<td class="<?php echo $courts_add->TableLeftColumnClass ?>"><span id="elh_courts_CourtTypeID"><?php echo $courts->CourtTypeID->caption() ?><?php echo ($courts->CourtTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courts->CourtTypeID->cellAttributes() ?>>
<span id="el_courts_CourtTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_CourtTypeID" data-value-separator="<?php echo $courts->CourtTypeID->displayValueSeparatorAttribute() ?>" id="x_CourtTypeID" name="x_CourtTypeID"<?php echo $courts->CourtTypeID->editAttributes() ?>>
		<?php echo $courts->CourtTypeID->selectOptionListHtml("x_CourtTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "courttype") && !$courts->CourtTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $courts->CourtTypeID->caption() ?>" data-title="<?php echo $courts->CourtTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtTypeID',url:'courttypeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $courts->CourtTypeID->Lookup->getParamTag("p_x_CourtTypeID") ?>
</span>
<?php echo $courts->CourtTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->ChamberID->Visible) { // ChamberID ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
	<div id="r_ChamberID" class="form-group row">
		<label id="elh_courts_ChamberID" for="x_ChamberID" class="<?php echo $courts_add->LeftColumnClass ?>"><?php echo $courts->ChamberID->caption() ?><?php echo ($courts->ChamberID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courts_add->RightColumnClass ?>"><div<?php echo $courts->ChamberID->cellAttributes() ?>>
<span id="el_courts_ChamberID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_ChamberID" data-value-separator="<?php echo $courts->ChamberID->displayValueSeparatorAttribute() ?>" id="x_ChamberID" name="x_ChamberID"<?php echo $courts->ChamberID->editAttributes() ?>>
		<?php echo $courts->ChamberID->selectOptionListHtml("x_ChamberID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "chambers") && !$courts->ChamberID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ChamberID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $courts->ChamberID->caption() ?>" data-title="<?php echo $courts->ChamberID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ChamberID',url:'chambersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $courts->ChamberID->Lookup->getParamTag("p_x_ChamberID") ?>
</span>
<?php echo $courts->ChamberID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ChamberID">
		<td class="<?php echo $courts_add->TableLeftColumnClass ?>"><span id="elh_courts_ChamberID"><?php echo $courts->ChamberID->caption() ?><?php echo ($courts->ChamberID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courts->ChamberID->cellAttributes() ?>>
<span id="el_courts_ChamberID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_ChamberID" data-value-separator="<?php echo $courts->ChamberID->displayValueSeparatorAttribute() ?>" id="x_ChamberID" name="x_ChamberID"<?php echo $courts->ChamberID->editAttributes() ?>>
		<?php echo $courts->ChamberID->selectOptionListHtml("x_ChamberID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "chambers") && !$courts->ChamberID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ChamberID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $courts->ChamberID->caption() ?>" data-title="<?php echo $courts->ChamberID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ChamberID',url:'chambersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $courts->ChamberID->Lookup->getParamTag("p_x_ChamberID") ?>
</span>
<?php echo $courts->ChamberID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->CourtLocationID->Visible) { // CourtLocationID ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
	<div id="r_CourtLocationID" class="form-group row">
		<label id="elh_courts_CourtLocationID" for="x_CourtLocationID" class="<?php echo $courts_add->LeftColumnClass ?>"><?php echo $courts->CourtLocationID->caption() ?><?php echo ($courts->CourtLocationID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courts_add->RightColumnClass ?>"><div<?php echo $courts->CourtLocationID->cellAttributes() ?>>
<span id="el_courts_CourtLocationID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_CourtLocationID" data-value-separator="<?php echo $courts->CourtLocationID->displayValueSeparatorAttribute() ?>" id="x_CourtLocationID" name="x_CourtLocationID"<?php echo $courts->CourtLocationID->editAttributes() ?>>
		<?php echo $courts->CourtLocationID->selectOptionListHtml("x_CourtLocationID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "courtlocation") && !$courts->CourtLocationID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtLocationID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $courts->CourtLocationID->caption() ?>" data-title="<?php echo $courts->CourtLocationID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtLocationID',url:'courtlocationaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $courts->CourtLocationID->Lookup->getParamTag("p_x_CourtLocationID") ?>
</span>
<?php echo $courts->CourtLocationID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtLocationID">
		<td class="<?php echo $courts_add->TableLeftColumnClass ?>"><span id="elh_courts_CourtLocationID"><?php echo $courts->CourtLocationID->caption() ?><?php echo ($courts->CourtLocationID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courts->CourtLocationID->cellAttributes() ?>>
<span id="el_courts_CourtLocationID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_CourtLocationID" data-value-separator="<?php echo $courts->CourtLocationID->displayValueSeparatorAttribute() ?>" id="x_CourtLocationID" name="x_CourtLocationID"<?php echo $courts->CourtLocationID->editAttributes() ?>>
		<?php echo $courts->CourtLocationID->selectOptionListHtml("x_CourtLocationID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "courtlocation") && !$courts->CourtLocationID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtLocationID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $courts->CourtLocationID->caption() ?>" data-title="<?php echo $courts->CourtLocationID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtLocationID',url:'courtlocationaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $courts->CourtLocationID->Lookup->getParamTag("p_x_CourtLocationID") ?>
</span>
<?php echo $courts->CourtLocationID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->GovernorateID->Visible) { // GovernorateID ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
	<div id="r_GovernorateID" class="form-group row">
		<label id="elh_courts_GovernorateID" for="x_GovernorateID" class="<?php echo $courts_add->LeftColumnClass ?>"><?php echo $courts->GovernorateID->caption() ?><?php echo ($courts->GovernorateID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courts_add->RightColumnClass ?>"><div<?php echo $courts->GovernorateID->cellAttributes() ?>>
<span id="el_courts_GovernorateID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_GovernorateID" data-value-separator="<?php echo $courts->GovernorateID->displayValueSeparatorAttribute() ?>" id="x_GovernorateID" name="x_GovernorateID"<?php echo $courts->GovernorateID->editAttributes() ?>>
		<?php echo $courts->GovernorateID->selectOptionListHtml("x_GovernorateID") ?>
	</select>
</div>
<?php echo $courts->GovernorateID->Lookup->getParamTag("p_x_GovernorateID") ?>
</span>
<?php echo $courts->GovernorateID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_GovernorateID">
		<td class="<?php echo $courts_add->TableLeftColumnClass ?>"><span id="elh_courts_GovernorateID"><?php echo $courts->GovernorateID->caption() ?><?php echo ($courts->GovernorateID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courts->GovernorateID->cellAttributes() ?>>
<span id="el_courts_GovernorateID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_GovernorateID" data-value-separator="<?php echo $courts->GovernorateID->displayValueSeparatorAttribute() ?>" id="x_GovernorateID" name="x_GovernorateID"<?php echo $courts->GovernorateID->editAttributes() ?>>
		<?php echo $courts->GovernorateID->selectOptionListHtml("x_GovernorateID") ?>
	</select>
</div>
<?php echo $courts->GovernorateID->Lookup->getParamTag("p_x_GovernorateID") ?>
</span>
<?php echo $courts->GovernorateID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->SectionID->Visible) { // SectionID ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
	<div id="r_SectionID" class="form-group row">
		<label id="elh_courts_SectionID" for="x_SectionID" class="<?php echo $courts_add->LeftColumnClass ?>"><?php echo $courts->SectionID->caption() ?><?php echo ($courts->SectionID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courts_add->RightColumnClass ?>"><div<?php echo $courts->SectionID->cellAttributes() ?>>
<span id="el_courts_SectionID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_SectionID" data-value-separator="<?php echo $courts->SectionID->displayValueSeparatorAttribute() ?>" id="x_SectionID" name="x_SectionID"<?php echo $courts->SectionID->editAttributes() ?>>
		<?php echo $courts->SectionID->selectOptionListHtml("x_SectionID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "sections") && !$courts->SectionID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_SectionID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $courts->SectionID->caption() ?>" data-title="<?php echo $courts->SectionID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_SectionID',url:'sectionsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $courts->SectionID->Lookup->getParamTag("p_x_SectionID") ?>
</span>
<?php echo $courts->SectionID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_SectionID">
		<td class="<?php echo $courts_add->TableLeftColumnClass ?>"><span id="elh_courts_SectionID"><?php echo $courts->SectionID->caption() ?><?php echo ($courts->SectionID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courts->SectionID->cellAttributes() ?>>
<span id="el_courts_SectionID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_SectionID" data-value-separator="<?php echo $courts->SectionID->displayValueSeparatorAttribute() ?>" id="x_SectionID" name="x_SectionID"<?php echo $courts->SectionID->editAttributes() ?>>
		<?php echo $courts->SectionID->selectOptionListHtml("x_SectionID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "sections") && !$courts->SectionID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_SectionID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $courts->SectionID->caption() ?>" data-title="<?php echo $courts->SectionID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_SectionID',url:'sectionsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $courts->SectionID->Lookup->getParamTag("p_x_SectionID") ?>
</span>
<?php echo $courts->SectionID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->Notes->Visible) { // Notes ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_courts_Notes" for="x_Notes" class="<?php echo $courts_add->LeftColumnClass ?>"><?php echo $courts->Notes->caption() ?><?php echo ($courts->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courts_add->RightColumnClass ?>"><div<?php echo $courts->Notes->cellAttributes() ?>>
<span id="el_courts_Notes">
<textarea data-table="courts" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($courts->Notes->getPlaceHolder()) ?>"<?php echo $courts->Notes->editAttributes() ?>><?php echo $courts->Notes->EditValue ?></textarea>
</span>
<?php echo $courts->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $courts_add->TableLeftColumnClass ?>"><span id="elh_courts_Notes"><?php echo $courts->Notes->caption() ?><?php echo ($courts->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courts->Notes->cellAttributes() ?>>
<span id="el_courts_Notes">
<textarea data-table="courts" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($courts->Notes->getPlaceHolder()) ?>"<?php echo $courts->Notes->editAttributes() ?>><?php echo $courts->Notes->EditValue ?></textarea>
</span>
<?php echo $courts->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if ($courts->getCurrentDetailTable() <> "") { ?>
<?php
	$courts_add->DetailPages->ValidKeys = explode(",", $courts->getCurrentDetailTable());
	$firstActiveDetailTable = $courts_add->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="courts_add_details"><!-- tabs -->
	<ul class="<?php echo $courts_add->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("courtaddress", explode(",", $courts->getCurrentDetailTable())) && $courtaddress->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "courtaddress") {
			$firstActiveDetailTable = "courtaddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $courts_add->DetailPages->pageStyle("courtaddress") ?>" href="#tab_courtaddress" data-toggle="tab"><?php echo $Language->TablePhrase("courtaddress", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("courtcontact", explode(",", $courts->getCurrentDetailTable())) && $courtcontact->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "courtcontact") {
			$firstActiveDetailTable = "courtcontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $courts_add->DetailPages->pageStyle("courtcontact") ?>" href="#tab_courtcontact" data-toggle="tab"><?php echo $Language->TablePhrase("courtcontact", "TblCaption") ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("courtaddress", explode(",", $courts->getCurrentDetailTable())) && $courtaddress->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "courtaddress")
			$firstActiveDetailTable = "courtaddress";
?>
		<div class="tab-pane<?php echo $courts_add->DetailPages->pageStyle("courtaddress") ?>" id="tab_courtaddress"><!-- page* -->
<?php include_once "courtaddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("courtcontact", explode(",", $courts->getCurrentDetailTable())) && $courtcontact->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "courtcontact")
			$firstActiveDetailTable = "courtcontact";
?>
		<div class="tab-pane<?php echo $courts_add->DetailPages->pageStyle("courtcontact") ?>" id="tab_courtcontact"><!-- page* -->
<?php include_once "courtcontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
<?php if (!$courts_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $courts_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $courts_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$courts_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$courts_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$courts_add->terminate();
?>
