<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courts_list = new courts_list();

// Run the page
$courts_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courts_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$courts->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcourtslist = currentForm = new ew.Form("fcourtslist", "list");
fcourtslist.formKeyCountName = '<?php echo $courts_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcourtslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtslist.lists["x_CourtTypeID"] = <?php echo $courts_list->CourtTypeID->Lookup->toClientList() ?>;
fcourtslist.lists["x_CourtTypeID"].options = <?php echo JsonEncode($courts_list->CourtTypeID->lookupOptions()) ?>;
fcourtslist.lists["x_ChamberID"] = <?php echo $courts_list->ChamberID->Lookup->toClientList() ?>;
fcourtslist.lists["x_ChamberID"].options = <?php echo JsonEncode($courts_list->ChamberID->lookupOptions()) ?>;
fcourtslist.lists["x_CourtLocationID"] = <?php echo $courts_list->CourtLocationID->Lookup->toClientList() ?>;
fcourtslist.lists["x_CourtLocationID"].options = <?php echo JsonEncode($courts_list->CourtLocationID->lookupOptions()) ?>;
fcourtslist.lists["x_GovernorateID"] = <?php echo $courts_list->GovernorateID->Lookup->toClientList() ?>;
fcourtslist.lists["x_GovernorateID"].options = <?php echo JsonEncode($courts_list->GovernorateID->lookupOptions()) ?>;

// Form object for search
var fcourtslistsrch = currentSearchForm = new ew.Form("fcourtslistsrch");

// Filters
fcourtslistsrch.filterList = <?php echo $courts_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FF80FF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$courts->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($courts_list->TotalRecs > 0 && $courts_list->ExportOptions->visible()) { ?>
<?php $courts_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($courts_list->ImportOptions->visible()) { ?>
<?php $courts_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($courts_list->SearchOptions->visible()) { ?>
<?php $courts_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($courts_list->FilterOptions->visible()) { ?>
<?php $courts_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$courts_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$courts->isExport() && !$courts->CurrentAction) { ?>
<form name="fcourtslistsrch" id="fcourtslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($courts_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fcourtslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="courts">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($courts_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($courts_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $courts_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($courts_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($courts_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($courts_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($courts_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $courts_list->showPageHeader(); ?>
<?php
$courts_list->showMessage();
?>
<?php if ($courts_list->TotalRecs > 0 || $courts->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($courts_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> courts">
<?php if (!$courts->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$courts->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($courts_list->Pager)) $courts_list->Pager = new PrevNextPager($courts_list->StartRec, $courts_list->DisplayRecs, $courts_list->TotalRecs, $courts_list->AutoHidePager) ?>
<?php if ($courts_list->Pager->RecordCount > 0 && $courts_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courts_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courts_list->pageUrl() ?>start=<?php echo $courts_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courts_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courts_list->pageUrl() ?>start=<?php echo $courts_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courts_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courts_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courts_list->pageUrl() ?>start=<?php echo $courts_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courts_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courts_list->pageUrl() ?>start=<?php echo $courts_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courts_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($courts_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $courts_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $courts_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $courts_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($courts_list->TotalRecs > 0 && (!$courts_list->AutoHidePageSizeSelector || $courts_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="courts">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($courts_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($courts_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($courts_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($courts_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($courts_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($courts_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($courts_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($courts_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($courts_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($courts->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $courts_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcourtslist" id="fcourtslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courts_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courts_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courts">
<div id="gmp_courts" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($courts_list->TotalRecs > 0 || $courts->isGridEdit()) { ?>
<table id="tbl_courtslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$courts_list->RowType = ROWTYPE_HEADER;

// Render list options
$courts_list->renderListOptions();

// Render list options (header, left)
$courts_list->ListOptions->render("header", "left");
?>
<?php if ($courts->Court->Visible) { // Court ?>
	<?php if ($courts->sortUrl($courts->Court) == "") { ?>
		<th data-name="Court" class="<?php echo $courts->Court->headerCellClass() ?>"><div id="elh_courts_Court" class="courts_Court"><div class="ew-table-header-caption"><?php echo $courts->Court->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Court" class="<?php echo $courts->Court->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courts->SortUrl($courts->Court) ?>',2);"><div id="elh_courts_Court" class="courts_Court">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courts->Court->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courts->Court->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courts->Court->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courts->CourtTypeID->Visible) { // CourtTypeID ?>
	<?php if ($courts->sortUrl($courts->CourtTypeID) == "") { ?>
		<th data-name="CourtTypeID" class="<?php echo $courts->CourtTypeID->headerCellClass() ?>"><div id="elh_courts_CourtTypeID" class="courts_CourtTypeID"><div class="ew-table-header-caption"><?php echo $courts->CourtTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtTypeID" class="<?php echo $courts->CourtTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courts->SortUrl($courts->CourtTypeID) ?>',2);"><div id="elh_courts_CourtTypeID" class="courts_CourtTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courts->CourtTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courts->CourtTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courts->CourtTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courts->ChamberID->Visible) { // ChamberID ?>
	<?php if ($courts->sortUrl($courts->ChamberID) == "") { ?>
		<th data-name="ChamberID" class="<?php echo $courts->ChamberID->headerCellClass() ?>"><div id="elh_courts_ChamberID" class="courts_ChamberID"><div class="ew-table-header-caption"><?php echo $courts->ChamberID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ChamberID" class="<?php echo $courts->ChamberID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courts->SortUrl($courts->ChamberID) ?>',2);"><div id="elh_courts_ChamberID" class="courts_ChamberID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courts->ChamberID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courts->ChamberID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courts->ChamberID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courts->CourtLocationID->Visible) { // CourtLocationID ?>
	<?php if ($courts->sortUrl($courts->CourtLocationID) == "") { ?>
		<th data-name="CourtLocationID" class="<?php echo $courts->CourtLocationID->headerCellClass() ?>"><div id="elh_courts_CourtLocationID" class="courts_CourtLocationID"><div class="ew-table-header-caption"><?php echo $courts->CourtLocationID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtLocationID" class="<?php echo $courts->CourtLocationID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courts->SortUrl($courts->CourtLocationID) ?>',2);"><div id="elh_courts_CourtLocationID" class="courts_CourtLocationID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courts->CourtLocationID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courts->CourtLocationID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courts->CourtLocationID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courts->GovernorateID->Visible) { // GovernorateID ?>
	<?php if ($courts->sortUrl($courts->GovernorateID) == "") { ?>
		<th data-name="GovernorateID" class="<?php echo $courts->GovernorateID->headerCellClass() ?>"><div id="elh_courts_GovernorateID" class="courts_GovernorateID"><div class="ew-table-header-caption"><?php echo $courts->GovernorateID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="GovernorateID" class="<?php echo $courts->GovernorateID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courts->SortUrl($courts->GovernorateID) ?>',2);"><div id="elh_courts_GovernorateID" class="courts_GovernorateID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courts->GovernorateID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courts->GovernorateID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courts->GovernorateID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$courts_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($courts->ExportAll && $courts->isExport()) {
	$courts_list->StopRec = $courts_list->TotalRecs;
} else {

	// Set the last record to display
	if ($courts_list->TotalRecs > $courts_list->StartRec + $courts_list->DisplayRecs - 1)
		$courts_list->StopRec = $courts_list->StartRec + $courts_list->DisplayRecs - 1;
	else
		$courts_list->StopRec = $courts_list->TotalRecs;
}
$courts_list->RecCnt = $courts_list->StartRec - 1;
if ($courts_list->Recordset && !$courts_list->Recordset->EOF) {
	$courts_list->Recordset->moveFirst();
	$selectLimit = $courts_list->UseSelectLimit;
	if (!$selectLimit && $courts_list->StartRec > 1)
		$courts_list->Recordset->move($courts_list->StartRec - 1);
} elseif (!$courts->AllowAddDeleteRow && $courts_list->StopRec == 0) {
	$courts_list->StopRec = $courts->GridAddRowCount;
}

// Initialize aggregate
$courts->RowType = ROWTYPE_AGGREGATEINIT;
$courts->resetAttributes();
$courts_list->renderRow();
while ($courts_list->RecCnt < $courts_list->StopRec) {
	$courts_list->RecCnt++;
	if ($courts_list->RecCnt >= $courts_list->StartRec) {
		$courts_list->RowCnt++;

		// Set up key count
		$courts_list->KeyCount = $courts_list->RowIndex;

		// Init row class and style
		$courts->resetAttributes();
		$courts->CssClass = "";
		if ($courts->isGridAdd()) {
		} else {
			$courts_list->loadRowValues($courts_list->Recordset); // Load row values
		}
		$courts->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$courts->RowAttrs = array_merge($courts->RowAttrs, array('data-rowindex'=>$courts_list->RowCnt, 'id'=>'r' . $courts_list->RowCnt . '_courts', 'data-rowtype'=>$courts->RowType));

		// Render row
		$courts_list->renderRow();

		// Render list options
		$courts_list->renderListOptions();
?>
	<tr<?php echo $courts->rowAttributes() ?>>
<?php

// Render list options (body, left)
$courts_list->ListOptions->render("body", "left", $courts_list->RowCnt);
?>
	<?php if ($courts->Court->Visible) { // Court ?>
		<td data-name="Court"<?php echo $courts->Court->cellAttributes() ?>>
<span id="el<?php echo $courts_list->RowCnt ?>_courts_Court" class="courts_Court">
<span<?php echo $courts->Court->viewAttributes() ?>>
<?php echo $courts->Court->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courts->CourtTypeID->Visible) { // CourtTypeID ?>
		<td data-name="CourtTypeID"<?php echo $courts->CourtTypeID->cellAttributes() ?>>
<span id="el<?php echo $courts_list->RowCnt ?>_courts_CourtTypeID" class="courts_CourtTypeID">
<span<?php echo $courts->CourtTypeID->viewAttributes() ?>>
<?php echo $courts->CourtTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courts->ChamberID->Visible) { // ChamberID ?>
		<td data-name="ChamberID"<?php echo $courts->ChamberID->cellAttributes() ?>>
<span id="el<?php echo $courts_list->RowCnt ?>_courts_ChamberID" class="courts_ChamberID">
<span<?php echo $courts->ChamberID->viewAttributes() ?>>
<?php echo $courts->ChamberID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courts->CourtLocationID->Visible) { // CourtLocationID ?>
		<td data-name="CourtLocationID"<?php echo $courts->CourtLocationID->cellAttributes() ?>>
<span id="el<?php echo $courts_list->RowCnt ?>_courts_CourtLocationID" class="courts_CourtLocationID">
<span<?php echo $courts->CourtLocationID->viewAttributes() ?>>
<?php echo $courts->CourtLocationID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courts->GovernorateID->Visible) { // GovernorateID ?>
		<td data-name="GovernorateID"<?php echo $courts->GovernorateID->cellAttributes() ?>>
<span id="el<?php echo $courts_list->RowCnt ?>_courts_GovernorateID" class="courts_GovernorateID">
<span<?php echo $courts->GovernorateID->viewAttributes() ?>>
<?php echo $courts->GovernorateID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$courts_list->ListOptions->render("body", "right", $courts_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$courts->isGridAdd())
		$courts_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$courts->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($courts_list->Recordset)
	$courts_list->Recordset->Close();
?>
<?php if (!$courts->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$courts->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($courts_list->Pager)) $courts_list->Pager = new PrevNextPager($courts_list->StartRec, $courts_list->DisplayRecs, $courts_list->TotalRecs, $courts_list->AutoHidePager) ?>
<?php if ($courts_list->Pager->RecordCount > 0 && $courts_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courts_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courts_list->pageUrl() ?>start=<?php echo $courts_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courts_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courts_list->pageUrl() ?>start=<?php echo $courts_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courts_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courts_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courts_list->pageUrl() ?>start=<?php echo $courts_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courts_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courts_list->pageUrl() ?>start=<?php echo $courts_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courts_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($courts_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $courts_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $courts_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $courts_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($courts_list->TotalRecs > 0 && (!$courts_list->AutoHidePageSizeSelector || $courts_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="courts">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($courts_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($courts_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($courts_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($courts_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($courts_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($courts_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($courts_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($courts_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($courts_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($courts->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $courts_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($courts_list->TotalRecs == 0 && !$courts->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $courts_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$courts_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$courts->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$courts->isExport()) { ?>
<script>
ew.scrollableTable("gmp_courts", "1250px", "550px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$courts_list->terminate();
?>
