<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courtsort_add = new courtsort_add();

// Run the page
$courtsort_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courtsort_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcourtsortadd = currentForm = new ew.Form("fcourtsortadd", "add");

// Validate form
fcourtsortadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($courtsort_add->CourtSort->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtSort");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtsort->CourtSort->caption(), $courtsort->CourtSort->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courtsort_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtsort->Notes->caption(), $courtsort->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcourtsortadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtsortadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $courtsort_add->showPageHeader(); ?>
<?php
$courtsort_add->showMessage();
?>
<form name="fcourtsortadd" id="fcourtsortadd" class="<?php echo $courtsort_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courtsort_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courtsort_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courtsort">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$courtsort_add->IsModal ?>">
<?php if (!$courtsort_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($courtsort_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_courtsortadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($courtsort->CourtSort->Visible) { // CourtSort ?>
<?php if ($courtsort_add->IsMobileOrModal) { ?>
	<div id="r_CourtSort" class="form-group row">
		<label id="elh_courtsort_CourtSort" for="x_CourtSort" class="<?php echo $courtsort_add->LeftColumnClass ?>"><?php echo $courtsort->CourtSort->caption() ?><?php echo ($courtsort->CourtSort->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courtsort_add->RightColumnClass ?>"><div<?php echo $courtsort->CourtSort->cellAttributes() ?>>
<span id="el_courtsort_CourtSort">
<input type="text" data-table="courtsort" data-field="x_CourtSort" name="x_CourtSort" id="x_CourtSort" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courtsort->CourtSort->getPlaceHolder()) ?>" value="<?php echo $courtsort->CourtSort->EditValue ?>"<?php echo $courtsort->CourtSort->editAttributes() ?>>
</span>
<?php echo $courtsort->CourtSort->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtSort">
		<td class="<?php echo $courtsort_add->TableLeftColumnClass ?>"><span id="elh_courtsort_CourtSort"><?php echo $courtsort->CourtSort->caption() ?><?php echo ($courtsort->CourtSort->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courtsort->CourtSort->cellAttributes() ?>>
<span id="el_courtsort_CourtSort">
<input type="text" data-table="courtsort" data-field="x_CourtSort" name="x_CourtSort" id="x_CourtSort" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courtsort->CourtSort->getPlaceHolder()) ?>" value="<?php echo $courtsort->CourtSort->EditValue ?>"<?php echo $courtsort->CourtSort->editAttributes() ?>>
</span>
<?php echo $courtsort->CourtSort->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courtsort->Notes->Visible) { // Notes ?>
<?php if ($courtsort_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_courtsort_Notes" for="x_Notes" class="<?php echo $courtsort_add->LeftColumnClass ?>"><?php echo $courtsort->Notes->caption() ?><?php echo ($courtsort->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courtsort_add->RightColumnClass ?>"><div<?php echo $courtsort->Notes->cellAttributes() ?>>
<span id="el_courtsort_Notes">
<input type="text" data-table="courtsort" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courtsort->Notes->getPlaceHolder()) ?>" value="<?php echo $courtsort->Notes->EditValue ?>"<?php echo $courtsort->Notes->editAttributes() ?>>
</span>
<?php echo $courtsort->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $courtsort_add->TableLeftColumnClass ?>"><span id="elh_courtsort_Notes"><?php echo $courtsort->Notes->caption() ?><?php echo ($courtsort->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courtsort->Notes->cellAttributes() ?>>
<span id="el_courtsort_Notes">
<input type="text" data-table="courtsort" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courtsort->Notes->getPlaceHolder()) ?>" value="<?php echo $courtsort->Notes->EditValue ?>"<?php echo $courtsort->Notes->editAttributes() ?>>
</span>
<?php echo $courtsort->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courtsort_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$courtsort_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $courtsort_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $courtsort_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$courtsort_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$courtsort_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$courtsort_add->terminate();
?>
