<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courttype_add = new courttype_add();

// Run the page
$courttype_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courttype_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcourttypeadd = currentForm = new ew.Form("fcourttypeadd", "add");

// Validate form
fcourttypeadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($courttype_add->CourtType->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtType");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courttype->CourtType->caption(), $courttype->CourtType->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courttype_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courttype->Notes->caption(), $courttype->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcourttypeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourttypeadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $courttype_add->showPageHeader(); ?>
<?php
$courttype_add->showMessage();
?>
<form name="fcourttypeadd" id="fcourttypeadd" class="<?php echo $courttype_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courttype_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courttype_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courttype">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$courttype_add->IsModal ?>">
<?php if (!$courttype_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($courttype_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_courttypeadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($courttype->CourtType->Visible) { // CourtType ?>
<?php if ($courttype_add->IsMobileOrModal) { ?>
	<div id="r_CourtType" class="form-group row">
		<label id="elh_courttype_CourtType" for="x_CourtType" class="<?php echo $courttype_add->LeftColumnClass ?>"><?php echo $courttype->CourtType->caption() ?><?php echo ($courttype->CourtType->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courttype_add->RightColumnClass ?>"><div<?php echo $courttype->CourtType->cellAttributes() ?>>
<span id="el_courttype_CourtType">
<input type="text" data-table="courttype" data-field="x_CourtType" name="x_CourtType" id="x_CourtType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courttype->CourtType->getPlaceHolder()) ?>" value="<?php echo $courttype->CourtType->EditValue ?>"<?php echo $courttype->CourtType->editAttributes() ?>>
</span>
<?php echo $courttype->CourtType->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtType">
		<td class="<?php echo $courttype_add->TableLeftColumnClass ?>"><span id="elh_courttype_CourtType"><?php echo $courttype->CourtType->caption() ?><?php echo ($courttype->CourtType->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courttype->CourtType->cellAttributes() ?>>
<span id="el_courttype_CourtType">
<input type="text" data-table="courttype" data-field="x_CourtType" name="x_CourtType" id="x_CourtType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courttype->CourtType->getPlaceHolder()) ?>" value="<?php echo $courttype->CourtType->EditValue ?>"<?php echo $courttype->CourtType->editAttributes() ?>>
</span>
<?php echo $courttype->CourtType->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courttype->Notes->Visible) { // Notes ?>
<?php if ($courttype_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_courttype_Notes" for="x_Notes" class="<?php echo $courttype_add->LeftColumnClass ?>"><?php echo $courttype->Notes->caption() ?><?php echo ($courttype->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courttype_add->RightColumnClass ?>"><div<?php echo $courttype->Notes->cellAttributes() ?>>
<span id="el_courttype_Notes">
<input type="text" data-table="courttype" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courttype->Notes->getPlaceHolder()) ?>" value="<?php echo $courttype->Notes->EditValue ?>"<?php echo $courttype->Notes->editAttributes() ?>>
</span>
<?php echo $courttype->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $courttype_add->TableLeftColumnClass ?>"><span id="elh_courttype_Notes"><?php echo $courttype->Notes->caption() ?><?php echo ($courttype->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $courttype->Notes->cellAttributes() ?>>
<span id="el_courttype_Notes">
<input type="text" data-table="courttype" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courttype->Notes->getPlaceHolder()) ?>" value="<?php echo $courttype->Notes->EditValue ?>"<?php echo $courttype->Notes->editAttributes() ?>>
</span>
<?php echo $courttype->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courttype_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$courttype_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $courttype_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $courttype_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$courttype_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$courttype_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$courttype_add->terminate();
?>
