<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courttype_search = new courttype_search();

// Run the page
$courttype_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courttype_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($courttype_search->IsModal) { ?>
var fcourttypesearch = currentAdvancedSearchForm = new ew.Form("fcourttypesearch", "search");
<?php } else { ?>
var fcourttypesearch = currentForm = new ew.Form("fcourttypesearch", "search");
<?php } ?>

// Form_CustomValidate event
fcourttypesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourttypesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search
// Validate function for search

fcourttypesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $courttype_search->showPageHeader(); ?>
<?php
$courttype_search->showMessage();
?>
<form name="fcourttypesearch" id="fcourttypesearch" class="<?php echo $courttype_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courttype_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courttype_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courttype">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$courttype_search->IsModal ?>">
<?php if (!$courttype_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($courttype_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_courttypesearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($courttype->CourtTypeID->Visible) { // CourtTypeID ?>
<?php if ($courttype_search->IsMobileOrModal) { ?>
	<div id="r_CourtTypeID" class="form-group row">
		<label class="<?php echo $courttype_search->LeftColumnClass ?>"><span id="elh_courttype_CourtTypeID"><?php echo $courttype->CourtTypeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtTypeID" id="z_CourtTypeID" value="="></span>
		</label>
		<div class="<?php echo $courttype_search->RightColumnClass ?>"><div<?php echo $courttype->CourtTypeID->cellAttributes() ?>>
			<span id="el_courttype_CourtTypeID">
<input type="text" data-table="courttype" data-field="x_CourtTypeID" name="x_CourtTypeID" id="x_CourtTypeID" placeholder="<?php echo HtmlEncode($courttype->CourtTypeID->getPlaceHolder()) ?>" value="<?php echo $courttype->CourtTypeID->EditValue ?>"<?php echo $courttype->CourtTypeID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtTypeID">
		<td class="<?php echo $courttype_search->TableLeftColumnClass ?>"><span id="elh_courttype_CourtTypeID"><?php echo $courttype->CourtTypeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtTypeID" id="z_CourtTypeID" value="="></span></td>
		<td<?php echo $courttype->CourtTypeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courttype_CourtTypeID">
<input type="text" data-table="courttype" data-field="x_CourtTypeID" name="x_CourtTypeID" id="x_CourtTypeID" placeholder="<?php echo HtmlEncode($courttype->CourtTypeID->getPlaceHolder()) ?>" value="<?php echo $courttype->CourtTypeID->EditValue ?>"<?php echo $courttype->CourtTypeID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courttype->CourtType->Visible) { // CourtType ?>
<?php if ($courttype_search->IsMobileOrModal) { ?>
	<div id="r_CourtType" class="form-group row">
		<label for="x_CourtType" class="<?php echo $courttype_search->LeftColumnClass ?>"><span id="elh_courttype_CourtType"><?php echo $courttype->CourtType->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CourtType" id="z_CourtType" value="LIKE"></span>
		</label>
		<div class="<?php echo $courttype_search->RightColumnClass ?>"><div<?php echo $courttype->CourtType->cellAttributes() ?>>
			<span id="el_courttype_CourtType">
<input type="text" data-table="courttype" data-field="x_CourtType" name="x_CourtType" id="x_CourtType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courttype->CourtType->getPlaceHolder()) ?>" value="<?php echo $courttype->CourtType->EditValue ?>"<?php echo $courttype->CourtType->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtType">
		<td class="<?php echo $courttype_search->TableLeftColumnClass ?>"><span id="elh_courttype_CourtType"><?php echo $courttype->CourtType->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CourtType" id="z_CourtType" value="LIKE"></span></td>
		<td<?php echo $courttype->CourtType->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courttype_CourtType">
<input type="text" data-table="courttype" data-field="x_CourtType" name="x_CourtType" id="x_CourtType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courttype->CourtType->getPlaceHolder()) ?>" value="<?php echo $courttype->CourtType->EditValue ?>"<?php echo $courttype->CourtType->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courttype->Notes->Visible) { // Notes ?>
<?php if ($courttype_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label for="x_Notes" class="<?php echo $courttype_search->LeftColumnClass ?>"><span id="elh_courttype_Notes"><?php echo $courttype->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $courttype_search->RightColumnClass ?>"><div<?php echo $courttype->Notes->cellAttributes() ?>>
			<span id="el_courttype_Notes">
<input type="text" data-table="courttype" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courttype->Notes->getPlaceHolder()) ?>" value="<?php echo $courttype->Notes->EditValue ?>"<?php echo $courttype->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $courttype_search->TableLeftColumnClass ?>"><span id="elh_courttype_Notes"><?php echo $courttype->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $courttype->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courttype_Notes">
<input type="text" data-table="courttype" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courttype->Notes->getPlaceHolder()) ?>" value="<?php echo $courttype->Notes->EditValue ?>"<?php echo $courttype->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courttype_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$courttype_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $courttype_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$courttype_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$courttype_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$courttype_search->terminate();
?>
