<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employeehr_edit = new employeehr_edit();

// Run the page
$employeehr_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employeehr_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var femployeehredit = currentForm = new ew.Form("femployeehredit", "edit");

// Validate form
femployeehredit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($employeehr_edit->EmployeeHrID->Required) { ?>
			elm = this.getElements("x" + infix + "_EmployeeHrID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->EmployeeHrID->caption(), $employeehr->EmployeeHrID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->EmployeeID->Required) { ?>
			elm = this.getElements("x" + infix + "_EmployeeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->EmployeeID->caption(), $employeehr->EmployeeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->JobTitle->Required) { ?>
			elm = this.getElements("x" + infix + "_JobTitle");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->JobTitle->caption(), $employeehr->JobTitle->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->Department->Required) { ?>
			elm = this.getElements("x" + infix + "_Department");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->Department->caption(), $employeehr->Department->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->BranchID->Required) { ?>
			elm = this.getElements("x" + infix + "_BranchID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->BranchID->caption(), $employeehr->BranchID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->LawFirmID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawFirmID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->LawFirmID->caption(), $employeehr->LawFirmID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->Notes->caption(), $employeehr->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->HireDate->Required) { ?>
			elm = this.getElements("x" + infix + "_HireDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->HireDate->caption(), $employeehr->HireDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_HireDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($employeehr->HireDate->errorMessage()) ?>");
		<?php if ($employeehr_edit->EndOfServiceDate->Required) { ?>
			elm = this.getElements("x" + infix + "_EndOfServiceDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->EndOfServiceDate->caption(), $employeehr->EndOfServiceDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_EndOfServiceDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($employeehr->EndOfServiceDate->errorMessage()) ?>");
		<?php if ($employeehr_edit->SocialSecurity23->Required) { ?>
			elm = this.getElements("x" + infix + "_SocialSecurity23");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->SocialSecurity23->caption(), $employeehr->SocialSecurity23->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->Financial23->Required) { ?>
			elm = this.getElements("x" + infix + "_Financial23");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->Financial23->caption(), $employeehr->Financial23->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->Extra23->Required) { ?>
			elm = this.getElements("x" + infix + "_Extra23");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->Extra23->caption(), $employeehr->Extra23->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employeehr_edit->WorkNature->Required) { ?>
			elm = this.getElements("x" + infix + "_WorkNature");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employeehr->WorkNature->caption(), $employeehr->WorkNature->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
femployeehredit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femployeehredit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femployeehredit.lists["x_EmployeeID"] = <?php echo $employeehr_edit->EmployeeID->Lookup->toClientList() ?>;
femployeehredit.lists["x_EmployeeID"].options = <?php echo JsonEncode($employeehr_edit->EmployeeID->lookupOptions()) ?>;
femployeehredit.lists["x_BranchID"] = <?php echo $employeehr_edit->BranchID->Lookup->toClientList() ?>;
femployeehredit.lists["x_BranchID"].options = <?php echo JsonEncode($employeehr_edit->BranchID->lookupOptions()) ?>;
femployeehredit.lists["x_LawFirmID"] = <?php echo $employeehr_edit->LawFirmID->Lookup->toClientList() ?>;
femployeehredit.lists["x_LawFirmID"].options = <?php echo JsonEncode($employeehr_edit->LawFirmID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $employeehr_edit->showPageHeader(); ?>
<?php
$employeehr_edit->showMessage();
?>
<?php if (!$employeehr_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($employeehr_edit->Pager)) $employeehr_edit->Pager = new PrevNextPager($employeehr_edit->StartRec, $employeehr_edit->DisplayRecs, $employeehr_edit->TotalRecs, $employeehr_edit->AutoHidePager) ?>
<?php if ($employeehr_edit->Pager->RecordCount > 0 && $employeehr_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($employeehr_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $employeehr_edit->pageUrl() ?>start=<?php echo $employeehr_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($employeehr_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $employeehr_edit->pageUrl() ?>start=<?php echo $employeehr_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $employeehr_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($employeehr_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $employeehr_edit->pageUrl() ?>start=<?php echo $employeehr_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($employeehr_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $employeehr_edit->pageUrl() ?>start=<?php echo $employeehr_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $employeehr_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="femployeehredit" id="femployeehredit" class="<?php echo $employeehr_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($employeehr_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $employeehr_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employeehr">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$employeehr_edit->IsModal ?>">
<?php if ($employeehr->getCurrentMasterTable() == "employees") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="employees">
<input type="hidden" name="fk_EmployeeID" value="<?php echo $employeehr->EmployeeID->getSessionValue() ?>">
<?php } ?>
<?php if (!$employeehr_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_employeehredit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($employeehr->EmployeeID->Visible) { // EmployeeID ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_EmployeeID" class="form-group row">
		<label id="elh_employeehr_EmployeeID" for="x_EmployeeID" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->EmployeeID->caption() ?><?php echo ($employeehr->EmployeeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->EmployeeID->cellAttributes() ?>>
<?php if ($employeehr->EmployeeID->getSessionValue() <> "") { ?>
<span id="el_employeehr_EmployeeID">
<span<?php echo $employeehr->EmployeeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employeehr->EmployeeID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_EmployeeID" name="x_EmployeeID" value="<?php echo HtmlEncode($employeehr->EmployeeID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_employeehr_EmployeeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employeehr" data-field="x_EmployeeID" data-value-separator="<?php echo $employeehr->EmployeeID->displayValueSeparatorAttribute() ?>" id="x_EmployeeID" name="x_EmployeeID"<?php echo $employeehr->EmployeeID->editAttributes() ?>>
		<?php echo $employeehr->EmployeeID->selectOptionListHtml("x_EmployeeID") ?>
	</select>
</div>
<?php echo $employeehr->EmployeeID->Lookup->getParamTag("p_x_EmployeeID") ?>
</span>
<?php } ?>
<?php echo $employeehr->EmployeeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_EmployeeID">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_EmployeeID"><?php echo $employeehr->EmployeeID->caption() ?><?php echo ($employeehr->EmployeeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->EmployeeID->cellAttributes() ?>>
<?php if ($employeehr->EmployeeID->getSessionValue() <> "") { ?>
<span id="el_employeehr_EmployeeID">
<span<?php echo $employeehr->EmployeeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employeehr->EmployeeID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_EmployeeID" name="x_EmployeeID" value="<?php echo HtmlEncode($employeehr->EmployeeID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_employeehr_EmployeeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employeehr" data-field="x_EmployeeID" data-value-separator="<?php echo $employeehr->EmployeeID->displayValueSeparatorAttribute() ?>" id="x_EmployeeID" name="x_EmployeeID"<?php echo $employeehr->EmployeeID->editAttributes() ?>>
		<?php echo $employeehr->EmployeeID->selectOptionListHtml("x_EmployeeID") ?>
	</select>
</div>
<?php echo $employeehr->EmployeeID->Lookup->getParamTag("p_x_EmployeeID") ?>
</span>
<?php } ?>
<?php echo $employeehr->EmployeeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->JobTitle->Visible) { // JobTitle ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_JobTitle" class="form-group row">
		<label id="elh_employeehr_JobTitle" for="x_JobTitle" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->JobTitle->caption() ?><?php echo ($employeehr->JobTitle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->JobTitle->cellAttributes() ?>>
<span id="el_employeehr_JobTitle">
<input type="text" data-table="employeehr" data-field="x_JobTitle" name="x_JobTitle" id="x_JobTitle" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($employeehr->JobTitle->getPlaceHolder()) ?>" value="<?php echo $employeehr->JobTitle->EditValue ?>"<?php echo $employeehr->JobTitle->editAttributes() ?>>
</span>
<?php echo $employeehr->JobTitle->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_JobTitle">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_JobTitle"><?php echo $employeehr->JobTitle->caption() ?><?php echo ($employeehr->JobTitle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->JobTitle->cellAttributes() ?>>
<span id="el_employeehr_JobTitle">
<input type="text" data-table="employeehr" data-field="x_JobTitle" name="x_JobTitle" id="x_JobTitle" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($employeehr->JobTitle->getPlaceHolder()) ?>" value="<?php echo $employeehr->JobTitle->EditValue ?>"<?php echo $employeehr->JobTitle->editAttributes() ?>>
</span>
<?php echo $employeehr->JobTitle->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->Department->Visible) { // Department ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_Department" class="form-group row">
		<label id="elh_employeehr_Department" for="x_Department" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->Department->caption() ?><?php echo ($employeehr->Department->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->Department->cellAttributes() ?>>
<span id="el_employeehr_Department">
<input type="text" data-table="employeehr" data-field="x_Department" name="x_Department" id="x_Department" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employeehr->Department->getPlaceHolder()) ?>" value="<?php echo $employeehr->Department->EditValue ?>"<?php echo $employeehr->Department->editAttributes() ?>>
</span>
<?php echo $employeehr->Department->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Department">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_Department"><?php echo $employeehr->Department->caption() ?><?php echo ($employeehr->Department->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->Department->cellAttributes() ?>>
<span id="el_employeehr_Department">
<input type="text" data-table="employeehr" data-field="x_Department" name="x_Department" id="x_Department" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employeehr->Department->getPlaceHolder()) ?>" value="<?php echo $employeehr->Department->EditValue ?>"<?php echo $employeehr->Department->editAttributes() ?>>
</span>
<?php echo $employeehr->Department->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->BranchID->Visible) { // BranchID ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_BranchID" class="form-group row">
		<label id="elh_employeehr_BranchID" for="x_BranchID" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->BranchID->caption() ?><?php echo ($employeehr->BranchID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->BranchID->cellAttributes() ?>>
<span id="el_employeehr_BranchID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employeehr" data-field="x_BranchID" data-value-separator="<?php echo $employeehr->BranchID->displayValueSeparatorAttribute() ?>" id="x_BranchID" name="x_BranchID"<?php echo $employeehr->BranchID->editAttributes() ?>>
		<?php echo $employeehr->BranchID->selectOptionListHtml("x_BranchID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "branches") && !$employeehr->BranchID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_BranchID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $employeehr->BranchID->caption() ?>" data-title="<?php echo $employeehr->BranchID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_BranchID',url:'branchesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $employeehr->BranchID->Lookup->getParamTag("p_x_BranchID") ?>
</span>
<?php echo $employeehr->BranchID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BranchID">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_BranchID"><?php echo $employeehr->BranchID->caption() ?><?php echo ($employeehr->BranchID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->BranchID->cellAttributes() ?>>
<span id="el_employeehr_BranchID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employeehr" data-field="x_BranchID" data-value-separator="<?php echo $employeehr->BranchID->displayValueSeparatorAttribute() ?>" id="x_BranchID" name="x_BranchID"<?php echo $employeehr->BranchID->editAttributes() ?>>
		<?php echo $employeehr->BranchID->selectOptionListHtml("x_BranchID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "branches") && !$employeehr->BranchID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_BranchID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $employeehr->BranchID->caption() ?>" data-title="<?php echo $employeehr->BranchID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_BranchID',url:'branchesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $employeehr->BranchID->Lookup->getParamTag("p_x_BranchID") ?>
</span>
<?php echo $employeehr->BranchID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->LawFirmID->Visible) { // LawFirmID ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_LawFirmID" class="form-group row">
		<label id="elh_employeehr_LawFirmID" for="x_LawFirmID" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->LawFirmID->caption() ?><?php echo ($employeehr->LawFirmID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->LawFirmID->cellAttributes() ?>>
<span id="el_employeehr_LawFirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employeehr" data-field="x_LawFirmID" data-value-separator="<?php echo $employeehr->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $employeehr->LawFirmID->editAttributes() ?>>
		<?php echo $employeehr->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawfirm") && !$employeehr->LawFirmID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LawFirmID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $employeehr->LawFirmID->caption() ?>" data-title="<?php echo $employeehr->LawFirmID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LawFirmID',url:'lawfirmaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $employeehr->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</span>
<?php echo $employeehr->LawFirmID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawFirmID">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_LawFirmID"><?php echo $employeehr->LawFirmID->caption() ?><?php echo ($employeehr->LawFirmID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->LawFirmID->cellAttributes() ?>>
<span id="el_employeehr_LawFirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employeehr" data-field="x_LawFirmID" data-value-separator="<?php echo $employeehr->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $employeehr->LawFirmID->editAttributes() ?>>
		<?php echo $employeehr->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawfirm") && !$employeehr->LawFirmID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LawFirmID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $employeehr->LawFirmID->caption() ?>" data-title="<?php echo $employeehr->LawFirmID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LawFirmID',url:'lawfirmaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $employeehr->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</span>
<?php echo $employeehr->LawFirmID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->Notes->Visible) { // Notes ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_employeehr_Notes" for="x_Notes" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->Notes->caption() ?><?php echo ($employeehr->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->Notes->cellAttributes() ?>>
<span id="el_employeehr_Notes">
<textarea data-table="employeehr" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($employeehr->Notes->getPlaceHolder()) ?>"<?php echo $employeehr->Notes->editAttributes() ?>><?php echo $employeehr->Notes->EditValue ?></textarea>
</span>
<?php echo $employeehr->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_Notes"><?php echo $employeehr->Notes->caption() ?><?php echo ($employeehr->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->Notes->cellAttributes() ?>>
<span id="el_employeehr_Notes">
<textarea data-table="employeehr" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($employeehr->Notes->getPlaceHolder()) ?>"<?php echo $employeehr->Notes->editAttributes() ?>><?php echo $employeehr->Notes->EditValue ?></textarea>
</span>
<?php echo $employeehr->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->HireDate->Visible) { // HireDate ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_HireDate" class="form-group row">
		<label id="elh_employeehr_HireDate" for="x_HireDate" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->HireDate->caption() ?><?php echo ($employeehr->HireDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->HireDate->cellAttributes() ?>>
<span id="el_employeehr_HireDate">
<input type="text" data-table="employeehr" data-field="x_HireDate" name="x_HireDate" id="x_HireDate" placeholder="<?php echo HtmlEncode($employeehr->HireDate->getPlaceHolder()) ?>" value="<?php echo $employeehr->HireDate->EditValue ?>"<?php echo $employeehr->HireDate->editAttributes() ?>>
<?php if (!$employeehr->HireDate->ReadOnly && !$employeehr->HireDate->Disabled && !isset($employeehr->HireDate->EditAttrs["readonly"]) && !isset($employeehr->HireDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("femployeehredit", "x_HireDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $employeehr->HireDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_HireDate">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_HireDate"><?php echo $employeehr->HireDate->caption() ?><?php echo ($employeehr->HireDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->HireDate->cellAttributes() ?>>
<span id="el_employeehr_HireDate">
<input type="text" data-table="employeehr" data-field="x_HireDate" name="x_HireDate" id="x_HireDate" placeholder="<?php echo HtmlEncode($employeehr->HireDate->getPlaceHolder()) ?>" value="<?php echo $employeehr->HireDate->EditValue ?>"<?php echo $employeehr->HireDate->editAttributes() ?>>
<?php if (!$employeehr->HireDate->ReadOnly && !$employeehr->HireDate->Disabled && !isset($employeehr->HireDate->EditAttrs["readonly"]) && !isset($employeehr->HireDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("femployeehredit", "x_HireDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $employeehr->HireDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->EndOfServiceDate->Visible) { // EndOfServiceDate ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_EndOfServiceDate" class="form-group row">
		<label id="elh_employeehr_EndOfServiceDate" for="x_EndOfServiceDate" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->EndOfServiceDate->caption() ?><?php echo ($employeehr->EndOfServiceDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->EndOfServiceDate->cellAttributes() ?>>
<span id="el_employeehr_EndOfServiceDate">
<input type="text" data-table="employeehr" data-field="x_EndOfServiceDate" name="x_EndOfServiceDate" id="x_EndOfServiceDate" placeholder="<?php echo HtmlEncode($employeehr->EndOfServiceDate->getPlaceHolder()) ?>" value="<?php echo $employeehr->EndOfServiceDate->EditValue ?>"<?php echo $employeehr->EndOfServiceDate->editAttributes() ?>>
<?php if (!$employeehr->EndOfServiceDate->ReadOnly && !$employeehr->EndOfServiceDate->Disabled && !isset($employeehr->EndOfServiceDate->EditAttrs["readonly"]) && !isset($employeehr->EndOfServiceDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("femployeehredit", "x_EndOfServiceDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $employeehr->EndOfServiceDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_EndOfServiceDate">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_EndOfServiceDate"><?php echo $employeehr->EndOfServiceDate->caption() ?><?php echo ($employeehr->EndOfServiceDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->EndOfServiceDate->cellAttributes() ?>>
<span id="el_employeehr_EndOfServiceDate">
<input type="text" data-table="employeehr" data-field="x_EndOfServiceDate" name="x_EndOfServiceDate" id="x_EndOfServiceDate" placeholder="<?php echo HtmlEncode($employeehr->EndOfServiceDate->getPlaceHolder()) ?>" value="<?php echo $employeehr->EndOfServiceDate->EditValue ?>"<?php echo $employeehr->EndOfServiceDate->editAttributes() ?>>
<?php if (!$employeehr->EndOfServiceDate->ReadOnly && !$employeehr->EndOfServiceDate->Disabled && !isset($employeehr->EndOfServiceDate->EditAttrs["readonly"]) && !isset($employeehr->EndOfServiceDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("femployeehredit", "x_EndOfServiceDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $employeehr->EndOfServiceDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->SocialSecurity23->Visible) { // SocialSecurity# ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_SocialSecurity23" class="form-group row">
		<label id="elh_employeehr_SocialSecurity23" for="x_SocialSecurity23" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->SocialSecurity23->caption() ?><?php echo ($employeehr->SocialSecurity23->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->SocialSecurity23->cellAttributes() ?>>
<span id="el_employeehr_SocialSecurity23">
<input type="text" data-table="employeehr" data-field="x_SocialSecurity23" name="x_SocialSecurity23" id="x_SocialSecurity23" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employeehr->SocialSecurity23->getPlaceHolder()) ?>" value="<?php echo $employeehr->SocialSecurity23->EditValue ?>"<?php echo $employeehr->SocialSecurity23->editAttributes() ?>>
</span>
<?php echo $employeehr->SocialSecurity23->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_SocialSecurity23">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_SocialSecurity23"><?php echo $employeehr->SocialSecurity23->caption() ?><?php echo ($employeehr->SocialSecurity23->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->SocialSecurity23->cellAttributes() ?>>
<span id="el_employeehr_SocialSecurity23">
<input type="text" data-table="employeehr" data-field="x_SocialSecurity23" name="x_SocialSecurity23" id="x_SocialSecurity23" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employeehr->SocialSecurity23->getPlaceHolder()) ?>" value="<?php echo $employeehr->SocialSecurity23->EditValue ?>"<?php echo $employeehr->SocialSecurity23->editAttributes() ?>>
</span>
<?php echo $employeehr->SocialSecurity23->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->Financial23->Visible) { // Financial# ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_Financial23" class="form-group row">
		<label id="elh_employeehr_Financial23" for="x_Financial23" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->Financial23->caption() ?><?php echo ($employeehr->Financial23->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->Financial23->cellAttributes() ?>>
<span id="el_employeehr_Financial23">
<input type="text" data-table="employeehr" data-field="x_Financial23" name="x_Financial23" id="x_Financial23" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employeehr->Financial23->getPlaceHolder()) ?>" value="<?php echo $employeehr->Financial23->EditValue ?>"<?php echo $employeehr->Financial23->editAttributes() ?>>
</span>
<?php echo $employeehr->Financial23->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Financial23">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_Financial23"><?php echo $employeehr->Financial23->caption() ?><?php echo ($employeehr->Financial23->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->Financial23->cellAttributes() ?>>
<span id="el_employeehr_Financial23">
<input type="text" data-table="employeehr" data-field="x_Financial23" name="x_Financial23" id="x_Financial23" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employeehr->Financial23->getPlaceHolder()) ?>" value="<?php echo $employeehr->Financial23->EditValue ?>"<?php echo $employeehr->Financial23->editAttributes() ?>>
</span>
<?php echo $employeehr->Financial23->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->Extra23->Visible) { // Extra# ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_Extra23" class="form-group row">
		<label id="elh_employeehr_Extra23" for="x_Extra23" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->Extra23->caption() ?><?php echo ($employeehr->Extra23->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->Extra23->cellAttributes() ?>>
<span id="el_employeehr_Extra23">
<input type="text" data-table="employeehr" data-field="x_Extra23" name="x_Extra23" id="x_Extra23" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employeehr->Extra23->getPlaceHolder()) ?>" value="<?php echo $employeehr->Extra23->EditValue ?>"<?php echo $employeehr->Extra23->editAttributes() ?>>
</span>
<?php echo $employeehr->Extra23->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Extra23">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_Extra23"><?php echo $employeehr->Extra23->caption() ?><?php echo ($employeehr->Extra23->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->Extra23->cellAttributes() ?>>
<span id="el_employeehr_Extra23">
<input type="text" data-table="employeehr" data-field="x_Extra23" name="x_Extra23" id="x_Extra23" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employeehr->Extra23->getPlaceHolder()) ?>" value="<?php echo $employeehr->Extra23->EditValue ?>"<?php echo $employeehr->Extra23->editAttributes() ?>>
</span>
<?php echo $employeehr->Extra23->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr->WorkNature->Visible) { // WorkNature ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
	<div id="r_WorkNature" class="form-group row">
		<label id="elh_employeehr_WorkNature" for="x_WorkNature" class="<?php echo $employeehr_edit->LeftColumnClass ?>"><?php echo $employeehr->WorkNature->caption() ?><?php echo ($employeehr->WorkNature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employeehr_edit->RightColumnClass ?>"><div<?php echo $employeehr->WorkNature->cellAttributes() ?>>
<span id="el_employeehr_WorkNature">
<input type="text" data-table="employeehr" data-field="x_WorkNature" name="x_WorkNature" id="x_WorkNature" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employeehr->WorkNature->getPlaceHolder()) ?>" value="<?php echo $employeehr->WorkNature->EditValue ?>"<?php echo $employeehr->WorkNature->editAttributes() ?>>
</span>
<?php echo $employeehr->WorkNature->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_WorkNature">
		<td class="<?php echo $employeehr_edit->TableLeftColumnClass ?>"><span id="elh_employeehr_WorkNature"><?php echo $employeehr->WorkNature->caption() ?><?php echo ($employeehr->WorkNature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employeehr->WorkNature->cellAttributes() ?>>
<span id="el_employeehr_WorkNature">
<input type="text" data-table="employeehr" data-field="x_WorkNature" name="x_WorkNature" id="x_WorkNature" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employeehr->WorkNature->getPlaceHolder()) ?>" value="<?php echo $employeehr->WorkNature->EditValue ?>"<?php echo $employeehr->WorkNature->editAttributes() ?>>
</span>
<?php echo $employeehr->WorkNature->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employeehr_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<span id="el_employeehr_EmployeeHrID">
<input type="hidden" data-table="employeehr" data-field="x_EmployeeHrID" name="x_EmployeeHrID" id="x_EmployeeHrID" value="<?php echo HtmlEncode($employeehr->EmployeeHrID->CurrentValue) ?>">
</span>
<?php if (!$employeehr_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $employeehr_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $employeehr_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$employeehr_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$employeehr_edit->IsModal) { ?>
<?php if (!isset($employeehr_edit->Pager)) $employeehr_edit->Pager = new PrevNextPager($employeehr_edit->StartRec, $employeehr_edit->DisplayRecs, $employeehr_edit->TotalRecs, $employeehr_edit->AutoHidePager) ?>
<?php if ($employeehr_edit->Pager->RecordCount > 0 && $employeehr_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($employeehr_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $employeehr_edit->pageUrl() ?>start=<?php echo $employeehr_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($employeehr_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $employeehr_edit->pageUrl() ?>start=<?php echo $employeehr_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $employeehr_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($employeehr_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $employeehr_edit->pageUrl() ?>start=<?php echo $employeehr_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($employeehr_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $employeehr_edit->pageUrl() ?>start=<?php echo $employeehr_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $employeehr_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$employeehr_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$employeehr_edit->terminate();
?>
