<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employees_add = new employees_add();

// Run the page
$employees_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employees_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var femployeesadd = currentForm = new ew.Form("femployeesadd", "add");

// Validate form
femployeesadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($employees_add->Username->Required) { ?>
			elm = this.getElements("x" + infix + "_Username");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->Username->caption(), $employees->Username->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->Password->Required) { ?>
			elm = this.getElements("x" + infix + "_Password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->Password->caption(), $employees->Password->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->EmployeeTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_EmployeeTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->EmployeeTypeID->caption(), $employees->EmployeeTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->TitleID->Required) { ?>
			elm = this.getElements("x" + infix + "_TitleID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->TitleID->caption(), $employees->TitleID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->FirstName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirstName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->FirstName->caption(), $employees->FirstName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->MiddleName->Required) { ?>
			elm = this.getElements("x" + infix + "_MiddleName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->MiddleName->caption(), $employees->MiddleName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->LastName->Required) { ?>
			elm = this.getElements("x" + infix + "_LastName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->LastName->caption(), $employees->LastName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->Photo->Required) { ?>
			felm = this.getElements("x" + infix + "_Photo");
			elm = this.getElements("fn_x" + infix + "_Photo");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $employees->Photo->caption(), $employees->Photo->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->BirthDate->Required) { ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->BirthDate->caption(), $employees->BirthDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($employees->BirthDate->errorMessage()) ?>");
		<?php if ($employees_add->Gender->Required) { ?>
			elm = this.getElements("x" + infix + "_Gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->Gender->caption(), $employees->Gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->_Email->Required) { ?>
			elm = this.getElements("x" + infix + "__Email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->_Email->caption(), $employees->_Email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($employees_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->Notes->caption(), $employees->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
femployeesadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femployeesadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femployeesadd.lists["x_Gender"] = <?php echo $employees_add->Gender->Lookup->toClientList() ?>;
femployeesadd.lists["x_Gender"].options = <?php echo JsonEncode($employees_add->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $employees_add->showPageHeader(); ?>
<?php
$employees_add->showMessage();
?>
<form name="femployeesadd" id="femployeesadd" class="<?php echo $employees_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($employees_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $employees_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employees">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$employees_add->IsModal ?>">
<!-- Fields to prevent google autofill -->
<input class="d-none" type="text" name="<?php echo Encrypt(Random()) ?>">
<input class="d-none" type="password" name="<?php echo Encrypt(Random()) ?>">
<?php if (!$employees_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_employeesadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($employees->Username->Visible) { // Username ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_Username" class="form-group row">
		<label id="elh_employees_Username" for="x_Username" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->Username->caption() ?><?php echo ($employees->Username->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->Username->cellAttributes() ?>>
<span id="el_employees_Username">
<input type="text" data-table="employees" data-field="x_Username" name="x_Username" id="x_Username" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->Username->getPlaceHolder()) ?>" value="<?php echo $employees->Username->EditValue ?>"<?php echo $employees->Username->editAttributes() ?>>
</span>
<?php echo $employees->Username->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Username">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_Username"><?php echo $employees->Username->caption() ?><?php echo ($employees->Username->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Username->cellAttributes() ?>>
<span id="el_employees_Username">
<input type="text" data-table="employees" data-field="x_Username" name="x_Username" id="x_Username" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->Username->getPlaceHolder()) ?>" value="<?php echo $employees->Username->EditValue ?>"<?php echo $employees->Username->editAttributes() ?>>
</span>
<?php echo $employees->Username->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Password->Visible) { // Password ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_Password" class="form-group row">
		<label id="elh_employees_Password" for="x_Password" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->Password->caption() ?><?php echo ($employees->Password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->Password->cellAttributes() ?>>
<span id="el_employees_Password">
<input type="password" data-field="x_Password" name="x_Password" id="x_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employees->Password->getPlaceHolder()) ?>"<?php echo $employees->Password->editAttributes() ?>>
</span>
<?php echo $employees->Password->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Password">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_Password"><?php echo $employees->Password->caption() ?><?php echo ($employees->Password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Password->cellAttributes() ?>>
<span id="el_employees_Password">
<input type="password" data-field="x_Password" name="x_Password" id="x_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employees->Password->getPlaceHolder()) ?>"<?php echo $employees->Password->editAttributes() ?>>
</span>
<?php echo $employees->Password->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
	<span id="el_employees_EmployeeTypeID">
	<input type="hidden" data-table="employees" data-field="x_EmployeeTypeID" name="x_EmployeeTypeID" id="x_EmployeeTypeID" value="<?php echo HtmlEncode($employees->EmployeeTypeID->CurrentValue) ?>">
	</span>
	<span id="el_employees_TitleID">
	<input type="hidden" data-table="employees" data-field="x_TitleID" name="x_TitleID" id="x_TitleID" value="<?php echo HtmlEncode($employees->TitleID->CurrentValue) ?>">
	</span>
<?php if ($employees->FirstName->Visible) { // FirstName ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_FirstName" class="form-group row">
		<label id="elh_employees_FirstName" for="x_FirstName" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->FirstName->caption() ?><?php echo ($employees->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->FirstName->cellAttributes() ?>>
<span id="el_employees_FirstName">
<input type="text" data-table="employees" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->FirstName->getPlaceHolder()) ?>" value="<?php echo $employees->FirstName->EditValue ?>"<?php echo $employees->FirstName->editAttributes() ?>>
</span>
<?php echo $employees->FirstName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_FirstName"><?php echo $employees->FirstName->caption() ?><?php echo ($employees->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->FirstName->cellAttributes() ?>>
<span id="el_employees_FirstName">
<input type="text" data-table="employees" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->FirstName->getPlaceHolder()) ?>" value="<?php echo $employees->FirstName->EditValue ?>"<?php echo $employees->FirstName->editAttributes() ?>>
</span>
<?php echo $employees->FirstName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->MiddleName->Visible) { // MiddleName ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_MiddleName" class="form-group row">
		<label id="elh_employees_MiddleName" for="x_MiddleName" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->MiddleName->caption() ?><?php echo ($employees->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->MiddleName->cellAttributes() ?>>
<span id="el_employees_MiddleName">
<input type="text" data-table="employees" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->MiddleName->getPlaceHolder()) ?>" value="<?php echo $employees->MiddleName->EditValue ?>"<?php echo $employees->MiddleName->editAttributes() ?>>
</span>
<?php echo $employees->MiddleName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_MiddleName"><?php echo $employees->MiddleName->caption() ?><?php echo ($employees->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->MiddleName->cellAttributes() ?>>
<span id="el_employees_MiddleName">
<input type="text" data-table="employees" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->MiddleName->getPlaceHolder()) ?>" value="<?php echo $employees->MiddleName->EditValue ?>"<?php echo $employees->MiddleName->editAttributes() ?>>
</span>
<?php echo $employees->MiddleName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->LastName->Visible) { // LastName ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_LastName" class="form-group row">
		<label id="elh_employees_LastName" for="x_LastName" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->LastName->caption() ?><?php echo ($employees->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->LastName->cellAttributes() ?>>
<span id="el_employees_LastName">
<input type="text" data-table="employees" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->LastName->getPlaceHolder()) ?>" value="<?php echo $employees->LastName->EditValue ?>"<?php echo $employees->LastName->editAttributes() ?>>
</span>
<?php echo $employees->LastName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_LastName"><?php echo $employees->LastName->caption() ?><?php echo ($employees->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->LastName->cellAttributes() ?>>
<span id="el_employees_LastName">
<input type="text" data-table="employees" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->LastName->getPlaceHolder()) ?>" value="<?php echo $employees->LastName->EditValue ?>"<?php echo $employees->LastName->editAttributes() ?>>
</span>
<?php echo $employees->LastName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Photo->Visible) { // Photo ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_Photo" class="form-group row">
		<label id="elh_employees_Photo" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->Photo->caption() ?><?php echo ($employees->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->Photo->cellAttributes() ?>>
<span id="el_employees_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $employees->Photo->title() ? $employees->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($employees->Photo->ReadOnly || $employees->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="employees" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $employees->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $employees->Photo->Upload->FileName ?>">
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $employees->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $employees->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $employees->Photo->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Photo">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_Photo"><?php echo $employees->Photo->caption() ?><?php echo ($employees->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Photo->cellAttributes() ?>>
<span id="el_employees_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $employees->Photo->title() ? $employees->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($employees->Photo->ReadOnly || $employees->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="employees" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $employees->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $employees->Photo->Upload->FileName ?>">
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $employees->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $employees->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $employees->Photo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->BirthDate->Visible) { // BirthDate ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_BirthDate" class="form-group row">
		<label id="elh_employees_BirthDate" for="x_BirthDate" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->BirthDate->caption() ?><?php echo ($employees->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->BirthDate->cellAttributes() ?>>
<span id="el_employees_BirthDate">
<input type="text" data-table="employees" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($employees->BirthDate->getPlaceHolder()) ?>" value="<?php echo $employees->BirthDate->EditValue ?>"<?php echo $employees->BirthDate->editAttributes() ?>>
<?php if (!$employees->BirthDate->ReadOnly && !$employees->BirthDate->Disabled && !isset($employees->BirthDate->EditAttrs["readonly"]) && !isset($employees->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("femployeesadd", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $employees->BirthDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_BirthDate"><?php echo $employees->BirthDate->caption() ?><?php echo ($employees->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->BirthDate->cellAttributes() ?>>
<span id="el_employees_BirthDate">
<input type="text" data-table="employees" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($employees->BirthDate->getPlaceHolder()) ?>" value="<?php echo $employees->BirthDate->EditValue ?>"<?php echo $employees->BirthDate->editAttributes() ?>>
<?php if (!$employees->BirthDate->ReadOnly && !$employees->BirthDate->Disabled && !isset($employees->BirthDate->EditAttrs["readonly"]) && !isset($employees->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("femployeesadd", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $employees->BirthDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Gender->Visible) { // Gender ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_Gender" class="form-group row">
		<label id="elh_employees_Gender" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->Gender->caption() ?><?php echo ($employees->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->Gender->cellAttributes() ?>>
<span id="el_employees_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="employees" data-field="x_Gender" data-value-separator="<?php echo $employees->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $employees->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employees->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $employees->Gender->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Gender">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_Gender"><?php echo $employees->Gender->caption() ?><?php echo ($employees->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Gender->cellAttributes() ?>>
<span id="el_employees_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="employees" data-field="x_Gender" data-value-separator="<?php echo $employees->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $employees->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employees->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $employees->Gender->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->_Email->Visible) { // Email ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r__Email" class="form-group row">
		<label id="elh_employees__Email" for="x__Email" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->_Email->caption() ?><?php echo ($employees->_Email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->_Email->cellAttributes() ?>>
<span id="el_employees__Email">
<input type="text" data-table="employees" data-field="x__Email" name="x__Email" id="x__Email" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employees->_Email->getPlaceHolder()) ?>" value="<?php echo $employees->_Email->EditValue ?>"<?php echo $employees->_Email->editAttributes() ?>>
</span>
<?php echo $employees->_Email->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r__Email">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees__Email"><?php echo $employees->_Email->caption() ?><?php echo ($employees->_Email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->_Email->cellAttributes() ?>>
<span id="el_employees__Email">
<input type="text" data-table="employees" data-field="x__Email" name="x__Email" id="x__Email" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employees->_Email->getPlaceHolder()) ?>" value="<?php echo $employees->_Email->EditValue ?>"<?php echo $employees->_Email->editAttributes() ?>>
</span>
<?php echo $employees->_Email->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Notes->Visible) { // Notes ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_employees_Notes" class="<?php echo $employees_add->LeftColumnClass ?>"><?php echo $employees->Notes->caption() ?><?php echo ($employees->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employees_add->RightColumnClass ?>"><div<?php echo $employees->Notes->cellAttributes() ?>>
<span id="el_employees_Notes">
<?php AppendClass($employees->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="employees" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($employees->Notes->getPlaceHolder()) ?>"<?php echo $employees->Notes->editAttributes() ?>><?php echo $employees->Notes->EditValue ?></textarea>
<script>
ew.createEditor("femployeesadd", "x_Notes", 35, 4, <?php echo ($employees->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $employees->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $employees_add->TableLeftColumnClass ?>"><span id="elh_employees_Notes"><?php echo $employees->Notes->caption() ?><?php echo ($employees->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Notes->cellAttributes() ?>>
<span id="el_employees_Notes">
<?php AppendClass($employees->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="employees" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($employees->Notes->getPlaceHolder()) ?>"<?php echo $employees->Notes->editAttributes() ?>><?php echo $employees->Notes->EditValue ?></textarea>
<script>
ew.createEditor("femployeesadd", "x_Notes", 35, 4, <?php echo ($employees->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $employees->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if ($employees->getCurrentDetailTable() <> "") { ?>
<?php
	$employees_add->DetailPages->ValidKeys = explode(",", $employees->getCurrentDetailTable());
	$firstActiveDetailTable = $employees_add->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="employees_add_details"><!-- tabs -->
	<ul class="<?php echo $employees_add->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("employeehr", explode(",", $employees->getCurrentDetailTable())) && $employeehr->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeehr") {
			$firstActiveDetailTable = "employeehr";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $employees_add->DetailPages->pageStyle("employeehr") ?>" href="#tab_employeehr" data-toggle="tab"><?php echo $Language->TablePhrase("employeehr", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("employeeaddress", explode(",", $employees->getCurrentDetailTable())) && $employeeaddress->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeeaddress") {
			$firstActiveDetailTable = "employeeaddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $employees_add->DetailPages->pageStyle("employeeaddress") ?>" href="#tab_employeeaddress" data-toggle="tab"><?php echo $Language->TablePhrase("employeeaddress", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("employeecontact", explode(",", $employees->getCurrentDetailTable())) && $employeecontact->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeecontact") {
			$firstActiveDetailTable = "employeecontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $employees_add->DetailPages->pageStyle("employeecontact") ?>" href="#tab_employeecontact" data-toggle="tab"><?php echo $Language->TablePhrase("employeecontact", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("employeeperson", explode(",", $employees->getCurrentDetailTable())) && $employeeperson->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeeperson") {
			$firstActiveDetailTable = "employeeperson";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $employees_add->DetailPages->pageStyle("employeeperson") ?>" href="#tab_employeeperson" data-toggle="tab"><?php echo $Language->TablePhrase("employeeperson", "TblCaption") ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("employeehr", explode(",", $employees->getCurrentDetailTable())) && $employeehr->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeehr")
			$firstActiveDetailTable = "employeehr";
?>
		<div class="tab-pane<?php echo $employees_add->DetailPages->pageStyle("employeehr") ?>" id="tab_employeehr"><!-- page* -->
<?php include_once "employeehrgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("employeeaddress", explode(",", $employees->getCurrentDetailTable())) && $employeeaddress->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeeaddress")
			$firstActiveDetailTable = "employeeaddress";
?>
		<div class="tab-pane<?php echo $employees_add->DetailPages->pageStyle("employeeaddress") ?>" id="tab_employeeaddress"><!-- page* -->
<?php include_once "employeeaddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("employeecontact", explode(",", $employees->getCurrentDetailTable())) && $employeecontact->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeecontact")
			$firstActiveDetailTable = "employeecontact";
?>
		<div class="tab-pane<?php echo $employees_add->DetailPages->pageStyle("employeecontact") ?>" id="tab_employeecontact"><!-- page* -->
<?php include_once "employeecontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("employeeperson", explode(",", $employees->getCurrentDetailTable())) && $employeeperson->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeeperson")
			$firstActiveDetailTable = "employeeperson";
?>
		<div class="tab-pane<?php echo $employees_add->DetailPages->pageStyle("employeeperson") ?>" id="tab_employeeperson"><!-- page* -->
<?php include_once "employeepersongrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
<?php if (!$employees_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $employees_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $employees_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$employees_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$employees_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$employees_add->terminate();
?>
