<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employees_search = new employees_search();

// Run the page
$employees_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employees_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($employees_search->IsModal) { ?>
var femployeessearch = currentAdvancedSearchForm = new ew.Form("femployeessearch", "search");
<?php } else { ?>
var femployeessearch = currentForm = new ew.Form("femployeessearch", "search");
<?php } ?>

// Form_CustomValidate event
femployeessearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femployeessearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femployeessearch.lists["x_Gender"] = <?php echo $employees_search->Gender->Lookup->toClientList() ?>;
femployeessearch.lists["x_Gender"].options = <?php echo JsonEncode($employees_search->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

femployeessearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_BirthDate");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($employees->BirthDate->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $employees_search->showPageHeader(); ?>
<?php
$employees_search->showMessage();
?>
<form name="femployeessearch" id="femployeessearch" class="<?php echo $employees_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($employees_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $employees_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employees">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$employees_search->IsModal ?>">
<?php if (!$employees_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_employeessearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($employees->EmployeeID->Visible) { // EmployeeID ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_EmployeeID" class="form-group row">
		<label class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_EmployeeID"><?php echo $employees->EmployeeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_EmployeeID" id="z_EmployeeID" value="="></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->EmployeeID->cellAttributes() ?>>
			<span id="el_employees_EmployeeID">
<input type="text" data-table="employees" data-field="x_EmployeeID" name="x_EmployeeID" id="x_EmployeeID" placeholder="<?php echo HtmlEncode($employees->EmployeeID->getPlaceHolder()) ?>" value="<?php echo $employees->EmployeeID->EditValue ?>"<?php echo $employees->EmployeeID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_EmployeeID">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_EmployeeID"><?php echo $employees->EmployeeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_EmployeeID" id="z_EmployeeID" value="="></span></td>
		<td<?php echo $employees->EmployeeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_EmployeeID">
<input type="text" data-table="employees" data-field="x_EmployeeID" name="x_EmployeeID" id="x_EmployeeID" placeholder="<?php echo HtmlEncode($employees->EmployeeID->getPlaceHolder()) ?>" value="<?php echo $employees->EmployeeID->EditValue ?>"<?php echo $employees->EmployeeID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Username->Visible) { // Username ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_Username" class="form-group row">
		<label for="x_Username" class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_Username"><?php echo $employees->Username->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Username" id="z_Username" value="LIKE"></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->Username->cellAttributes() ?>>
			<span id="el_employees_Username">
<input type="text" data-table="employees" data-field="x_Username" name="x_Username" id="x_Username" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->Username->getPlaceHolder()) ?>" value="<?php echo $employees->Username->EditValue ?>"<?php echo $employees->Username->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Username">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_Username"><?php echo $employees->Username->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Username" id="z_Username" value="LIKE"></span></td>
		<td<?php echo $employees->Username->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_Username">
<input type="text" data-table="employees" data-field="x_Username" name="x_Username" id="x_Username" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->Username->getPlaceHolder()) ?>" value="<?php echo $employees->Username->EditValue ?>"<?php echo $employees->Username->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Password->Visible) { // Password ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_Password" class="form-group row">
		<label for="x_Password" class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_Password"><?php echo $employees->Password->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Password" id="z_Password" value="LIKE"></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->Password->cellAttributes() ?>>
			<span id="el_employees_Password">
<input type="text" data-table="employees" data-field="x_Password" name="x_Password" id="x_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employees->Password->getPlaceHolder()) ?>" value="<?php echo $employees->Password->EditValue ?>"<?php echo $employees->Password->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Password">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_Password"><?php echo $employees->Password->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Password" id="z_Password" value="LIKE"></span></td>
		<td<?php echo $employees->Password->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_Password">
<input type="text" data-table="employees" data-field="x_Password" name="x_Password" id="x_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employees->Password->getPlaceHolder()) ?>" value="<?php echo $employees->Password->EditValue ?>"<?php echo $employees->Password->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->EmployeeTypeID->Visible) { // EmployeeTypeID ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_EmployeeTypeID" class="form-group row">
		<label class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_EmployeeTypeID"><?php echo $employees->EmployeeTypeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_EmployeeTypeID" id="z_EmployeeTypeID" value="="></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->EmployeeTypeID->cellAttributes() ?>>
			<span id="el_employees_EmployeeTypeID">
<input type="text" data-table="employees" data-field="x_EmployeeTypeID" name="x_EmployeeTypeID" id="x_EmployeeTypeID" size="30" placeholder="<?php echo HtmlEncode($employees->EmployeeTypeID->getPlaceHolder()) ?>" value="<?php echo $employees->EmployeeTypeID->EditValue ?>"<?php echo $employees->EmployeeTypeID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_EmployeeTypeID">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_EmployeeTypeID"><?php echo $employees->EmployeeTypeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_EmployeeTypeID" id="z_EmployeeTypeID" value="="></span></td>
		<td<?php echo $employees->EmployeeTypeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_EmployeeTypeID">
<input type="text" data-table="employees" data-field="x_EmployeeTypeID" name="x_EmployeeTypeID" id="x_EmployeeTypeID" size="30" placeholder="<?php echo HtmlEncode($employees->EmployeeTypeID->getPlaceHolder()) ?>" value="<?php echo $employees->EmployeeTypeID->EditValue ?>"<?php echo $employees->EmployeeTypeID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->TitleID->Visible) { // TitleID ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_TitleID" class="form-group row">
		<label class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_TitleID"><?php echo $employees->TitleID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_TitleID" id="z_TitleID" value="="></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->TitleID->cellAttributes() ?>>
			<span id="el_employees_TitleID">
<input type="text" data-table="employees" data-field="x_TitleID" name="x_TitleID" id="x_TitleID" size="30" placeholder="<?php echo HtmlEncode($employees->TitleID->getPlaceHolder()) ?>" value="<?php echo $employees->TitleID->EditValue ?>"<?php echo $employees->TitleID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_TitleID">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_TitleID"><?php echo $employees->TitleID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_TitleID" id="z_TitleID" value="="></span></td>
		<td<?php echo $employees->TitleID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_TitleID">
<input type="text" data-table="employees" data-field="x_TitleID" name="x_TitleID" id="x_TitleID" size="30" placeholder="<?php echo HtmlEncode($employees->TitleID->getPlaceHolder()) ?>" value="<?php echo $employees->TitleID->EditValue ?>"<?php echo $employees->TitleID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->FirstName->Visible) { // FirstName ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_FirstName" class="form-group row">
		<label for="x_FirstName" class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_FirstName"><?php echo $employees->FirstName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FirstName" id="z_FirstName" value="LIKE"></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->FirstName->cellAttributes() ?>>
			<span id="el_employees_FirstName">
<input type="text" data-table="employees" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->FirstName->getPlaceHolder()) ?>" value="<?php echo $employees->FirstName->EditValue ?>"<?php echo $employees->FirstName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_FirstName"><?php echo $employees->FirstName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FirstName" id="z_FirstName" value="LIKE"></span></td>
		<td<?php echo $employees->FirstName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_FirstName">
<input type="text" data-table="employees" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->FirstName->getPlaceHolder()) ?>" value="<?php echo $employees->FirstName->EditValue ?>"<?php echo $employees->FirstName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->MiddleName->Visible) { // MiddleName ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_MiddleName" class="form-group row">
		<label for="x_MiddleName" class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_MiddleName"><?php echo $employees->MiddleName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_MiddleName" id="z_MiddleName" value="LIKE"></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->MiddleName->cellAttributes() ?>>
			<span id="el_employees_MiddleName">
<input type="text" data-table="employees" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->MiddleName->getPlaceHolder()) ?>" value="<?php echo $employees->MiddleName->EditValue ?>"<?php echo $employees->MiddleName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_MiddleName"><?php echo $employees->MiddleName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_MiddleName" id="z_MiddleName" value="LIKE"></span></td>
		<td<?php echo $employees->MiddleName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_MiddleName">
<input type="text" data-table="employees" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->MiddleName->getPlaceHolder()) ?>" value="<?php echo $employees->MiddleName->EditValue ?>"<?php echo $employees->MiddleName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->LastName->Visible) { // LastName ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_LastName" class="form-group row">
		<label for="x_LastName" class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_LastName"><?php echo $employees->LastName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_LastName" id="z_LastName" value="LIKE"></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->LastName->cellAttributes() ?>>
			<span id="el_employees_LastName">
<input type="text" data-table="employees" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->LastName->getPlaceHolder()) ?>" value="<?php echo $employees->LastName->EditValue ?>"<?php echo $employees->LastName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_LastName"><?php echo $employees->LastName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_LastName" id="z_LastName" value="LIKE"></span></td>
		<td<?php echo $employees->LastName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_LastName">
<input type="text" data-table="employees" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->LastName->getPlaceHolder()) ?>" value="<?php echo $employees->LastName->EditValue ?>"<?php echo $employees->LastName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Photo->Visible) { // Photo ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_Photo" class="form-group row">
		<label class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_Photo"><?php echo $employees->Photo->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Photo" id="z_Photo" value="LIKE"></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->Photo->cellAttributes() ?>>
			<span id="el_employees_Photo">
<input type="text" data-table="employees" data-field="x_Photo" name="x_Photo" id="x_Photo" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($employees->Photo->getPlaceHolder()) ?>" value="<?php echo $employees->Photo->EditValue ?>"<?php echo $employees->Photo->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Photo">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_Photo"><?php echo $employees->Photo->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Photo" id="z_Photo" value="LIKE"></span></td>
		<td<?php echo $employees->Photo->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_Photo">
<input type="text" data-table="employees" data-field="x_Photo" name="x_Photo" id="x_Photo" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($employees->Photo->getPlaceHolder()) ?>" value="<?php echo $employees->Photo->EditValue ?>"<?php echo $employees->Photo->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->BirthDate->Visible) { // BirthDate ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_BirthDate" class="form-group row">
		<label for="x_BirthDate" class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_BirthDate"><?php echo $employees->BirthDate->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_BirthDate" id="z_BirthDate" value="="></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->BirthDate->cellAttributes() ?>>
			<span id="el_employees_BirthDate">
<input type="text" data-table="employees" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($employees->BirthDate->getPlaceHolder()) ?>" value="<?php echo $employees->BirthDate->EditValue ?>"<?php echo $employees->BirthDate->editAttributes() ?>>
<?php if (!$employees->BirthDate->ReadOnly && !$employees->BirthDate->Disabled && !isset($employees->BirthDate->EditAttrs["readonly"]) && !isset($employees->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("femployeessearch", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_BirthDate"><?php echo $employees->BirthDate->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_BirthDate" id="z_BirthDate" value="="></span></td>
		<td<?php echo $employees->BirthDate->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_BirthDate">
<input type="text" data-table="employees" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($employees->BirthDate->getPlaceHolder()) ?>" value="<?php echo $employees->BirthDate->EditValue ?>"<?php echo $employees->BirthDate->editAttributes() ?>>
<?php if (!$employees->BirthDate->ReadOnly && !$employees->BirthDate->Disabled && !isset($employees->BirthDate->EditAttrs["readonly"]) && !isset($employees->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("femployeessearch", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Gender->Visible) { // Gender ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_Gender" class="form-group row">
		<label class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_Gender"><?php echo $employees->Gender->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Gender" id="z_Gender" value="="></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->Gender->cellAttributes() ?>>
			<span id="el_employees_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="employees" data-field="x_Gender" data-value-separator="<?php echo $employees->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $employees->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employees->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Gender">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_Gender"><?php echo $employees->Gender->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Gender" id="z_Gender" value="="></span></td>
		<td<?php echo $employees->Gender->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="employees" data-field="x_Gender" data-value-separator="<?php echo $employees->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $employees->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employees->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Notes->Visible) { // Notes ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label class="<?php echo $employees_search->LeftColumnClass ?>"><span id="elh_employees_Notes"><?php echo $employees->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $employees_search->RightColumnClass ?>"><div<?php echo $employees->Notes->cellAttributes() ?>>
			<span id="el_employees_Notes">
<input type="text" data-table="employees" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($employees->Notes->getPlaceHolder()) ?>" value="<?php echo $employees->Notes->EditValue ?>"<?php echo $employees->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $employees_search->TableLeftColumnClass ?>"><span id="elh_employees_Notes"><?php echo $employees->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $employees->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_employees_Notes">
<input type="text" data-table="employees" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($employees->Notes->getPlaceHolder()) ?>" value="<?php echo $employees->Notes->EditValue ?>"<?php echo $employees->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$employees_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $employees_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$employees_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$employees_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$employees_search->terminate();
?>
