<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employees_view = new employees_view();

// Run the page
$employees_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employees_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$employees->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var femployeesview = currentForm = new ew.Form("femployeesview", "view");

// Form_CustomValidate event
femployeesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femployeesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femployeesview.lists["x_Gender"] = <?php echo $employees_view->Gender->Lookup->toClientList() ?>;
femployeesview.lists["x_Gender"].options = <?php echo JsonEncode($employees_view->Gender->options(FALSE, TRUE)) ?>;
femployeesview.lists["x_UserLevel"] = <?php echo $employees_view->UserLevel->Lookup->toClientList() ?>;
femployeesview.lists["x_UserLevel"].options = <?php echo JsonEncode($employees_view->UserLevel->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$employees->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $employees_view->ExportOptions->render("body") ?>
<?php $employees_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $employees_view->showPageHeader(); ?>
<?php
$employees_view->showMessage();
?>
<?php if (!$employees_view->IsModal) { ?>
<?php if (!$employees->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($employees_view->Pager)) $employees_view->Pager = new PrevNextPager($employees_view->StartRec, $employees_view->DisplayRecs, $employees_view->TotalRecs, $employees_view->AutoHidePager) ?>
<?php if ($employees_view->Pager->RecordCount > 0 && $employees_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($employees_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $employees_view->pageUrl() ?>start=<?php echo $employees_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($employees_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $employees_view->pageUrl() ?>start=<?php echo $employees_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $employees_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($employees_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $employees_view->pageUrl() ?>start=<?php echo $employees_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($employees_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $employees_view->pageUrl() ?>start=<?php echo $employees_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $employees_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="femployeesview" id="femployeesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($employees_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $employees_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employees">
<input type="hidden" name="modal" value="<?php echo (int)$employees_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($employees->EmployeeID->Visible) { // EmployeeID ?>
	<tr id="r_EmployeeID">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_EmployeeID"><?php echo $employees->EmployeeID->caption() ?></span></td>
		<td data-name="EmployeeID"<?php echo $employees->EmployeeID->cellAttributes() ?>>
<span id="el_employees_EmployeeID">
<span<?php echo $employees->EmployeeID->viewAttributes() ?>>
<?php echo $employees->EmployeeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->Username->Visible) { // Username ?>
	<tr id="r_Username">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_Username"><?php echo $employees->Username->caption() ?></span></td>
		<td data-name="Username"<?php echo $employees->Username->cellAttributes() ?>>
<span id="el_employees_Username">
<span<?php echo $employees->Username->viewAttributes() ?>>
<?php echo $employees->Username->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->Password->Visible) { // Password ?>
	<tr id="r_Password">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_Password"><?php echo $employees->Password->caption() ?></span></td>
		<td data-name="Password"<?php echo $employees->Password->cellAttributes() ?>>
<span id="el_employees_Password">
<span<?php echo $employees->Password->viewAttributes() ?>>
<?php echo $employees->Password->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->EmployeeTypeID->Visible) { // EmployeeTypeID ?>
	<tr id="r_EmployeeTypeID">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_EmployeeTypeID"><?php echo $employees->EmployeeTypeID->caption() ?></span></td>
		<td data-name="EmployeeTypeID"<?php echo $employees->EmployeeTypeID->cellAttributes() ?>>
<span id="el_employees_EmployeeTypeID">
<span<?php echo $employees->EmployeeTypeID->viewAttributes() ?>>
<?php echo $employees->EmployeeTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->TitleID->Visible) { // TitleID ?>
	<tr id="r_TitleID">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_TitleID"><?php echo $employees->TitleID->caption() ?></span></td>
		<td data-name="TitleID"<?php echo $employees->TitleID->cellAttributes() ?>>
<span id="el_employees_TitleID">
<span<?php echo $employees->TitleID->viewAttributes() ?>>
<?php echo $employees->TitleID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->FirstName->Visible) { // FirstName ?>
	<tr id="r_FirstName">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_FirstName"><?php echo $employees->FirstName->caption() ?></span></td>
		<td data-name="FirstName"<?php echo $employees->FirstName->cellAttributes() ?>>
<span id="el_employees_FirstName">
<span<?php echo $employees->FirstName->viewAttributes() ?>>
<?php echo $employees->FirstName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->MiddleName->Visible) { // MiddleName ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_MiddleName"><?php echo $employees->MiddleName->caption() ?></span></td>
		<td data-name="MiddleName"<?php echo $employees->MiddleName->cellAttributes() ?>>
<span id="el_employees_MiddleName">
<span<?php echo $employees->MiddleName->viewAttributes() ?>>
<?php echo $employees->MiddleName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->LastName->Visible) { // LastName ?>
	<tr id="r_LastName">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_LastName"><?php echo $employees->LastName->caption() ?></span></td>
		<td data-name="LastName"<?php echo $employees->LastName->cellAttributes() ?>>
<span id="el_employees_LastName">
<span<?php echo $employees->LastName->viewAttributes() ?>>
<?php echo $employees->LastName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->Photo->Visible) { // Photo ?>
	<tr id="r_Photo">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_Photo"><?php echo $employees->Photo->caption() ?></span></td>
		<td data-name="Photo"<?php echo $employees->Photo->cellAttributes() ?>>
<span id="el_employees_Photo">
<span>
<?php echo GetFileViewTag($employees->Photo, $employees->Photo->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->BirthDate->Visible) { // BirthDate ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_BirthDate"><?php echo $employees->BirthDate->caption() ?></span></td>
		<td data-name="BirthDate"<?php echo $employees->BirthDate->cellAttributes() ?>>
<span id="el_employees_BirthDate">
<span<?php echo $employees->BirthDate->viewAttributes() ?>>
<?php echo $employees->BirthDate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->Gender->Visible) { // Gender ?>
	<tr id="r_Gender">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_Gender"><?php echo $employees->Gender->caption() ?></span></td>
		<td data-name="Gender"<?php echo $employees->Gender->cellAttributes() ?>>
<span id="el_employees_Gender">
<span<?php echo $employees->Gender->viewAttributes() ?>>
<?php echo $employees->Gender->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->_Email->Visible) { // Email ?>
	<tr id="r__Email">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees__Email"><?php echo $employees->_Email->caption() ?></span></td>
		<td data-name="_Email"<?php echo $employees->_Email->cellAttributes() ?>>
<span id="el_employees__Email">
<span<?php echo $employees->_Email->viewAttributes() ?>>
<?php echo $employees->_Email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_Notes"><?php echo $employees->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $employees->Notes->cellAttributes() ?>>
<span id="el_employees_Notes">
<span<?php echo $employees->Notes->viewAttributes() ?>>
<?php echo $employees->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employees->UserLevel->Visible) { // UserLevel ?>
	<tr id="r_UserLevel">
		<td class="<?php echo $employees_view->TableLeftColumnClass ?>"><span id="elh_employees_UserLevel"><?php echo $employees->UserLevel->caption() ?></span></td>
		<td data-name="UserLevel"<?php echo $employees->UserLevel->cellAttributes() ?>>
<span id="el_employees_UserLevel">
<span<?php echo $employees->UserLevel->viewAttributes() ?>>
<?php echo $employees->UserLevel->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$employees_view->IsModal) { ?>
<?php if (!$employees->isExport()) { ?>
<?php if (!isset($employees_view->Pager)) $employees_view->Pager = new PrevNextPager($employees_view->StartRec, $employees_view->DisplayRecs, $employees_view->TotalRecs, $employees_view->AutoHidePager) ?>
<?php if ($employees_view->Pager->RecordCount > 0 && $employees_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($employees_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $employees_view->pageUrl() ?>start=<?php echo $employees_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($employees_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $employees_view->pageUrl() ?>start=<?php echo $employees_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $employees_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($employees_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $employees_view->pageUrl() ?>start=<?php echo $employees_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($employees_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $employees_view->pageUrl() ?>start=<?php echo $employees_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $employees_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php if ($employees->getCurrentDetailTable() <> "") { ?>
<?php
	$employees_view->DetailPages->ValidKeys = explode(",", $employees->getCurrentDetailTable());
	$firstActiveDetailTable = $employees_view->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="employees_view_details"><!-- tabs -->
	<ul class="<?php echo $employees_view->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("employeehr", explode(",", $employees->getCurrentDetailTable())) && $employeehr->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeehr") {
			$firstActiveDetailTable = "employeehr";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $employees_view->DetailPages->pageStyle("employeehr") ?>" href="#tab_employeehr" data-toggle="tab"><?php echo $Language->TablePhrase("employeehr", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $employees_view->employeehr_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("employeeaddress", explode(",", $employees->getCurrentDetailTable())) && $employeeaddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeeaddress") {
			$firstActiveDetailTable = "employeeaddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $employees_view->DetailPages->pageStyle("employeeaddress") ?>" href="#tab_employeeaddress" data-toggle="tab"><?php echo $Language->TablePhrase("employeeaddress", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $employees_view->employeeaddress_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("employeecontact", explode(",", $employees->getCurrentDetailTable())) && $employeecontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeecontact") {
			$firstActiveDetailTable = "employeecontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $employees_view->DetailPages->pageStyle("employeecontact") ?>" href="#tab_employeecontact" data-toggle="tab"><?php echo $Language->TablePhrase("employeecontact", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $employees_view->employeecontact_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("employeeperson", explode(",", $employees->getCurrentDetailTable())) && $employeeperson->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeeperson") {
			$firstActiveDetailTable = "employeeperson";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $employees_view->DetailPages->pageStyle("employeeperson") ?>" href="#tab_employeeperson" data-toggle="tab"><?php echo $Language->TablePhrase("employeeperson", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $employees_view->employeeperson_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("employeehr", explode(",", $employees->getCurrentDetailTable())) && $employeehr->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeehr")
			$firstActiveDetailTable = "employeehr";
?>
		<div class="tab-pane<?php echo $employees_view->DetailPages->pageStyle("employeehr") ?>" id="tab_employeehr"><!-- page* -->
<?php include_once "employeehrgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("employeeaddress", explode(",", $employees->getCurrentDetailTable())) && $employeeaddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeeaddress")
			$firstActiveDetailTable = "employeeaddress";
?>
		<div class="tab-pane<?php echo $employees_view->DetailPages->pageStyle("employeeaddress") ?>" id="tab_employeeaddress"><!-- page* -->
<?php include_once "employeeaddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("employeecontact", explode(",", $employees->getCurrentDetailTable())) && $employeecontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeecontact")
			$firstActiveDetailTable = "employeecontact";
?>
		<div class="tab-pane<?php echo $employees_view->DetailPages->pageStyle("employeecontact") ?>" id="tab_employeecontact"><!-- page* -->
<?php include_once "employeecontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("employeeperson", explode(",", $employees->getCurrentDetailTable())) && $employeeperson->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "employeeperson")
			$firstActiveDetailTable = "employeeperson";
?>
		<div class="tab-pane<?php echo $employees_view->DetailPages->pageStyle("employeeperson") ?>" id="tab_employeeperson"><!-- page* -->
<?php include_once "employeepersongrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
</form>
<?php
$employees_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$employees->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$employees_view->terminate();
?>
