<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($judgecontact_grid))
	$judgecontact_grid = new judgecontact_grid();

// Run the page
$judgecontact_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judgecontact_grid->Page_Render();
?>
<?php if (!$judgecontact->isExport()) { ?>
<script>

// Form object
var fjudgecontactgrid = new ew.Form("fjudgecontactgrid", "grid");
fjudgecontactgrid.formKeyCountName = '<?php echo $judgecontact_grid->FormKeyCountName ?>';

// Validate form
fjudgecontactgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($judgecontact_grid->JudgeID->Required) { ?>
			elm = this.getElements("x" + infix + "_JudgeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgecontact->JudgeID->caption(), $judgecontact->JudgeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judgecontact_grid->ContactTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_ContactTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgecontact->ContactTypeID->caption(), $judgecontact->ContactTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judgecontact_grid->Contact->Required) { ?>
			elm = this.getElements("x" + infix + "_Contact");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgecontact->Contact->caption(), $judgecontact->Contact->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judgecontact_grid->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgecontact->Notes->caption(), $judgecontact->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judgecontact_grid->Primary->Required) { ?>
			elm = this.getElements("x" + infix + "_Primary[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgecontact->Primary->caption(), $judgecontact->Primary->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fjudgecontactgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "JudgeID", false)) return false;
	if (ew.valueChanged(fobj, infix, "ContactTypeID", false)) return false;
	if (ew.valueChanged(fobj, infix, "Contact", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notes", false)) return false;
	if (ew.valueChanged(fobj, infix, "Primary[]", true)) return false;
	return true;
}

// Form_CustomValidate event
fjudgecontactgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjudgecontactgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjudgecontactgrid.lists["x_JudgeID"] = <?php echo $judgecontact_grid->JudgeID->Lookup->toClientList() ?>;
fjudgecontactgrid.lists["x_JudgeID"].options = <?php echo JsonEncode($judgecontact_grid->JudgeID->lookupOptions()) ?>;
fjudgecontactgrid.lists["x_ContactTypeID"] = <?php echo $judgecontact_grid->ContactTypeID->Lookup->toClientList() ?>;
fjudgecontactgrid.lists["x_ContactTypeID"].options = <?php echo JsonEncode($judgecontact_grid->ContactTypeID->lookupOptions()) ?>;
fjudgecontactgrid.lists["x_Primary[]"] = <?php echo $judgecontact_grid->Primary->Lookup->toClientList() ?>;
fjudgecontactgrid.lists["x_Primary[]"].options = <?php echo JsonEncode($judgecontact_grid->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$judgecontact_grid->renderOtherOptions();
?>
<?php $judgecontact_grid->showPageHeader(); ?>
<?php
$judgecontact_grid->showMessage();
?>
<?php if ($judgecontact_grid->TotalRecs > 0 || $judgecontact->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($judgecontact_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> judgecontact">
<?php if ($judgecontact_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $judgecontact_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fjudgecontactgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_judgecontact" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_judgecontactgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$judgecontact_grid->RowType = ROWTYPE_HEADER;

// Render list options
$judgecontact_grid->renderListOptions();

// Render list options (header, left)
$judgecontact_grid->ListOptions->render("header", "left");
?>
<?php if ($judgecontact->JudgeID->Visible) { // JudgeID ?>
	<?php if ($judgecontact->sortUrl($judgecontact->JudgeID) == "") { ?>
		<th data-name="JudgeID" class="<?php echo $judgecontact->JudgeID->headerCellClass() ?>"><div id="elh_judgecontact_JudgeID" class="judgecontact_JudgeID"><div class="ew-table-header-caption"><?php echo $judgecontact->JudgeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JudgeID" class="<?php echo $judgecontact->JudgeID->headerCellClass() ?>"><div><div id="elh_judgecontact_JudgeID" class="judgecontact_JudgeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judgecontact->JudgeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($judgecontact->JudgeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judgecontact->JudgeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgecontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($judgecontact->sortUrl($judgecontact->ContactTypeID) == "") { ?>
		<th data-name="ContactTypeID" class="<?php echo $judgecontact->ContactTypeID->headerCellClass() ?>"><div id="elh_judgecontact_ContactTypeID" class="judgecontact_ContactTypeID"><div class="ew-table-header-caption"><?php echo $judgecontact->ContactTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactTypeID" class="<?php echo $judgecontact->ContactTypeID->headerCellClass() ?>"><div><div id="elh_judgecontact_ContactTypeID" class="judgecontact_ContactTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judgecontact->ContactTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($judgecontact->ContactTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judgecontact->ContactTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgecontact->Contact->Visible) { // Contact ?>
	<?php if ($judgecontact->sortUrl($judgecontact->Contact) == "") { ?>
		<th data-name="Contact" class="<?php echo $judgecontact->Contact->headerCellClass() ?>"><div id="elh_judgecontact_Contact" class="judgecontact_Contact"><div class="ew-table-header-caption"><?php echo $judgecontact->Contact->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Contact" class="<?php echo $judgecontact->Contact->headerCellClass() ?>"><div><div id="elh_judgecontact_Contact" class="judgecontact_Contact">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judgecontact->Contact->caption() ?></span><span class="ew-table-header-sort"><?php if ($judgecontact->Contact->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judgecontact->Contact->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgecontact->Notes->Visible) { // Notes ?>
	<?php if ($judgecontact->sortUrl($judgecontact->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $judgecontact->Notes->headerCellClass() ?>"><div id="elh_judgecontact_Notes" class="judgecontact_Notes"><div class="ew-table-header-caption"><?php echo $judgecontact->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $judgecontact->Notes->headerCellClass() ?>"><div><div id="elh_judgecontact_Notes" class="judgecontact_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judgecontact->Notes->caption() ?></span><span class="ew-table-header-sort"><?php if ($judgecontact->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judgecontact->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgecontact->Primary->Visible) { // Primary ?>
	<?php if ($judgecontact->sortUrl($judgecontact->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $judgecontact->Primary->headerCellClass() ?>"><div id="elh_judgecontact_Primary" class="judgecontact_Primary"><div class="ew-table-header-caption"><?php echo $judgecontact->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $judgecontact->Primary->headerCellClass() ?>"><div><div id="elh_judgecontact_Primary" class="judgecontact_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judgecontact->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($judgecontact->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judgecontact->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$judgecontact_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$judgecontact_grid->StartRec = 1;
$judgecontact_grid->StopRec = $judgecontact_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $judgecontact_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($judgecontact_grid->FormKeyCountName) && ($judgecontact->isGridAdd() || $judgecontact->isGridEdit() || $judgecontact->isConfirm())) {
		$judgecontact_grid->KeyCount = $CurrentForm->getValue($judgecontact_grid->FormKeyCountName);
		$judgecontact_grid->StopRec = $judgecontact_grid->StartRec + $judgecontact_grid->KeyCount - 1;
	}
}
$judgecontact_grid->RecCnt = $judgecontact_grid->StartRec - 1;
if ($judgecontact_grid->Recordset && !$judgecontact_grid->Recordset->EOF) {
	$judgecontact_grid->Recordset->moveFirst();
	$selectLimit = $judgecontact_grid->UseSelectLimit;
	if (!$selectLimit && $judgecontact_grid->StartRec > 1)
		$judgecontact_grid->Recordset->move($judgecontact_grid->StartRec - 1);
} elseif (!$judgecontact->AllowAddDeleteRow && $judgecontact_grid->StopRec == 0) {
	$judgecontact_grid->StopRec = $judgecontact->GridAddRowCount;
}

// Initialize aggregate
$judgecontact->RowType = ROWTYPE_AGGREGATEINIT;
$judgecontact->resetAttributes();
$judgecontact_grid->renderRow();
if ($judgecontact->isGridAdd())
	$judgecontact_grid->RowIndex = 0;
if ($judgecontact->isGridEdit())
	$judgecontact_grid->RowIndex = 0;
while ($judgecontact_grid->RecCnt < $judgecontact_grid->StopRec) {
	$judgecontact_grid->RecCnt++;
	if ($judgecontact_grid->RecCnt >= $judgecontact_grid->StartRec) {
		$judgecontact_grid->RowCnt++;
		if ($judgecontact->isGridAdd() || $judgecontact->isGridEdit() || $judgecontact->isConfirm()) {
			$judgecontact_grid->RowIndex++;
			$CurrentForm->Index = $judgecontact_grid->RowIndex;
			if ($CurrentForm->hasValue($judgecontact_grid->FormActionName) && $judgecontact_grid->EventCancelled)
				$judgecontact_grid->RowAction = strval($CurrentForm->getValue($judgecontact_grid->FormActionName));
			elseif ($judgecontact->isGridAdd())
				$judgecontact_grid->RowAction = "insert";
			else
				$judgecontact_grid->RowAction = "";
		}

		// Set up key count
		$judgecontact_grid->KeyCount = $judgecontact_grid->RowIndex;

		// Init row class and style
		$judgecontact->resetAttributes();
		$judgecontact->CssClass = "";
		if ($judgecontact->isGridAdd()) {
			if ($judgecontact->CurrentMode == "copy") {
				$judgecontact_grid->loadRowValues($judgecontact_grid->Recordset); // Load row values
				$judgecontact_grid->setRecordKey($judgecontact_grid->RowOldKey, $judgecontact_grid->Recordset); // Set old record key
			} else {
				$judgecontact_grid->loadRowValues(); // Load default values
				$judgecontact_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$judgecontact_grid->loadRowValues($judgecontact_grid->Recordset); // Load row values
		}
		$judgecontact->RowType = ROWTYPE_VIEW; // Render view
		if ($judgecontact->isGridAdd()) // Grid add
			$judgecontact->RowType = ROWTYPE_ADD; // Render add
		if ($judgecontact->isGridAdd() && $judgecontact->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$judgecontact_grid->restoreCurrentRowFormValues($judgecontact_grid->RowIndex); // Restore form values
		if ($judgecontact->isGridEdit()) { // Grid edit
			if ($judgecontact->EventCancelled)
				$judgecontact_grid->restoreCurrentRowFormValues($judgecontact_grid->RowIndex); // Restore form values
			if ($judgecontact_grid->RowAction == "insert")
				$judgecontact->RowType = ROWTYPE_ADD; // Render add
			else
				$judgecontact->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($judgecontact->isGridEdit() && ($judgecontact->RowType == ROWTYPE_EDIT || $judgecontact->RowType == ROWTYPE_ADD) && $judgecontact->EventCancelled) // Update failed
			$judgecontact_grid->restoreCurrentRowFormValues($judgecontact_grid->RowIndex); // Restore form values
		if ($judgecontact->RowType == ROWTYPE_EDIT) // Edit row
			$judgecontact_grid->EditRowCnt++;
		if ($judgecontact->isConfirm()) // Confirm row
			$judgecontact_grid->restoreCurrentRowFormValues($judgecontact_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$judgecontact->RowAttrs = array_merge($judgecontact->RowAttrs, array('data-rowindex'=>$judgecontact_grid->RowCnt, 'id'=>'r' . $judgecontact_grid->RowCnt . '_judgecontact', 'data-rowtype'=>$judgecontact->RowType));

		// Render row
		$judgecontact_grid->renderRow();

		// Render list options
		$judgecontact_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($judgecontact_grid->RowAction <> "delete" && $judgecontact_grid->RowAction <> "insertdelete" && !($judgecontact_grid->RowAction == "insert" && $judgecontact->isConfirm() && $judgecontact_grid->emptyRow())) {
?>
	<tr<?php echo $judgecontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$judgecontact_grid->ListOptions->render("body", "left", $judgecontact_grid->RowCnt);
?>
	<?php if ($judgecontact->JudgeID->Visible) { // JudgeID ?>
		<td data-name="JudgeID"<?php echo $judgecontact->JudgeID->cellAttributes() ?>>
<?php if ($judgecontact->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($judgecontact->JudgeID->getSessionValue() <> "") { ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_JudgeID" class="form-group judgecontact_JudgeID">
<span<?php echo $judgecontact->JudgeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($judgecontact->JudgeID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_JudgeID" class="form-group judgecontact_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="judgecontact" data-field="x_JudgeID" data-value-separator="<?php echo $judgecontact->JudgeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID"<?php echo $judgecontact->JudgeID->editAttributes() ?>>
		<?php echo $judgecontact->JudgeID->selectOptionListHtml("x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID") ?>
	</select>
</div>
<?php echo $judgecontact->JudgeID->Lookup->getParamTag("p_x" . $judgecontact_grid->RowIndex . "_JudgeID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="judgecontact" data-field="x_JudgeID" name="o<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" id="o<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->OldValue) ?>">
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($judgecontact->JudgeID->getSessionValue() <> "") { ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_JudgeID" class="form-group judgecontact_JudgeID">
<span<?php echo $judgecontact->JudgeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($judgecontact->JudgeID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_JudgeID" class="form-group judgecontact_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="judgecontact" data-field="x_JudgeID" data-value-separator="<?php echo $judgecontact->JudgeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID"<?php echo $judgecontact->JudgeID->editAttributes() ?>>
		<?php echo $judgecontact->JudgeID->selectOptionListHtml("x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID") ?>
	</select>
</div>
<?php echo $judgecontact->JudgeID->Lookup->getParamTag("p_x" . $judgecontact_grid->RowIndex . "_JudgeID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_JudgeID" class="judgecontact_JudgeID">
<span<?php echo $judgecontact->JudgeID->viewAttributes() ?>>
<?php echo $judgecontact->JudgeID->getViewValue() ?></span>
</span>
<?php if (!$judgecontact->isConfirm()) { ?>
<input type="hidden" data-table="judgecontact" data-field="x_JudgeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" id="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_JudgeID" name="o<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" id="o<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="judgecontact" data-field="x_JudgeID" name="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" id="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_JudgeID" name="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" id="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="judgecontact" data-field="x_ContactID" name="x<?php echo $judgecontact_grid->RowIndex ?>_ContactID" id="x<?php echo $judgecontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($judgecontact->ContactID->CurrentValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_ContactID" name="o<?php echo $judgecontact_grid->RowIndex ?>_ContactID" id="o<?php echo $judgecontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($judgecontact->ContactID->OldValue) ?>">
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_EDIT || $judgecontact->CurrentMode == "edit") { ?>
<input type="hidden" data-table="judgecontact" data-field="x_ContactID" name="x<?php echo $judgecontact_grid->RowIndex ?>_ContactID" id="x<?php echo $judgecontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($judgecontact->ContactID->CurrentValue) ?>">
<?php } ?>
	<?php if ($judgecontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID"<?php echo $judgecontact->ContactTypeID->cellAttributes() ?>>
<?php if ($judgecontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_ContactTypeID" class="form-group judgecontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="judgecontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $judgecontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID"<?php echo $judgecontact->ContactTypeID->editAttributes() ?>>
		<?php echo $judgecontact->ContactTypeID->selectOptionListHtml("x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $judgecontact->ContactTypeID->Lookup->getParamTag("p_x" . $judgecontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_ContactTypeID" name="o<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($judgecontact->ContactTypeID->OldValue) ?>">
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_ContactTypeID" class="form-group judgecontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="judgecontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $judgecontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID"<?php echo $judgecontact->ContactTypeID->editAttributes() ?>>
		<?php echo $judgecontact->ContactTypeID->selectOptionListHtml("x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $judgecontact->ContactTypeID->Lookup->getParamTag("p_x" . $judgecontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_ContactTypeID" class="judgecontact_ContactTypeID">
<span<?php echo $judgecontact->ContactTypeID->viewAttributes() ?>>
<?php echo $judgecontact->ContactTypeID->getViewValue() ?></span>
</span>
<?php if (!$judgecontact->isConfirm()) { ?>
<input type="hidden" data-table="judgecontact" data-field="x_ContactTypeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" id="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($judgecontact->ContactTypeID->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_ContactTypeID" name="o<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($judgecontact->ContactTypeID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="judgecontact" data-field="x_ContactTypeID" name="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" id="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($judgecontact->ContactTypeID->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_ContactTypeID" name="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" id="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($judgecontact->ContactTypeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($judgecontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact"<?php echo $judgecontact->Contact->cellAttributes() ?>>
<?php if ($judgecontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Contact" class="form-group judgecontact_Contact">
<input type="text" data-table="judgecontact" data-field="x_Contact" name="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judgecontact->Contact->getPlaceHolder()) ?>" value="<?php echo $judgecontact->Contact->EditValue ?>"<?php echo $judgecontact->Contact->editAttributes() ?>>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_Contact" name="o<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="o<?php echo $judgecontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($judgecontact->Contact->OldValue) ?>">
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Contact" class="form-group judgecontact_Contact">
<input type="text" data-table="judgecontact" data-field="x_Contact" name="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judgecontact->Contact->getPlaceHolder()) ?>" value="<?php echo $judgecontact->Contact->EditValue ?>"<?php echo $judgecontact->Contact->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Contact" class="judgecontact_Contact">
<span<?php echo $judgecontact->Contact->viewAttributes() ?>>
<?php echo $judgecontact->Contact->getViewValue() ?></span>
</span>
<?php if (!$judgecontact->isConfirm()) { ?>
<input type="hidden" data-table="judgecontact" data-field="x_Contact" name="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($judgecontact->Contact->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_Contact" name="o<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="o<?php echo $judgecontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($judgecontact->Contact->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="judgecontact" data-field="x_Contact" name="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($judgecontact->Contact->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_Contact" name="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($judgecontact->Contact->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($judgecontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $judgecontact->Notes->cellAttributes() ?>>
<?php if ($judgecontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Notes" class="form-group judgecontact_Notes">
<input type="text" data-table="judgecontact" data-field="x_Notes" name="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($judgecontact->Notes->getPlaceHolder()) ?>" value="<?php echo $judgecontact->Notes->EditValue ?>"<?php echo $judgecontact->Notes->editAttributes() ?>>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_Notes" name="o<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="o<?php echo $judgecontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($judgecontact->Notes->OldValue) ?>">
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Notes" class="form-group judgecontact_Notes">
<input type="text" data-table="judgecontact" data-field="x_Notes" name="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($judgecontact->Notes->getPlaceHolder()) ?>" value="<?php echo $judgecontact->Notes->EditValue ?>"<?php echo $judgecontact->Notes->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Notes" class="judgecontact_Notes">
<span<?php echo $judgecontact->Notes->viewAttributes() ?>>
<?php echo $judgecontact->Notes->getViewValue() ?></span>
</span>
<?php if (!$judgecontact->isConfirm()) { ?>
<input type="hidden" data-table="judgecontact" data-field="x_Notes" name="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($judgecontact->Notes->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_Notes" name="o<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="o<?php echo $judgecontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($judgecontact->Notes->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="judgecontact" data-field="x_Notes" name="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($judgecontact->Notes->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_Notes" name="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($judgecontact->Notes->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($judgecontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $judgecontact->Primary->cellAttributes() ?>>
<?php if ($judgecontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Primary" class="form-group judgecontact_Primary">
<?php
$selwrk = (ConvertToBool($judgecontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="judgecontact" data-field="x_Primary" name="x<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $judgecontact->Primary->editAttributes() ?>>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_Primary" name="o<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($judgecontact->Primary->OldValue) ?>">
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Primary" class="form-group judgecontact_Primary">
<?php
$selwrk = (ConvertToBool($judgecontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="judgecontact" data-field="x_Primary" name="x<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $judgecontact->Primary->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($judgecontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $judgecontact_grid->RowCnt ?>_judgecontact_Primary" class="judgecontact_Primary">
<span<?php echo $judgecontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($judgecontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $judgecontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $judgecontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
<?php if (!$judgecontact->isConfirm()) { ?>
<input type="hidden" data-table="judgecontact" data-field="x_Primary" name="x<?php echo $judgecontact_grid->RowIndex ?>_Primary" id="x<?php echo $judgecontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($judgecontact->Primary->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_Primary" name="o<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($judgecontact->Primary->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="judgecontact" data-field="x_Primary" name="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_Primary" id="fjudgecontactgrid$x<?php echo $judgecontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($judgecontact->Primary->FormValue) ?>">
<input type="hidden" data-table="judgecontact" data-field="x_Primary" name="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" id="fjudgecontactgrid$o<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($judgecontact->Primary->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$judgecontact_grid->ListOptions->render("body", "right", $judgecontact_grid->RowCnt);
?>
	</tr>
<?php if ($judgecontact->RowType == ROWTYPE_ADD || $judgecontact->RowType == ROWTYPE_EDIT) { ?>
<script>
fjudgecontactgrid.updateLists(<?php echo $judgecontact_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$judgecontact->isGridAdd() || $judgecontact->CurrentMode == "copy")
		if (!$judgecontact_grid->Recordset->EOF)
			$judgecontact_grid->Recordset->moveNext();
}
?>
<?php
	if ($judgecontact->CurrentMode == "add" || $judgecontact->CurrentMode == "copy" || $judgecontact->CurrentMode == "edit") {
		$judgecontact_grid->RowIndex = '$rowindex$';
		$judgecontact_grid->loadRowValues();

		// Set row properties
		$judgecontact->resetAttributes();
		$judgecontact->RowAttrs = array_merge($judgecontact->RowAttrs, array('data-rowindex'=>$judgecontact_grid->RowIndex, 'id'=>'r0_judgecontact', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($judgecontact->RowAttrs["class"], "ew-template");
		$judgecontact->RowType = ROWTYPE_ADD;

		// Render row
		$judgecontact_grid->renderRow();

		// Render list options
		$judgecontact_grid->renderListOptions();
		$judgecontact_grid->StartRowCnt = 0;
?>
	<tr<?php echo $judgecontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$judgecontact_grid->ListOptions->render("body", "left", $judgecontact_grid->RowIndex);
?>
	<?php if ($judgecontact->JudgeID->Visible) { // JudgeID ?>
		<td data-name="JudgeID">
<?php if (!$judgecontact->isConfirm()) { ?>
<?php if ($judgecontact->JudgeID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_judgecontact_JudgeID" class="form-group judgecontact_JudgeID">
<span<?php echo $judgecontact->JudgeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($judgecontact->JudgeID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_judgecontact_JudgeID" class="form-group judgecontact_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="judgecontact" data-field="x_JudgeID" data-value-separator="<?php echo $judgecontact->JudgeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID"<?php echo $judgecontact->JudgeID->editAttributes() ?>>
		<?php echo $judgecontact->JudgeID->selectOptionListHtml("x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID") ?>
	</select>
</div>
<?php echo $judgecontact->JudgeID->Lookup->getParamTag("p_x" . $judgecontact_grid->RowIndex . "_JudgeID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_judgecontact_JudgeID" class="form-group judgecontact_JudgeID">
<span<?php echo $judgecontact->JudgeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($judgecontact->JudgeID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_JudgeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" id="x<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="judgecontact" data-field="x_JudgeID" name="o<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" id="o<?php echo $judgecontact_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($judgecontact->JudgeID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($judgecontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID">
<?php if (!$judgecontact->isConfirm()) { ?>
<span id="el$rowindex$_judgecontact_ContactTypeID" class="form-group judgecontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="judgecontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $judgecontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID"<?php echo $judgecontact->ContactTypeID->editAttributes() ?>>
		<?php echo $judgecontact->ContactTypeID->selectOptionListHtml("x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $judgecontact->ContactTypeID->Lookup->getParamTag("p_x" . $judgecontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_judgecontact_ContactTypeID" class="form-group judgecontact_ContactTypeID">
<span<?php echo $judgecontact->ContactTypeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($judgecontact->ContactTypeID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_ContactTypeID" name="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" id="x<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($judgecontact->ContactTypeID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="judgecontact" data-field="x_ContactTypeID" name="o<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $judgecontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($judgecontact->ContactTypeID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($judgecontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact">
<?php if (!$judgecontact->isConfirm()) { ?>
<span id="el$rowindex$_judgecontact_Contact" class="form-group judgecontact_Contact">
<input type="text" data-table="judgecontact" data-field="x_Contact" name="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judgecontact->Contact->getPlaceHolder()) ?>" value="<?php echo $judgecontact->Contact->EditValue ?>"<?php echo $judgecontact->Contact->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_judgecontact_Contact" class="form-group judgecontact_Contact">
<span<?php echo $judgecontact->Contact->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($judgecontact->Contact->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_Contact" name="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="x<?php echo $judgecontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($judgecontact->Contact->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="judgecontact" data-field="x_Contact" name="o<?php echo $judgecontact_grid->RowIndex ?>_Contact" id="o<?php echo $judgecontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($judgecontact->Contact->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($judgecontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes">
<?php if (!$judgecontact->isConfirm()) { ?>
<span id="el$rowindex$_judgecontact_Notes" class="form-group judgecontact_Notes">
<input type="text" data-table="judgecontact" data-field="x_Notes" name="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($judgecontact->Notes->getPlaceHolder()) ?>" value="<?php echo $judgecontact->Notes->EditValue ?>"<?php echo $judgecontact->Notes->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_judgecontact_Notes" class="form-group judgecontact_Notes">
<span<?php echo $judgecontact->Notes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($judgecontact->Notes->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_Notes" name="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="x<?php echo $judgecontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($judgecontact->Notes->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="judgecontact" data-field="x_Notes" name="o<?php echo $judgecontact_grid->RowIndex ?>_Notes" id="o<?php echo $judgecontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($judgecontact->Notes->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($judgecontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary">
<?php if (!$judgecontact->isConfirm()) { ?>
<span id="el$rowindex$_judgecontact_Primary" class="form-group judgecontact_Primary">
<?php
$selwrk = (ConvertToBool($judgecontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="judgecontact" data-field="x_Primary" name="x<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $judgecontact->Primary->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_judgecontact_Primary" class="form-group judgecontact_Primary">
<span<?php echo $judgecontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($judgecontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $judgecontact->Primary->ViewValue ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $judgecontact->Primary->ViewValue ?>" disabled>
<?php } ?>
</span>
</span>
<input type="hidden" data-table="judgecontact" data-field="x_Primary" name="x<?php echo $judgecontact_grid->RowIndex ?>_Primary" id="x<?php echo $judgecontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($judgecontact->Primary->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="judgecontact" data-field="x_Primary" name="o<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $judgecontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($judgecontact->Primary->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$judgecontact_grid->ListOptions->render("body", "right", $judgecontact_grid->RowIndex);
?>
<script>
fjudgecontactgrid.updateLists(<?php echo $judgecontact_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($judgecontact->CurrentMode == "add" || $judgecontact->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $judgecontact_grid->FormKeyCountName ?>" id="<?php echo $judgecontact_grid->FormKeyCountName ?>" value="<?php echo $judgecontact_grid->KeyCount ?>">
<?php echo $judgecontact_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($judgecontact->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $judgecontact_grid->FormKeyCountName ?>" id="<?php echo $judgecontact_grid->FormKeyCountName ?>" value="<?php echo $judgecontact_grid->KeyCount ?>">
<?php echo $judgecontact_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($judgecontact->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fjudgecontactgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($judgecontact_grid->Recordset)
	$judgecontact_grid->Recordset->Close();
?>
</div>
<?php if ($judgecontact_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $judgecontact_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($judgecontact_grid->TotalRecs == 0 && !$judgecontact->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $judgecontact_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$judgecontact_grid->terminate();
?>
<?php if (!$judgecontact->isExport()) { ?>
<script>
ew.scrollableTable("gmp_judgecontact", "", "");
</script>
<?php } ?>
