<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$judgecontact_view = new judgecontact_view();

// Run the page
$judgecontact_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judgecontact_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$judgecontact->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fjudgecontactview = currentForm = new ew.Form("fjudgecontactview", "view");

// Form_CustomValidate event
fjudgecontactview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjudgecontactview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjudgecontactview.lists["x_JudgeID"] = <?php echo $judgecontact_view->JudgeID->Lookup->toClientList() ?>;
fjudgecontactview.lists["x_JudgeID"].options = <?php echo JsonEncode($judgecontact_view->JudgeID->lookupOptions()) ?>;
fjudgecontactview.lists["x_ContactTypeID"] = <?php echo $judgecontact_view->ContactTypeID->Lookup->toClientList() ?>;
fjudgecontactview.lists["x_ContactTypeID"].options = <?php echo JsonEncode($judgecontact_view->ContactTypeID->lookupOptions()) ?>;
fjudgecontactview.lists["x_Primary[]"] = <?php echo $judgecontact_view->Primary->Lookup->toClientList() ?>;
fjudgecontactview.lists["x_Primary[]"].options = <?php echo JsonEncode($judgecontact_view->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$judgecontact->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $judgecontact_view->ExportOptions->render("body") ?>
<?php $judgecontact_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $judgecontact_view->showPageHeader(); ?>
<?php
$judgecontact_view->showMessage();
?>
<?php if (!$judgecontact_view->IsModal) { ?>
<?php if (!$judgecontact->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($judgecontact_view->Pager)) $judgecontact_view->Pager = new PrevNextPager($judgecontact_view->StartRec, $judgecontact_view->DisplayRecs, $judgecontact_view->TotalRecs, $judgecontact_view->AutoHidePager) ?>
<?php if ($judgecontact_view->Pager->RecordCount > 0 && $judgecontact_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($judgecontact_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $judgecontact_view->pageUrl() ?>start=<?php echo $judgecontact_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($judgecontact_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $judgecontact_view->pageUrl() ?>start=<?php echo $judgecontact_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $judgecontact_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($judgecontact_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $judgecontact_view->pageUrl() ?>start=<?php echo $judgecontact_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($judgecontact_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $judgecontact_view->pageUrl() ?>start=<?php echo $judgecontact_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $judgecontact_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fjudgecontactview" id="fjudgecontactview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($judgecontact_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $judgecontact_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="judgecontact">
<input type="hidden" name="modal" value="<?php echo (int)$judgecontact_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($judgecontact->JudgeID->Visible) { // JudgeID ?>
	<tr id="r_JudgeID">
		<td class="<?php echo $judgecontact_view->TableLeftColumnClass ?>"><span id="elh_judgecontact_JudgeID"><?php echo $judgecontact->JudgeID->caption() ?></span></td>
		<td data-name="JudgeID"<?php echo $judgecontact->JudgeID->cellAttributes() ?>>
<span id="el_judgecontact_JudgeID">
<span<?php echo $judgecontact->JudgeID->viewAttributes() ?>>
<?php echo $judgecontact->JudgeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judgecontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<tr id="r_ContactTypeID">
		<td class="<?php echo $judgecontact_view->TableLeftColumnClass ?>"><span id="elh_judgecontact_ContactTypeID"><?php echo $judgecontact->ContactTypeID->caption() ?></span></td>
		<td data-name="ContactTypeID"<?php echo $judgecontact->ContactTypeID->cellAttributes() ?>>
<span id="el_judgecontact_ContactTypeID">
<span<?php echo $judgecontact->ContactTypeID->viewAttributes() ?>>
<?php echo $judgecontact->ContactTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judgecontact->Contact->Visible) { // Contact ?>
	<tr id="r_Contact">
		<td class="<?php echo $judgecontact_view->TableLeftColumnClass ?>"><span id="elh_judgecontact_Contact"><?php echo $judgecontact->Contact->caption() ?></span></td>
		<td data-name="Contact"<?php echo $judgecontact->Contact->cellAttributes() ?>>
<span id="el_judgecontact_Contact">
<span<?php echo $judgecontact->Contact->viewAttributes() ?>>
<?php echo $judgecontact->Contact->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judgecontact->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $judgecontact_view->TableLeftColumnClass ?>"><span id="elh_judgecontact_Notes"><?php echo $judgecontact->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $judgecontact->Notes->cellAttributes() ?>>
<span id="el_judgecontact_Notes">
<span<?php echo $judgecontact->Notes->viewAttributes() ?>>
<?php echo $judgecontact->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judgecontact->Primary->Visible) { // Primary ?>
	<tr id="r_Primary">
		<td class="<?php echo $judgecontact_view->TableLeftColumnClass ?>"><span id="elh_judgecontact_Primary"><?php echo $judgecontact->Primary->caption() ?></span></td>
		<td data-name="Primary"<?php echo $judgecontact->Primary->cellAttributes() ?>>
<span id="el_judgecontact_Primary">
<span<?php echo $judgecontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($judgecontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $judgecontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $judgecontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$judgecontact_view->IsModal) { ?>
<?php if (!$judgecontact->isExport()) { ?>
<?php if (!isset($judgecontact_view->Pager)) $judgecontact_view->Pager = new PrevNextPager($judgecontact_view->StartRec, $judgecontact_view->DisplayRecs, $judgecontact_view->TotalRecs, $judgecontact_view->AutoHidePager) ?>
<?php if ($judgecontact_view->Pager->RecordCount > 0 && $judgecontact_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($judgecontact_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $judgecontact_view->pageUrl() ?>start=<?php echo $judgecontact_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($judgecontact_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $judgecontact_view->pageUrl() ?>start=<?php echo $judgecontact_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $judgecontact_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($judgecontact_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $judgecontact_view->pageUrl() ?>start=<?php echo $judgecontact_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($judgecontact_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $judgecontact_view->pageUrl() ?>start=<?php echo $judgecontact_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $judgecontact_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$judgecontact_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$judgecontact->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$judgecontact_view->terminate();
?>
