<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$judges_addopt = new judges_addopt();

// Run the page
$judges_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judges_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fjudgesaddopt = currentForm = new ew.Form("fjudgesaddopt", "addopt");

// Validate form
fjudgesaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($judges_addopt->CourtID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judges->CourtID->caption(), $judges->CourtID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judges_addopt->TitleID->Required) { ?>
			elm = this.getElements("x" + infix + "_TitleID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judges->TitleID->caption(), $judges->TitleID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judges_addopt->FirstName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirstName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judges->FirstName->caption(), $judges->FirstName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judges_addopt->MiddleName->Required) { ?>
			elm = this.getElements("x" + infix + "_MiddleName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judges->MiddleName->caption(), $judges->MiddleName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judges_addopt->LastName->Required) { ?>
			elm = this.getElements("x" + infix + "_LastName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judges->LastName->caption(), $judges->LastName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judges_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judges->Notes->caption(), $judges->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fjudgesaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjudgesaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjudgesaddopt.lists["x_CourtID"] = <?php echo $judges_addopt->CourtID->Lookup->toClientList() ?>;
fjudgesaddopt.lists["x_CourtID"].options = <?php echo JsonEncode($judges_addopt->CourtID->lookupOptions()) ?>;
fjudgesaddopt.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjudgesaddopt.lists["x_TitleID"] = <?php echo $judges_addopt->TitleID->Lookup->toClientList() ?>;
fjudgesaddopt.lists["x_TitleID"].options = <?php echo JsonEncode($judges_addopt->TitleID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $judges_addopt->showPageHeader(); ?>
<?php
$judges_addopt->showMessage();
?>
<form name="fjudgesaddopt" id="fjudgesaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($judges_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $judges_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $judges_addopt->TableVar ?>">
<?php if ($judges->CourtID->Visible) { // CourtID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $judges->CourtID->caption() ?><?php echo ($judges->CourtID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$judges->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$judges->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($judges->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($judges->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($judges->CourtID->getPlaceHolder()) ?>"<?php echo $judges->CourtID->editAttributes() ?>>
	</div>
</span>
<input type="hidden" data-table="judges" data-field="x_CourtID" data-value-separator="<?php echo $judges->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($judges->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjudgesaddopt.createAutoSuggest({"id":"x_CourtID","forceSelect":true});
</script>
<?php echo $judges->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</div>
	</div>
<?php } ?>
<?php if ($judges->TitleID->Visible) { // TitleID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_TitleID"><?php echo $judges->TitleID->caption() ?><?php echo ($judges->TitleID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="judges" data-field="x_TitleID" data-value-separator="<?php echo $judges->TitleID->displayValueSeparatorAttribute() ?>" id="x_TitleID" name="x_TitleID"<?php echo $judges->TitleID->editAttributes() ?>>
		<?php echo $judges->TitleID->selectOptionListHtml("x_TitleID") ?>
	</select>
</div>
<?php echo $judges->TitleID->Lookup->getParamTag("p_x_TitleID") ?>
</div>
	</div>
<?php } ?>
<?php if ($judges->FirstName->Visible) { // FirstName ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_FirstName"><?php echo $judges->FirstName->caption() ?><?php echo ($judges->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="judges" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judges->FirstName->getPlaceHolder()) ?>" value="<?php echo $judges->FirstName->EditValue ?>"<?php echo $judges->FirstName->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($judges->MiddleName->Visible) { // MiddleName ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_MiddleName"><?php echo $judges->MiddleName->caption() ?><?php echo ($judges->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="judges" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($judges->MiddleName->getPlaceHolder()) ?>" value="<?php echo $judges->MiddleName->EditValue ?>"<?php echo $judges->MiddleName->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($judges->LastName->Visible) { // LastName ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_LastName"><?php echo $judges->LastName->caption() ?><?php echo ($judges->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="judges" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judges->LastName->getPlaceHolder()) ?>" value="<?php echo $judges->LastName->EditValue ?>"<?php echo $judges->LastName->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($judges->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $judges->Notes->caption() ?><?php echo ($judges->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="judges" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($judges->Notes->getPlaceHolder()) ?>"<?php echo $judges->Notes->editAttributes() ?>><?php echo $judges->Notes->EditValue ?></textarea>
</div>
	</div>
<?php } ?>
</form>
<?php
$judges_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$judges_addopt->terminate();
?>
