<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$judgetype_addopt = new judgetype_addopt();

// Run the page
$judgetype_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judgetype_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fjudgetypeaddopt = currentForm = new ew.Form("fjudgetypeaddopt", "addopt");

// Validate form
fjudgetypeaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($judgetype_addopt->JudgeType->Required) { ?>
			elm = this.getElements("x" + infix + "_JudgeType");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgetype->JudgeType->caption(), $judgetype->JudgeType->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judgetype_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgetype->Notes->caption(), $judgetype->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fjudgetypeaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjudgetypeaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $judgetype_addopt->showPageHeader(); ?>
<?php
$judgetype_addopt->showMessage();
?>
<form name="fjudgetypeaddopt" id="fjudgetypeaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($judgetype_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $judgetype_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $judgetype_addopt->TableVar ?>">
<?php if ($judgetype->JudgeType->Visible) { // JudgeType ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_JudgeType"><?php echo $judgetype->JudgeType->caption() ?><?php echo ($judgetype->JudgeType->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="judgetype" data-field="x_JudgeType" name="x_JudgeType" id="x_JudgeType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judgetype->JudgeType->getPlaceHolder()) ?>" value="<?php echo $judgetype->JudgeType->EditValue ?>"<?php echo $judgetype->JudgeType->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($judgetype->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $judgetype->Notes->caption() ?><?php echo ($judgetype->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="judgetype" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($judgetype->Notes->getPlaceHolder()) ?>" value="<?php echo $judgetype->Notes->EditValue ?>"<?php echo $judgetype->Notes->editAttributes() ?>>
</div>
	</div>
<?php } ?>
</form>
<?php
$judgetype_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$judgetype_addopt->terminate();
?>
