<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$judgetype_list = new judgetype_list();

// Run the page
$judgetype_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judgetype_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$judgetype->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjudgetypelist = currentForm = new ew.Form("fjudgetypelist", "list");
fjudgetypelist.formKeyCountName = '<?php echo $judgetype_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjudgetypelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjudgetypelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fjudgetypelistsrch = currentSearchForm = new ew.Form("fjudgetypelistsrch");

// Filters
fjudgetypelistsrch.filterList = <?php echo $judgetype_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$judgetype->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($judgetype_list->TotalRecs > 0 && $judgetype_list->ExportOptions->visible()) { ?>
<?php $judgetype_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($judgetype_list->ImportOptions->visible()) { ?>
<?php $judgetype_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($judgetype_list->SearchOptions->visible()) { ?>
<?php $judgetype_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($judgetype_list->FilterOptions->visible()) { ?>
<?php $judgetype_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$judgetype_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$judgetype->isExport() && !$judgetype->CurrentAction) { ?>
<form name="fjudgetypelistsrch" id="fjudgetypelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($judgetype_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fjudgetypelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="judgetype">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($judgetype_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($judgetype_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $judgetype_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($judgetype_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($judgetype_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($judgetype_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($judgetype_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $judgetype_list->showPageHeader(); ?>
<?php
$judgetype_list->showMessage();
?>
<?php if ($judgetype_list->TotalRecs > 0 || $judgetype->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($judgetype_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> judgetype">
<?php if (!$judgetype->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$judgetype->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($judgetype_list->Pager)) $judgetype_list->Pager = new PrevNextPager($judgetype_list->StartRec, $judgetype_list->DisplayRecs, $judgetype_list->TotalRecs, $judgetype_list->AutoHidePager) ?>
<?php if ($judgetype_list->Pager->RecordCount > 0 && $judgetype_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($judgetype_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $judgetype_list->pageUrl() ?>start=<?php echo $judgetype_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($judgetype_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $judgetype_list->pageUrl() ?>start=<?php echo $judgetype_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $judgetype_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($judgetype_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $judgetype_list->pageUrl() ?>start=<?php echo $judgetype_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($judgetype_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $judgetype_list->pageUrl() ?>start=<?php echo $judgetype_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $judgetype_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($judgetype_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $judgetype_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $judgetype_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $judgetype_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($judgetype_list->TotalRecs > 0 && (!$judgetype_list->AutoHidePageSizeSelector || $judgetype_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="judgetype">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($judgetype_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($judgetype_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($judgetype_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($judgetype_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($judgetype_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($judgetype_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($judgetype_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($judgetype_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($judgetype_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($judgetype->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $judgetype_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjudgetypelist" id="fjudgetypelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($judgetype_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $judgetype_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="judgetype">
<div id="gmp_judgetype" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($judgetype_list->TotalRecs > 0 || $judgetype->isGridEdit()) { ?>
<table id="tbl_judgetypelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$judgetype_list->RowType = ROWTYPE_HEADER;

// Render list options
$judgetype_list->renderListOptions();

// Render list options (header, left)
$judgetype_list->ListOptions->render("header", "left");
?>
<?php if ($judgetype->JudgeType->Visible) { // JudgeType ?>
	<?php if ($judgetype->sortUrl($judgetype->JudgeType) == "") { ?>
		<th data-name="JudgeType" class="<?php echo $judgetype->JudgeType->headerCellClass() ?>"><div id="elh_judgetype_JudgeType" class="judgetype_JudgeType"><div class="ew-table-header-caption"><?php echo $judgetype->JudgeType->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JudgeType" class="<?php echo $judgetype->JudgeType->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $judgetype->SortUrl($judgetype->JudgeType) ?>',2);"><div id="elh_judgetype_JudgeType" class="judgetype_JudgeType">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judgetype->JudgeType->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($judgetype->JudgeType->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judgetype->JudgeType->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgetype->JudgeTypeEn->Visible) { // JudgeTypeEn ?>
	<?php if ($judgetype->sortUrl($judgetype->JudgeTypeEn) == "") { ?>
		<th data-name="JudgeTypeEn" class="<?php echo $judgetype->JudgeTypeEn->headerCellClass() ?>"><div id="elh_judgetype_JudgeTypeEn" class="judgetype_JudgeTypeEn"><div class="ew-table-header-caption"><?php echo $judgetype->JudgeTypeEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JudgeTypeEn" class="<?php echo $judgetype->JudgeTypeEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $judgetype->SortUrl($judgetype->JudgeTypeEn) ?>',2);"><div id="elh_judgetype_JudgeTypeEn" class="judgetype_JudgeTypeEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judgetype->JudgeTypeEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($judgetype->JudgeTypeEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judgetype->JudgeTypeEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgetype->Notes->Visible) { // Notes ?>
	<?php if ($judgetype->sortUrl($judgetype->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $judgetype->Notes->headerCellClass() ?>"><div id="elh_judgetype_Notes" class="judgetype_Notes"><div class="ew-table-header-caption"><?php echo $judgetype->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $judgetype->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $judgetype->SortUrl($judgetype->Notes) ?>',2);"><div id="elh_judgetype_Notes" class="judgetype_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judgetype->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($judgetype->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judgetype->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$judgetype_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($judgetype->ExportAll && $judgetype->isExport()) {
	$judgetype_list->StopRec = $judgetype_list->TotalRecs;
} else {

	// Set the last record to display
	if ($judgetype_list->TotalRecs > $judgetype_list->StartRec + $judgetype_list->DisplayRecs - 1)
		$judgetype_list->StopRec = $judgetype_list->StartRec + $judgetype_list->DisplayRecs - 1;
	else
		$judgetype_list->StopRec = $judgetype_list->TotalRecs;
}
$judgetype_list->RecCnt = $judgetype_list->StartRec - 1;
if ($judgetype_list->Recordset && !$judgetype_list->Recordset->EOF) {
	$judgetype_list->Recordset->moveFirst();
	$selectLimit = $judgetype_list->UseSelectLimit;
	if (!$selectLimit && $judgetype_list->StartRec > 1)
		$judgetype_list->Recordset->move($judgetype_list->StartRec - 1);
} elseif (!$judgetype->AllowAddDeleteRow && $judgetype_list->StopRec == 0) {
	$judgetype_list->StopRec = $judgetype->GridAddRowCount;
}

// Initialize aggregate
$judgetype->RowType = ROWTYPE_AGGREGATEINIT;
$judgetype->resetAttributes();
$judgetype_list->renderRow();
while ($judgetype_list->RecCnt < $judgetype_list->StopRec) {
	$judgetype_list->RecCnt++;
	if ($judgetype_list->RecCnt >= $judgetype_list->StartRec) {
		$judgetype_list->RowCnt++;

		// Set up key count
		$judgetype_list->KeyCount = $judgetype_list->RowIndex;

		// Init row class and style
		$judgetype->resetAttributes();
		$judgetype->CssClass = "";
		if ($judgetype->isGridAdd()) {
		} else {
			$judgetype_list->loadRowValues($judgetype_list->Recordset); // Load row values
		}
		$judgetype->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$judgetype->RowAttrs = array_merge($judgetype->RowAttrs, array('data-rowindex'=>$judgetype_list->RowCnt, 'id'=>'r' . $judgetype_list->RowCnt . '_judgetype', 'data-rowtype'=>$judgetype->RowType));

		// Render row
		$judgetype_list->renderRow();

		// Render list options
		$judgetype_list->renderListOptions();
?>
	<tr<?php echo $judgetype->rowAttributes() ?>>
<?php

// Render list options (body, left)
$judgetype_list->ListOptions->render("body", "left", $judgetype_list->RowCnt);
?>
	<?php if ($judgetype->JudgeType->Visible) { // JudgeType ?>
		<td data-name="JudgeType"<?php echo $judgetype->JudgeType->cellAttributes() ?>>
<span id="el<?php echo $judgetype_list->RowCnt ?>_judgetype_JudgeType" class="judgetype_JudgeType">
<span<?php echo $judgetype->JudgeType->viewAttributes() ?>>
<?php echo $judgetype->JudgeType->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($judgetype->JudgeTypeEn->Visible) { // JudgeTypeEn ?>
		<td data-name="JudgeTypeEn"<?php echo $judgetype->JudgeTypeEn->cellAttributes() ?>>
<span id="el<?php echo $judgetype_list->RowCnt ?>_judgetype_JudgeTypeEn" class="judgetype_JudgeTypeEn">
<span<?php echo $judgetype->JudgeTypeEn->viewAttributes() ?>>
<?php echo $judgetype->JudgeTypeEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($judgetype->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $judgetype->Notes->cellAttributes() ?>>
<span id="el<?php echo $judgetype_list->RowCnt ?>_judgetype_Notes" class="judgetype_Notes">
<span<?php echo $judgetype->Notes->viewAttributes() ?>>
<?php echo $judgetype->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$judgetype_list->ListOptions->render("body", "right", $judgetype_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$judgetype->isGridAdd())
		$judgetype_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$judgetype->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($judgetype_list->Recordset)
	$judgetype_list->Recordset->Close();
?>
<?php if (!$judgetype->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$judgetype->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($judgetype_list->Pager)) $judgetype_list->Pager = new PrevNextPager($judgetype_list->StartRec, $judgetype_list->DisplayRecs, $judgetype_list->TotalRecs, $judgetype_list->AutoHidePager) ?>
<?php if ($judgetype_list->Pager->RecordCount > 0 && $judgetype_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($judgetype_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $judgetype_list->pageUrl() ?>start=<?php echo $judgetype_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($judgetype_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $judgetype_list->pageUrl() ?>start=<?php echo $judgetype_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $judgetype_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($judgetype_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $judgetype_list->pageUrl() ?>start=<?php echo $judgetype_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($judgetype_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $judgetype_list->pageUrl() ?>start=<?php echo $judgetype_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $judgetype_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($judgetype_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $judgetype_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $judgetype_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $judgetype_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($judgetype_list->TotalRecs > 0 && (!$judgetype_list->AutoHidePageSizeSelector || $judgetype_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="judgetype">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($judgetype_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($judgetype_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($judgetype_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($judgetype_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($judgetype_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($judgetype_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($judgetype_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($judgetype_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($judgetype_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($judgetype->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $judgetype_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($judgetype_list->TotalRecs == 0 && !$judgetype->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $judgetype_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$judgetype_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$judgetype->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$judgetype->isExport()) { ?>
<script>
ew.scrollableTable("gmp_judgetype", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$judgetype_list->terminate();
?>
