<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawyers_search = new lawyers_search();

// Run the page
$lawyers_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyers_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($lawyers_search->IsModal) { ?>
var flawyerssearch = currentAdvancedSearchForm = new ew.Form("flawyerssearch", "search");
<?php } else { ?>
var flawyerssearch = currentForm = new ew.Form("flawyerssearch", "search");
<?php } ?>

// Form_CustomValidate event
flawyerssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyerssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyerssearch.lists["x_LawyerTypeID"] = <?php echo $lawyers_search->LawyerTypeID->Lookup->toClientList() ?>;
flawyerssearch.lists["x_LawyerTypeID"].options = <?php echo JsonEncode($lawyers_search->LawyerTypeID->lookupOptions()) ?>;
flawyerssearch.lists["x_FirmID"] = <?php echo $lawyers_search->FirmID->Lookup->toClientList() ?>;
flawyerssearch.lists["x_FirmID"].options = <?php echo JsonEncode($lawyers_search->FirmID->lookupOptions()) ?>;

// Form object for search
// Validate function for search

flawyerssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $lawyers_search->showPageHeader(); ?>
<?php
$lawyers_search->showMessage();
?>
<form name="flawyerssearch" id="flawyerssearch" class="<?php echo $lawyers_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($lawyers_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawyers_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lawyers">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$lawyers_search->IsModal ?>">
<?php if (!$lawyers_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_lawyerssearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($lawyers->LawyerID->Visible) { // LawyerID ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
	<div id="r_LawyerID" class="form-group row">
		<label class="<?php echo $lawyers_search->LeftColumnClass ?>"><span id="elh_lawyers_LawyerID"><?php echo $lawyers->LawyerID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LawyerID" id="z_LawyerID" value="="></span>
		</label>
		<div class="<?php echo $lawyers_search->RightColumnClass ?>"><div<?php echo $lawyers->LawyerID->cellAttributes() ?>>
			<span id="el_lawyers_LawyerID">
<input type="text" data-table="lawyers" data-field="x_LawyerID" name="x_LawyerID" id="x_LawyerID" placeholder="<?php echo HtmlEncode($lawyers->LawyerID->getPlaceHolder()) ?>" value="<?php echo $lawyers->LawyerID->EditValue ?>"<?php echo $lawyers->LawyerID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawyerID">
		<td class="<?php echo $lawyers_search->TableLeftColumnClass ?>"><span id="elh_lawyers_LawyerID"><?php echo $lawyers->LawyerID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LawyerID" id="z_LawyerID" value="="></span></td>
		<td<?php echo $lawyers->LawyerID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_lawyers_LawyerID">
<input type="text" data-table="lawyers" data-field="x_LawyerID" name="x_LawyerID" id="x_LawyerID" placeholder="<?php echo HtmlEncode($lawyers->LawyerID->getPlaceHolder()) ?>" value="<?php echo $lawyers->LawyerID->EditValue ?>"<?php echo $lawyers->LawyerID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($lawyers->LawyerTypeID->Visible) { // LawyerTypeID ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
	<div id="r_LawyerTypeID" class="form-group row">
		<label for="x_LawyerTypeID" class="<?php echo $lawyers_search->LeftColumnClass ?>"><span id="elh_lawyers_LawyerTypeID"><?php echo $lawyers->LawyerTypeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LawyerTypeID" id="z_LawyerTypeID" value="="></span>
		</label>
		<div class="<?php echo $lawyers_search->RightColumnClass ?>"><div<?php echo $lawyers->LawyerTypeID->cellAttributes() ?>>
			<span id="el_lawyers_LawyerTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyers" data-field="x_LawyerTypeID" data-value-separator="<?php echo $lawyers->LawyerTypeID->displayValueSeparatorAttribute() ?>" id="x_LawyerTypeID" name="x_LawyerTypeID"<?php echo $lawyers->LawyerTypeID->editAttributes() ?>>
		<?php echo $lawyers->LawyerTypeID->selectOptionListHtml("x_LawyerTypeID") ?>
	</select>
</div>
<?php echo $lawyers->LawyerTypeID->Lookup->getParamTag("p_x_LawyerTypeID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawyerTypeID">
		<td class="<?php echo $lawyers_search->TableLeftColumnClass ?>"><span id="elh_lawyers_LawyerTypeID"><?php echo $lawyers->LawyerTypeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LawyerTypeID" id="z_LawyerTypeID" value="="></span></td>
		<td<?php echo $lawyers->LawyerTypeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_lawyers_LawyerTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyers" data-field="x_LawyerTypeID" data-value-separator="<?php echo $lawyers->LawyerTypeID->displayValueSeparatorAttribute() ?>" id="x_LawyerTypeID" name="x_LawyerTypeID"<?php echo $lawyers->LawyerTypeID->editAttributes() ?>>
		<?php echo $lawyers->LawyerTypeID->selectOptionListHtml("x_LawyerTypeID") ?>
	</select>
</div>
<?php echo $lawyers->LawyerTypeID->Lookup->getParamTag("p_x_LawyerTypeID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($lawyers->FirmID->Visible) { // FirmID ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
	<div id="r_FirmID" class="form-group row">
		<label for="x_FirmID" class="<?php echo $lawyers_search->LeftColumnClass ?>"><span id="elh_lawyers_FirmID"><?php echo $lawyers->FirmID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_FirmID" id="z_FirmID" value="="></span>
		</label>
		<div class="<?php echo $lawyers_search->RightColumnClass ?>"><div<?php echo $lawyers->FirmID->cellAttributes() ?>>
			<span id="el_lawyers_FirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyers" data-field="x_FirmID" data-value-separator="<?php echo $lawyers->FirmID->displayValueSeparatorAttribute() ?>" id="x_FirmID" name="x_FirmID"<?php echo $lawyers->FirmID->editAttributes() ?>>
		<?php echo $lawyers->FirmID->selectOptionListHtml("x_FirmID") ?>
	</select>
</div>
<?php echo $lawyers->FirmID->Lookup->getParamTag("p_x_FirmID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirmID">
		<td class="<?php echo $lawyers_search->TableLeftColumnClass ?>"><span id="elh_lawyers_FirmID"><?php echo $lawyers->FirmID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_FirmID" id="z_FirmID" value="="></span></td>
		<td<?php echo $lawyers->FirmID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_lawyers_FirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyers" data-field="x_FirmID" data-value-separator="<?php echo $lawyers->FirmID->displayValueSeparatorAttribute() ?>" id="x_FirmID" name="x_FirmID"<?php echo $lawyers->FirmID->editAttributes() ?>>
		<?php echo $lawyers->FirmID->selectOptionListHtml("x_FirmID") ?>
	</select>
</div>
<?php echo $lawyers->FirmID->Lookup->getParamTag("p_x_FirmID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($lawyers->FirmName->Visible) { // FirmName ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
	<div id="r_FirmName" class="form-group row">
		<label for="x_FirmName" class="<?php echo $lawyers_search->LeftColumnClass ?>"><span id="elh_lawyers_FirmName"><?php echo $lawyers->FirmName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FirmName" id="z_FirmName" value="LIKE"></span>
		</label>
		<div class="<?php echo $lawyers_search->RightColumnClass ?>"><div<?php echo $lawyers->FirmName->cellAttributes() ?>>
			<span id="el_lawyers_FirmName">
<input type="text" data-table="lawyers" data-field="x_FirmName" name="x_FirmName" id="x_FirmName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->FirmName->getPlaceHolder()) ?>" value="<?php echo $lawyers->FirmName->EditValue ?>"<?php echo $lawyers->FirmName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirmName">
		<td class="<?php echo $lawyers_search->TableLeftColumnClass ?>"><span id="elh_lawyers_FirmName"><?php echo $lawyers->FirmName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FirmName" id="z_FirmName" value="LIKE"></span></td>
		<td<?php echo $lawyers->FirmName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_lawyers_FirmName">
<input type="text" data-table="lawyers" data-field="x_FirmName" name="x_FirmName" id="x_FirmName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->FirmName->getPlaceHolder()) ?>" value="<?php echo $lawyers->FirmName->EditValue ?>"<?php echo $lawyers->FirmName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($lawyers->FirstName->Visible) { // FirstName ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
	<div id="r_FirstName" class="form-group row">
		<label for="x_FirstName" class="<?php echo $lawyers_search->LeftColumnClass ?>"><span id="elh_lawyers_FirstName"><?php echo $lawyers->FirstName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FirstName" id="z_FirstName" value="LIKE"></span>
		</label>
		<div class="<?php echo $lawyers_search->RightColumnClass ?>"><div<?php echo $lawyers->FirstName->cellAttributes() ?>>
			<span id="el_lawyers_FirstName">
<input type="text" data-table="lawyers" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->FirstName->getPlaceHolder()) ?>" value="<?php echo $lawyers->FirstName->EditValue ?>"<?php echo $lawyers->FirstName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $lawyers_search->TableLeftColumnClass ?>"><span id="elh_lawyers_FirstName"><?php echo $lawyers->FirstName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FirstName" id="z_FirstName" value="LIKE"></span></td>
		<td<?php echo $lawyers->FirstName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_lawyers_FirstName">
<input type="text" data-table="lawyers" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->FirstName->getPlaceHolder()) ?>" value="<?php echo $lawyers->FirstName->EditValue ?>"<?php echo $lawyers->FirstName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($lawyers->MiddleName->Visible) { // MiddleName ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
	<div id="r_MiddleName" class="form-group row">
		<label for="x_MiddleName" class="<?php echo $lawyers_search->LeftColumnClass ?>"><span id="elh_lawyers_MiddleName"><?php echo $lawyers->MiddleName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_MiddleName" id="z_MiddleName" value="LIKE"></span>
		</label>
		<div class="<?php echo $lawyers_search->RightColumnClass ?>"><div<?php echo $lawyers->MiddleName->cellAttributes() ?>>
			<span id="el_lawyers_MiddleName">
<input type="text" data-table="lawyers" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyers->MiddleName->getPlaceHolder()) ?>" value="<?php echo $lawyers->MiddleName->EditValue ?>"<?php echo $lawyers->MiddleName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $lawyers_search->TableLeftColumnClass ?>"><span id="elh_lawyers_MiddleName"><?php echo $lawyers->MiddleName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_MiddleName" id="z_MiddleName" value="LIKE"></span></td>
		<td<?php echo $lawyers->MiddleName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_lawyers_MiddleName">
<input type="text" data-table="lawyers" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyers->MiddleName->getPlaceHolder()) ?>" value="<?php echo $lawyers->MiddleName->EditValue ?>"<?php echo $lawyers->MiddleName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($lawyers->LastName->Visible) { // LastName ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
	<div id="r_LastName" class="form-group row">
		<label for="x_LastName" class="<?php echo $lawyers_search->LeftColumnClass ?>"><span id="elh_lawyers_LastName"><?php echo $lawyers->LastName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_LastName" id="z_LastName" value="LIKE"></span>
		</label>
		<div class="<?php echo $lawyers_search->RightColumnClass ?>"><div<?php echo $lawyers->LastName->cellAttributes() ?>>
			<span id="el_lawyers_LastName">
<input type="text" data-table="lawyers" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->LastName->getPlaceHolder()) ?>" value="<?php echo $lawyers->LastName->EditValue ?>"<?php echo $lawyers->LastName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $lawyers_search->TableLeftColumnClass ?>"><span id="elh_lawyers_LastName"><?php echo $lawyers->LastName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_LastName" id="z_LastName" value="LIKE"></span></td>
		<td<?php echo $lawyers->LastName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_lawyers_LastName">
<input type="text" data-table="lawyers" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->LastName->getPlaceHolder()) ?>" value="<?php echo $lawyers->LastName->EditValue ?>"<?php echo $lawyers->LastName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($lawyers_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$lawyers_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $lawyers_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$lawyers_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$lawyers_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$lawyers_search->terminate();
?>
