<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawyertype_addopt = new lawyertype_addopt();

// Run the page
$lawyertype_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyertype_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var flawyertypeaddopt = currentForm = new ew.Form("flawyertypeaddopt", "addopt");

// Validate form
flawyertypeaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($lawyertype_addopt->LawyerType->Required) { ?>
			elm = this.getElements("x" + infix + "_LawyerType");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyertype->LawyerType->caption(), $lawyertype->LawyerType->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyertype_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyertype->Notes->caption(), $lawyertype->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
flawyertypeaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyertypeaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $lawyertype_addopt->showPageHeader(); ?>
<?php
$lawyertype_addopt->showMessage();
?>
<form name="flawyertypeaddopt" id="flawyertypeaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($lawyertype_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawyertype_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $lawyertype_addopt->TableVar ?>">
<?php if ($lawyertype->LawyerType->Visible) { // LawyerType ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_LawyerType"><?php echo $lawyertype->LawyerType->caption() ?><?php echo ($lawyertype->LawyerType->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="lawyertype" data-field="x_LawyerType" name="x_LawyerType" id="x_LawyerType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyertype->LawyerType->getPlaceHolder()) ?>" value="<?php echo $lawyertype->LawyerType->EditValue ?>"<?php echo $lawyertype->LawyerType->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($lawyertype->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $lawyertype->Notes->caption() ?><?php echo ($lawyertype->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="lawyertype" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lawyertype->Notes->getPlaceHolder()) ?>" value="<?php echo $lawyertype->Notes->EditValue ?>"<?php echo $lawyertype->Notes->editAttributes() ?>>
</div>
	</div>
<?php } ?>
</form>
<?php
$lawyertype_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$lawyertype_addopt->terminate();
?>
