<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$notices_edit = new notices_edit();

// Run the page
$notices_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notices_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fnoticesedit = currentForm = new ew.Form("fnoticesedit", "edit");

// Validate form
fnoticesedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($notices_edit->NoticeID->Required) { ?>
			elm = this.getElements("x" + infix + "_NoticeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->NoticeID->caption(), $notices->NoticeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notices_edit->CaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->CaseID->caption(), $notices->CaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notices_edit->Notice->Required) { ?>
			elm = this.getElements("x" + infix + "_Notice");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->Notice->caption(), $notices->Notice->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notices_edit->NoticeDate->Required) { ?>
			elm = this.getElements("x" + infix + "_NoticeDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->NoticeDate->caption(), $notices->NoticeDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NoticeDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($notices->NoticeDate->errorMessage()) ?>");
		<?php if ($notices_edit->NoticeTime->Required) { ?>
			elm = this.getElements("x" + infix + "_NoticeTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->NoticeTime->caption(), $notices->NoticeTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NoticeTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($notices->NoticeTime->errorMessage()) ?>");
		<?php if ($notices_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->Notes->caption(), $notices->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notices_edit->PostMan->Required) { ?>
			elm = this.getElements("x" + infix + "_PostMan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->PostMan->caption(), $notices->PostMan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notices_edit->LawyerID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawyerID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->LawyerID->caption(), $notices->LawyerID->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnoticesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnoticesedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnoticesedit.lists["x_CaseID"] = <?php echo $notices_edit->CaseID->Lookup->toClientList() ?>;
fnoticesedit.lists["x_CaseID"].options = <?php echo JsonEncode($notices_edit->CaseID->lookupOptions()) ?>;
fnoticesedit.autoSuggests["x_CaseID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fnoticesedit.lists["x_LawyerID"] = <?php echo $notices_edit->LawyerID->Lookup->toClientList() ?>;
fnoticesedit.lists["x_LawyerID"].options = <?php echo JsonEncode($notices_edit->LawyerID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $notices_edit->showPageHeader(); ?>
<?php
$notices_edit->showMessage();
?>
<?php if (!$notices_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($notices_edit->Pager)) $notices_edit->Pager = new PrevNextPager($notices_edit->StartRec, $notices_edit->DisplayRecs, $notices_edit->TotalRecs, $notices_edit->AutoHidePager) ?>
<?php if ($notices_edit->Pager->RecordCount > 0 && $notices_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($notices_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $notices_edit->pageUrl() ?>start=<?php echo $notices_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($notices_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $notices_edit->pageUrl() ?>start=<?php echo $notices_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $notices_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($notices_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $notices_edit->pageUrl() ?>start=<?php echo $notices_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($notices_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $notices_edit->pageUrl() ?>start=<?php echo $notices_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $notices_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fnoticesedit" id="fnoticesedit" class="<?php echo $notices_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($notices_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $notices_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="notices">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$notices_edit->IsModal ?>">
<?php if ($notices->getCurrentMasterTable() == "cases") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="cases">
<input type="hidden" name="fk_CaseID" value="<?php echo $notices->CaseID->getSessionValue() ?>">
<?php } ?>
<?php if (!$notices_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_noticesedit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($notices->CaseID->Visible) { // CaseID ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
	<div id="r_CaseID" class="form-group row">
		<label id="elh_notices_CaseID" class="<?php echo $notices_edit->LeftColumnClass ?>"><?php echo $notices->CaseID->caption() ?><?php echo ($notices->CaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $notices_edit->RightColumnClass ?>"><div<?php echo $notices->CaseID->cellAttributes() ?>>
<?php if ($notices->CaseID->getSessionValue() <> "") { ?>
<span id="el_notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_CaseID" name="x_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_notices_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$notices->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$notices->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CaseID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CaseID" id="sv_x_CaseID" value="<?php echo RemoveHtml($notices->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>"<?php echo $notices->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($notices->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($notices->CaseID->ReadOnly || $notices->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="notices" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $notices->CaseID->displayValueSeparatorAttribute() ?>" name="x_CaseID" id="x_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fnoticesedit.createAutoSuggest({"id":"x_CaseID","forceSelect":true});
</script>
<?php echo $notices->CaseID->Lookup->getParamTag("p_x_CaseID") ?>
</span>
<?php } ?>
<?php echo $notices->CaseID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseID">
		<td class="<?php echo $notices_edit->TableLeftColumnClass ?>"><span id="elh_notices_CaseID"><?php echo $notices->CaseID->caption() ?><?php echo ($notices->CaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $notices->CaseID->cellAttributes() ?>>
<?php if ($notices->CaseID->getSessionValue() <> "") { ?>
<span id="el_notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_CaseID" name="x_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_notices_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$notices->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$notices->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CaseID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CaseID" id="sv_x_CaseID" value="<?php echo RemoveHtml($notices->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>"<?php echo $notices->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($notices->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($notices->CaseID->ReadOnly || $notices->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="notices" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $notices->CaseID->displayValueSeparatorAttribute() ?>" name="x_CaseID" id="x_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fnoticesedit.createAutoSuggest({"id":"x_CaseID","forceSelect":true});
</script>
<?php echo $notices->CaseID->Lookup->getParamTag("p_x_CaseID") ?>
</span>
<?php } ?>
<?php echo $notices->CaseID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->Notice->Visible) { // Notice ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
	<div id="r_Notice" class="form-group row">
		<label id="elh_notices_Notice" for="x_Notice" class="<?php echo $notices_edit->LeftColumnClass ?>"><?php echo $notices->Notice->caption() ?><?php echo ($notices->Notice->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $notices_edit->RightColumnClass ?>"><div<?php echo $notices->Notice->cellAttributes() ?>>
<span id="el_notices_Notice">
<textarea data-table="notices" data-field="x_Notice" name="x_Notice" id="x_Notice" cols="35" rows="2" placeholder="<?php echo HtmlEncode($notices->Notice->getPlaceHolder()) ?>"<?php echo $notices->Notice->editAttributes() ?>><?php echo $notices->Notice->EditValue ?></textarea>
</span>
<?php echo $notices->Notice->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notice">
		<td class="<?php echo $notices_edit->TableLeftColumnClass ?>"><span id="elh_notices_Notice"><?php echo $notices->Notice->caption() ?><?php echo ($notices->Notice->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $notices->Notice->cellAttributes() ?>>
<span id="el_notices_Notice">
<textarea data-table="notices" data-field="x_Notice" name="x_Notice" id="x_Notice" cols="35" rows="2" placeholder="<?php echo HtmlEncode($notices->Notice->getPlaceHolder()) ?>"<?php echo $notices->Notice->editAttributes() ?>><?php echo $notices->Notice->EditValue ?></textarea>
</span>
<?php echo $notices->Notice->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
	<div id="r_NoticeDate" class="form-group row">
		<label id="elh_notices_NoticeDate" for="x_NoticeDate" class="<?php echo $notices_edit->LeftColumnClass ?>"><?php echo $notices->NoticeDate->caption() ?><?php echo ($notices->NoticeDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $notices_edit->RightColumnClass ?>"><div<?php echo $notices->NoticeDate->cellAttributes() ?>>
<span id="el_notices_NoticeDate">
<input type="text" data-table="notices" data-field="x_NoticeDate" data-format="7" name="x_NoticeDate" id="x_NoticeDate" placeholder="<?php echo HtmlEncode($notices->NoticeDate->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeDate->EditValue ?>"<?php echo $notices->NoticeDate->editAttributes() ?>>
<?php if (!$notices->NoticeDate->ReadOnly && !$notices->NoticeDate->Disabled && !isset($notices->NoticeDate->EditAttrs["readonly"]) && !isset($notices->NoticeDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnoticesedit", "x_NoticeDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $notices->NoticeDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_NoticeDate">
		<td class="<?php echo $notices_edit->TableLeftColumnClass ?>"><span id="elh_notices_NoticeDate"><?php echo $notices->NoticeDate->caption() ?><?php echo ($notices->NoticeDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $notices->NoticeDate->cellAttributes() ?>>
<span id="el_notices_NoticeDate">
<input type="text" data-table="notices" data-field="x_NoticeDate" data-format="7" name="x_NoticeDate" id="x_NoticeDate" placeholder="<?php echo HtmlEncode($notices->NoticeDate->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeDate->EditValue ?>"<?php echo $notices->NoticeDate->editAttributes() ?>>
<?php if (!$notices->NoticeDate->ReadOnly && !$notices->NoticeDate->Disabled && !isset($notices->NoticeDate->EditAttrs["readonly"]) && !isset($notices->NoticeDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnoticesedit", "x_NoticeDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $notices->NoticeDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
	<div id="r_NoticeTime" class="form-group row">
		<label id="elh_notices_NoticeTime" for="x_NoticeTime" class="<?php echo $notices_edit->LeftColumnClass ?>"><?php echo $notices->NoticeTime->caption() ?><?php echo ($notices->NoticeTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $notices_edit->RightColumnClass ?>"><div<?php echo $notices->NoticeTime->cellAttributes() ?>>
<span id="el_notices_NoticeTime">
<input type="text" data-table="notices" data-field="x_NoticeTime" name="x_NoticeTime" id="x_NoticeTime" placeholder="<?php echo HtmlEncode($notices->NoticeTime->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeTime->EditValue ?>"<?php echo $notices->NoticeTime->editAttributes() ?>>
<?php if (!$notices->NoticeTime->ReadOnly && !$notices->NoticeTime->Disabled && !isset($notices->NoticeTime->EditAttrs["readonly"]) && !isset($notices->NoticeTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fnoticesedit", "x_NoticeTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $notices->NoticeTime->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_NoticeTime">
		<td class="<?php echo $notices_edit->TableLeftColumnClass ?>"><span id="elh_notices_NoticeTime"><?php echo $notices->NoticeTime->caption() ?><?php echo ($notices->NoticeTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $notices->NoticeTime->cellAttributes() ?>>
<span id="el_notices_NoticeTime">
<input type="text" data-table="notices" data-field="x_NoticeTime" name="x_NoticeTime" id="x_NoticeTime" placeholder="<?php echo HtmlEncode($notices->NoticeTime->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeTime->EditValue ?>"<?php echo $notices->NoticeTime->editAttributes() ?>>
<?php if (!$notices->NoticeTime->ReadOnly && !$notices->NoticeTime->Disabled && !isset($notices->NoticeTime->EditAttrs["readonly"]) && !isset($notices->NoticeTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fnoticesedit", "x_NoticeTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $notices->NoticeTime->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->Notes->Visible) { // Notes ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_notices_Notes" class="<?php echo $notices_edit->LeftColumnClass ?>"><?php echo $notices->Notes->caption() ?><?php echo ($notices->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $notices_edit->RightColumnClass ?>"><div<?php echo $notices->Notes->cellAttributes() ?>>
<span id="el_notices_Notes">
<?php AppendClass($notices->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="notices" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="3" placeholder="<?php echo HtmlEncode($notices->Notes->getPlaceHolder()) ?>"<?php echo $notices->Notes->editAttributes() ?>><?php echo $notices->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fnoticesedit", "x_Notes", 35, 3, <?php echo ($notices->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $notices->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $notices_edit->TableLeftColumnClass ?>"><span id="elh_notices_Notes"><?php echo $notices->Notes->caption() ?><?php echo ($notices->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $notices->Notes->cellAttributes() ?>>
<span id="el_notices_Notes">
<?php AppendClass($notices->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="notices" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="3" placeholder="<?php echo HtmlEncode($notices->Notes->getPlaceHolder()) ?>"<?php echo $notices->Notes->editAttributes() ?>><?php echo $notices->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fnoticesedit", "x_Notes", 35, 3, <?php echo ($notices->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $notices->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->PostMan->Visible) { // PostMan ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
	<div id="r_PostMan" class="form-group row">
		<label id="elh_notices_PostMan" for="x_PostMan" class="<?php echo $notices_edit->LeftColumnClass ?>"><?php echo $notices->PostMan->caption() ?><?php echo ($notices->PostMan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $notices_edit->RightColumnClass ?>"><div<?php echo $notices->PostMan->cellAttributes() ?>>
<span id="el_notices_PostMan">
<input type="text" data-table="notices" data-field="x_PostMan" name="x_PostMan" id="x_PostMan" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($notices->PostMan->getPlaceHolder()) ?>" value="<?php echo $notices->PostMan->EditValue ?>"<?php echo $notices->PostMan->editAttributes() ?>>
</span>
<?php echo $notices->PostMan->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_PostMan">
		<td class="<?php echo $notices_edit->TableLeftColumnClass ?>"><span id="elh_notices_PostMan"><?php echo $notices->PostMan->caption() ?><?php echo ($notices->PostMan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $notices->PostMan->cellAttributes() ?>>
<span id="el_notices_PostMan">
<input type="text" data-table="notices" data-field="x_PostMan" name="x_PostMan" id="x_PostMan" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($notices->PostMan->getPlaceHolder()) ?>" value="<?php echo $notices->PostMan->EditValue ?>"<?php echo $notices->PostMan->editAttributes() ?>>
</span>
<?php echo $notices->PostMan->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->LawyerID->Visible) { // LawyerID ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
	<div id="r_LawyerID" class="form-group row">
		<label id="elh_notices_LawyerID" for="x_LawyerID" class="<?php echo $notices_edit->LeftColumnClass ?>"><?php echo $notices->LawyerID->caption() ?><?php echo ($notices->LawyerID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $notices_edit->RightColumnClass ?>"><div<?php echo $notices->LawyerID->cellAttributes() ?>>
<span id="el_notices_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="notices" data-field="x_LawyerID" data-value-separator="<?php echo $notices->LawyerID->displayValueSeparatorAttribute() ?>" id="x_LawyerID" name="x_LawyerID"<?php echo $notices->LawyerID->editAttributes() ?>>
		<?php echo $notices->LawyerID->selectOptionListHtml("x_LawyerID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawyers") && !$notices->LawyerID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LawyerID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $notices->LawyerID->caption() ?>" data-title="<?php echo $notices->LawyerID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LawyerID',url:'lawyersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $notices->LawyerID->Lookup->getParamTag("p_x_LawyerID") ?>
</span>
<?php echo $notices->LawyerID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawyerID">
		<td class="<?php echo $notices_edit->TableLeftColumnClass ?>"><span id="elh_notices_LawyerID"><?php echo $notices->LawyerID->caption() ?><?php echo ($notices->LawyerID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $notices->LawyerID->cellAttributes() ?>>
<span id="el_notices_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="notices" data-field="x_LawyerID" data-value-separator="<?php echo $notices->LawyerID->displayValueSeparatorAttribute() ?>" id="x_LawyerID" name="x_LawyerID"<?php echo $notices->LawyerID->editAttributes() ?>>
		<?php echo $notices->LawyerID->selectOptionListHtml("x_LawyerID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawyers") && !$notices->LawyerID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LawyerID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $notices->LawyerID->caption() ?>" data-title="<?php echo $notices->LawyerID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LawyerID',url:'lawyersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $notices->LawyerID->Lookup->getParamTag("p_x_LawyerID") ?>
</span>
<?php echo $notices->LawyerID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<span id="el_notices_NoticeID">
<input type="hidden" data-table="notices" data-field="x_NoticeID" name="x_NoticeID" id="x_NoticeID" value="<?php echo HtmlEncode($notices->NoticeID->CurrentValue) ?>">
</span>
<?php if (!$notices_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $notices_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $notices_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$notices_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$notices_edit->IsModal) { ?>
<?php if (!isset($notices_edit->Pager)) $notices_edit->Pager = new PrevNextPager($notices_edit->StartRec, $notices_edit->DisplayRecs, $notices_edit->TotalRecs, $notices_edit->AutoHidePager) ?>
<?php if ($notices_edit->Pager->RecordCount > 0 && $notices_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($notices_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $notices_edit->pageUrl() ?>start=<?php echo $notices_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($notices_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $notices_edit->pageUrl() ?>start=<?php echo $notices_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $notices_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($notices_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $notices_edit->pageUrl() ?>start=<?php echo $notices_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($notices_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $notices_edit->pageUrl() ?>start=<?php echo $notices_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $notices_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$notices_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$notices_edit->terminate();
?>
