<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($notices_grid))
	$notices_grid = new notices_grid();

// Run the page
$notices_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notices_grid->Page_Render();
?>
<?php if (!$notices->isExport()) { ?>
<script>

// Form object
var fnoticesgrid = new ew.Form("fnoticesgrid", "grid");
fnoticesgrid.formKeyCountName = '<?php echo $notices_grid->FormKeyCountName ?>';

// Validate form
fnoticesgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($notices_grid->CaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->CaseID->caption(), $notices->CaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notices_grid->Notice->Required) { ?>
			elm = this.getElements("x" + infix + "_Notice");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->Notice->caption(), $notices->Notice->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notices_grid->NoticeDate->Required) { ?>
			elm = this.getElements("x" + infix + "_NoticeDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->NoticeDate->caption(), $notices->NoticeDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NoticeDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($notices->NoticeDate->errorMessage()) ?>");
		<?php if ($notices_grid->NoticeTime->Required) { ?>
			elm = this.getElements("x" + infix + "_NoticeTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->NoticeTime->caption(), $notices->NoticeTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NoticeTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($notices->NoticeTime->errorMessage()) ?>");
		<?php if ($notices_grid->PostMan->Required) { ?>
			elm = this.getElements("x" + infix + "_PostMan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notices->PostMan->caption(), $notices->PostMan->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fnoticesgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "CaseID", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notice", false)) return false;
	if (ew.valueChanged(fobj, infix, "NoticeDate", false)) return false;
	if (ew.valueChanged(fobj, infix, "NoticeTime", false)) return false;
	if (ew.valueChanged(fobj, infix, "PostMan", false)) return false;
	return true;
}

// Form_CustomValidate event
fnoticesgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnoticesgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnoticesgrid.lists["x_CaseID"] = <?php echo $notices_grid->CaseID->Lookup->toClientList() ?>;
fnoticesgrid.lists["x_CaseID"].options = <?php echo JsonEncode($notices_grid->CaseID->lookupOptions()) ?>;
fnoticesgrid.autoSuggests["x_CaseID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$notices_grid->renderOtherOptions();
?>
<?php $notices_grid->showPageHeader(); ?>
<?php
$notices_grid->showMessage();
?>
<?php if ($notices_grid->TotalRecs > 0 || $notices->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($notices_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> notices">
<?php if ($notices_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $notices_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fnoticesgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_notices" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_noticesgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$notices_grid->RowType = ROWTYPE_HEADER;

// Render list options
$notices_grid->renderListOptions();

// Render list options (header, left)
$notices_grid->ListOptions->render("header", "left");
?>
<?php if ($notices->CaseID->Visible) { // CaseID ?>
	<?php if ($notices->sortUrl($notices->CaseID) == "") { ?>
		<th data-name="CaseID" class="<?php echo $notices->CaseID->headerCellClass() ?>"><div id="elh_notices_CaseID" class="notices_CaseID"><div class="ew-table-header-caption"><?php echo $notices->CaseID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseID" class="<?php echo $notices->CaseID->headerCellClass() ?>"><div><div id="elh_notices_CaseID" class="notices_CaseID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->CaseID->caption() ?></span><span class="ew-table-header-sort"><?php if ($notices->CaseID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->CaseID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->Notice->Visible) { // Notice ?>
	<?php if ($notices->sortUrl($notices->Notice) == "") { ?>
		<th data-name="Notice" class="<?php echo $notices->Notice->headerCellClass() ?>"><div id="elh_notices_Notice" class="notices_Notice"><div class="ew-table-header-caption"><?php echo $notices->Notice->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notice" class="<?php echo $notices->Notice->headerCellClass() ?>"><div><div id="elh_notices_Notice" class="notices_Notice">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->Notice->caption() ?></span><span class="ew-table-header-sort"><?php if ($notices->Notice->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->Notice->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
	<?php if ($notices->sortUrl($notices->NoticeDate) == "") { ?>
		<th data-name="NoticeDate" class="<?php echo $notices->NoticeDate->headerCellClass() ?>"><div id="elh_notices_NoticeDate" class="notices_NoticeDate"><div class="ew-table-header-caption"><?php echo $notices->NoticeDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NoticeDate" class="<?php echo $notices->NoticeDate->headerCellClass() ?>"><div><div id="elh_notices_NoticeDate" class="notices_NoticeDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->NoticeDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($notices->NoticeDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->NoticeDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
	<?php if ($notices->sortUrl($notices->NoticeTime) == "") { ?>
		<th data-name="NoticeTime" class="<?php echo $notices->NoticeTime->headerCellClass() ?>"><div id="elh_notices_NoticeTime" class="notices_NoticeTime"><div class="ew-table-header-caption"><?php echo $notices->NoticeTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NoticeTime" class="<?php echo $notices->NoticeTime->headerCellClass() ?>"><div><div id="elh_notices_NoticeTime" class="notices_NoticeTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->NoticeTime->caption() ?></span><span class="ew-table-header-sort"><?php if ($notices->NoticeTime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->NoticeTime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->PostMan->Visible) { // PostMan ?>
	<?php if ($notices->sortUrl($notices->PostMan) == "") { ?>
		<th data-name="PostMan" class="<?php echo $notices->PostMan->headerCellClass() ?>"><div id="elh_notices_PostMan" class="notices_PostMan"><div class="ew-table-header-caption"><?php echo $notices->PostMan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PostMan" class="<?php echo $notices->PostMan->headerCellClass() ?>"><div><div id="elh_notices_PostMan" class="notices_PostMan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->PostMan->caption() ?></span><span class="ew-table-header-sort"><?php if ($notices->PostMan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->PostMan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$notices_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$notices_grid->StartRec = 1;
$notices_grid->StopRec = $notices_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $notices_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($notices_grid->FormKeyCountName) && ($notices->isGridAdd() || $notices->isGridEdit() || $notices->isConfirm())) {
		$notices_grid->KeyCount = $CurrentForm->getValue($notices_grid->FormKeyCountName);
		$notices_grid->StopRec = $notices_grid->StartRec + $notices_grid->KeyCount - 1;
	}
}
$notices_grid->RecCnt = $notices_grid->StartRec - 1;
if ($notices_grid->Recordset && !$notices_grid->Recordset->EOF) {
	$notices_grid->Recordset->moveFirst();
	$selectLimit = $notices_grid->UseSelectLimit;
	if (!$selectLimit && $notices_grid->StartRec > 1)
		$notices_grid->Recordset->move($notices_grid->StartRec - 1);
} elseif (!$notices->AllowAddDeleteRow && $notices_grid->StopRec == 0) {
	$notices_grid->StopRec = $notices->GridAddRowCount;
}

// Initialize aggregate
$notices->RowType = ROWTYPE_AGGREGATEINIT;
$notices->resetAttributes();
$notices_grid->renderRow();
if ($notices->isGridAdd())
	$notices_grid->RowIndex = 0;
if ($notices->isGridEdit())
	$notices_grid->RowIndex = 0;
while ($notices_grid->RecCnt < $notices_grid->StopRec) {
	$notices_grid->RecCnt++;
	if ($notices_grid->RecCnt >= $notices_grid->StartRec) {
		$notices_grid->RowCnt++;
		if ($notices->isGridAdd() || $notices->isGridEdit() || $notices->isConfirm()) {
			$notices_grid->RowIndex++;
			$CurrentForm->Index = $notices_grid->RowIndex;
			if ($CurrentForm->hasValue($notices_grid->FormActionName) && $notices_grid->EventCancelled)
				$notices_grid->RowAction = strval($CurrentForm->getValue($notices_grid->FormActionName));
			elseif ($notices->isGridAdd())
				$notices_grid->RowAction = "insert";
			else
				$notices_grid->RowAction = "";
		}

		// Set up key count
		$notices_grid->KeyCount = $notices_grid->RowIndex;

		// Init row class and style
		$notices->resetAttributes();
		$notices->CssClass = "";
		if ($notices->isGridAdd()) {
			if ($notices->CurrentMode == "copy") {
				$notices_grid->loadRowValues($notices_grid->Recordset); // Load row values
				$notices_grid->setRecordKey($notices_grid->RowOldKey, $notices_grid->Recordset); // Set old record key
			} else {
				$notices_grid->loadRowValues(); // Load default values
				$notices_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$notices_grid->loadRowValues($notices_grid->Recordset); // Load row values
		}
		$notices->RowType = ROWTYPE_VIEW; // Render view
		if ($notices->isGridAdd()) // Grid add
			$notices->RowType = ROWTYPE_ADD; // Render add
		if ($notices->isGridAdd() && $notices->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$notices_grid->restoreCurrentRowFormValues($notices_grid->RowIndex); // Restore form values
		if ($notices->isGridEdit()) { // Grid edit
			if ($notices->EventCancelled)
				$notices_grid->restoreCurrentRowFormValues($notices_grid->RowIndex); // Restore form values
			if ($notices_grid->RowAction == "insert")
				$notices->RowType = ROWTYPE_ADD; // Render add
			else
				$notices->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($notices->isGridEdit() && ($notices->RowType == ROWTYPE_EDIT || $notices->RowType == ROWTYPE_ADD) && $notices->EventCancelled) // Update failed
			$notices_grid->restoreCurrentRowFormValues($notices_grid->RowIndex); // Restore form values
		if ($notices->RowType == ROWTYPE_EDIT) // Edit row
			$notices_grid->EditRowCnt++;
		if ($notices->isConfirm()) // Confirm row
			$notices_grid->restoreCurrentRowFormValues($notices_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$notices->RowAttrs = array_merge($notices->RowAttrs, array('data-rowindex'=>$notices_grid->RowCnt, 'id'=>'r' . $notices_grid->RowCnt . '_notices', 'data-rowtype'=>$notices->RowType));

		// Render row
		$notices_grid->renderRow();

		// Render list options
		$notices_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($notices_grid->RowAction <> "delete" && $notices_grid->RowAction <> "insertdelete" && !($notices_grid->RowAction == "insert" && $notices->isConfirm() && $notices_grid->emptyRow())) {
?>
	<tr<?php echo $notices->rowAttributes() ?>>
<?php

// Render list options (body, left)
$notices_grid->ListOptions->render("body", "left", $notices_grid->RowCnt);
?>
	<?php if ($notices->CaseID->Visible) { // CaseID ?>
		<td data-name="CaseID"<?php echo $notices->CaseID->cellAttributes() ?>>
<?php if ($notices->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($notices->CaseID->getSessionValue() <> "") { ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_CaseID" class="form-group notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $notices_grid->RowIndex ?>_CaseID" name="x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_CaseID" class="form-group notices_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$notices->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$notices->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $notices_grid->RowIndex ?>_CaseID" class="text-nowrap" style="z-index: <?php echo (9000 - $notices_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $notices_grid->RowIndex ?>_CaseID" id="sv_x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo RemoveHtml($notices->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>"<?php echo $notices->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($notices->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $notices_grid->RowIndex ?>_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($notices->CaseID->ReadOnly || $notices->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="notices" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $notices->CaseID->displayValueSeparatorAttribute() ?>" name="x<?php echo $notices_grid->RowIndex ?>_CaseID" id="x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fnoticesgrid.createAutoSuggest({"id":"x<?php echo $notices_grid->RowIndex ?>_CaseID","forceSelect":true});
</script>
<?php echo $notices->CaseID->Lookup->getParamTag("p_x" . $notices_grid->RowIndex . "_CaseID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="notices" data-field="x_CaseID" name="o<?php echo $notices_grid->RowIndex ?>_CaseID" id="o<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->OldValue) ?>">
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($notices->CaseID->getSessionValue() <> "") { ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_CaseID" class="form-group notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $notices_grid->RowIndex ?>_CaseID" name="x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_CaseID" class="form-group notices_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$notices->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$notices->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $notices_grid->RowIndex ?>_CaseID" class="text-nowrap" style="z-index: <?php echo (9000 - $notices_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $notices_grid->RowIndex ?>_CaseID" id="sv_x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo RemoveHtml($notices->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>"<?php echo $notices->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($notices->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $notices_grid->RowIndex ?>_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($notices->CaseID->ReadOnly || $notices->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="notices" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $notices->CaseID->displayValueSeparatorAttribute() ?>" name="x<?php echo $notices_grid->RowIndex ?>_CaseID" id="x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fnoticesgrid.createAutoSuggest({"id":"x<?php echo $notices_grid->RowIndex ?>_CaseID","forceSelect":true});
</script>
<?php echo $notices->CaseID->Lookup->getParamTag("p_x" . $notices_grid->RowIndex . "_CaseID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_CaseID" class="notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<?php echo $notices->CaseID->getViewValue() ?></span>
</span>
<?php if (!$notices->isConfirm()) { ?>
<input type="hidden" data-table="notices" data-field="x_CaseID" name="x<?php echo $notices_grid->RowIndex ?>_CaseID" id="x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_CaseID" name="o<?php echo $notices_grid->RowIndex ?>_CaseID" id="o<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notices" data-field="x_CaseID" name="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_CaseID" id="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_CaseID" name="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_CaseID" id="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($notices->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="notices" data-field="x_NoticeID" name="x<?php echo $notices_grid->RowIndex ?>_NoticeID" id="x<?php echo $notices_grid->RowIndex ?>_NoticeID" value="<?php echo HtmlEncode($notices->NoticeID->CurrentValue) ?>">
<input type="hidden" data-table="notices" data-field="x_NoticeID" name="o<?php echo $notices_grid->RowIndex ?>_NoticeID" id="o<?php echo $notices_grid->RowIndex ?>_NoticeID" value="<?php echo HtmlEncode($notices->NoticeID->OldValue) ?>">
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_EDIT || $notices->CurrentMode == "edit") { ?>
<input type="hidden" data-table="notices" data-field="x_NoticeID" name="x<?php echo $notices_grid->RowIndex ?>_NoticeID" id="x<?php echo $notices_grid->RowIndex ?>_NoticeID" value="<?php echo HtmlEncode($notices->NoticeID->CurrentValue) ?>">
<?php } ?>
	<?php if ($notices->Notice->Visible) { // Notice ?>
		<td data-name="Notice"<?php echo $notices->Notice->cellAttributes() ?>>
<?php if ($notices->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_Notice" class="form-group notices_Notice">
<textarea data-table="notices" data-field="x_Notice" name="x<?php echo $notices_grid->RowIndex ?>_Notice" id="x<?php echo $notices_grid->RowIndex ?>_Notice" cols="35" rows="2" placeholder="<?php echo HtmlEncode($notices->Notice->getPlaceHolder()) ?>"<?php echo $notices->Notice->editAttributes() ?>><?php echo $notices->Notice->EditValue ?></textarea>
</span>
<input type="hidden" data-table="notices" data-field="x_Notice" name="o<?php echo $notices_grid->RowIndex ?>_Notice" id="o<?php echo $notices_grid->RowIndex ?>_Notice" value="<?php echo HtmlEncode($notices->Notice->OldValue) ?>">
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_Notice" class="form-group notices_Notice">
<textarea data-table="notices" data-field="x_Notice" name="x<?php echo $notices_grid->RowIndex ?>_Notice" id="x<?php echo $notices_grid->RowIndex ?>_Notice" cols="35" rows="2" placeholder="<?php echo HtmlEncode($notices->Notice->getPlaceHolder()) ?>"<?php echo $notices->Notice->editAttributes() ?>><?php echo $notices->Notice->EditValue ?></textarea>
</span>
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_Notice" class="notices_Notice">
<span<?php echo $notices->Notice->viewAttributes() ?>>
<?php echo $notices->Notice->getViewValue() ?></span>
</span>
<?php if (!$notices->isConfirm()) { ?>
<input type="hidden" data-table="notices" data-field="x_Notice" name="x<?php echo $notices_grid->RowIndex ?>_Notice" id="x<?php echo $notices_grid->RowIndex ?>_Notice" value="<?php echo HtmlEncode($notices->Notice->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_Notice" name="o<?php echo $notices_grid->RowIndex ?>_Notice" id="o<?php echo $notices_grid->RowIndex ?>_Notice" value="<?php echo HtmlEncode($notices->Notice->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notices" data-field="x_Notice" name="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_Notice" id="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_Notice" value="<?php echo HtmlEncode($notices->Notice->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_Notice" name="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_Notice" id="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_Notice" value="<?php echo HtmlEncode($notices->Notice->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
		<td data-name="NoticeDate"<?php echo $notices->NoticeDate->cellAttributes() ?>>
<?php if ($notices->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_NoticeDate" class="form-group notices_NoticeDate">
<input type="text" data-table="notices" data-field="x_NoticeDate" data-format="7" name="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" placeholder="<?php echo HtmlEncode($notices->NoticeDate->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeDate->EditValue ?>"<?php echo $notices->NoticeDate->editAttributes() ?>>
<?php if (!$notices->NoticeDate->ReadOnly && !$notices->NoticeDate->Disabled && !isset($notices->NoticeDate->EditAttrs["readonly"]) && !isset($notices->NoticeDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnoticesgrid", "x<?php echo $notices_grid->RowIndex ?>_NoticeDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="notices" data-field="x_NoticeDate" name="o<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="o<?php echo $notices_grid->RowIndex ?>_NoticeDate" value="<?php echo HtmlEncode($notices->NoticeDate->OldValue) ?>">
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_NoticeDate" class="form-group notices_NoticeDate">
<input type="text" data-table="notices" data-field="x_NoticeDate" data-format="7" name="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" placeholder="<?php echo HtmlEncode($notices->NoticeDate->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeDate->EditValue ?>"<?php echo $notices->NoticeDate->editAttributes() ?>>
<?php if (!$notices->NoticeDate->ReadOnly && !$notices->NoticeDate->Disabled && !isset($notices->NoticeDate->EditAttrs["readonly"]) && !isset($notices->NoticeDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnoticesgrid", "x<?php echo $notices_grid->RowIndex ?>_NoticeDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_NoticeDate" class="notices_NoticeDate">
<span<?php echo $notices->NoticeDate->viewAttributes() ?>>
<?php echo $notices->NoticeDate->getViewValue() ?></span>
</span>
<?php if (!$notices->isConfirm()) { ?>
<input type="hidden" data-table="notices" data-field="x_NoticeDate" name="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" value="<?php echo HtmlEncode($notices->NoticeDate->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_NoticeDate" name="o<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="o<?php echo $notices_grid->RowIndex ?>_NoticeDate" value="<?php echo HtmlEncode($notices->NoticeDate->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notices" data-field="x_NoticeDate" name="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_NoticeDate" value="<?php echo HtmlEncode($notices->NoticeDate->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_NoticeDate" name="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_NoticeDate" value="<?php echo HtmlEncode($notices->NoticeDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
		<td data-name="NoticeTime"<?php echo $notices->NoticeTime->cellAttributes() ?>>
<?php if ($notices->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_NoticeTime" class="form-group notices_NoticeTime">
<input type="text" data-table="notices" data-field="x_NoticeTime" name="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" placeholder="<?php echo HtmlEncode($notices->NoticeTime->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeTime->EditValue ?>"<?php echo $notices->NoticeTime->editAttributes() ?>>
<?php if (!$notices->NoticeTime->ReadOnly && !$notices->NoticeTime->Disabled && !isset($notices->NoticeTime->EditAttrs["readonly"]) && !isset($notices->NoticeTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fnoticesgrid", "x<?php echo $notices_grid->RowIndex ?>_NoticeTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<input type="hidden" data-table="notices" data-field="x_NoticeTime" name="o<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="o<?php echo $notices_grid->RowIndex ?>_NoticeTime" value="<?php echo HtmlEncode($notices->NoticeTime->OldValue) ?>">
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_NoticeTime" class="form-group notices_NoticeTime">
<input type="text" data-table="notices" data-field="x_NoticeTime" name="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" placeholder="<?php echo HtmlEncode($notices->NoticeTime->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeTime->EditValue ?>"<?php echo $notices->NoticeTime->editAttributes() ?>>
<?php if (!$notices->NoticeTime->ReadOnly && !$notices->NoticeTime->Disabled && !isset($notices->NoticeTime->EditAttrs["readonly"]) && !isset($notices->NoticeTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fnoticesgrid", "x<?php echo $notices_grid->RowIndex ?>_NoticeTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_NoticeTime" class="notices_NoticeTime">
<span<?php echo $notices->NoticeTime->viewAttributes() ?>>
<?php echo $notices->NoticeTime->getViewValue() ?></span>
</span>
<?php if (!$notices->isConfirm()) { ?>
<input type="hidden" data-table="notices" data-field="x_NoticeTime" name="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" value="<?php echo HtmlEncode($notices->NoticeTime->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_NoticeTime" name="o<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="o<?php echo $notices_grid->RowIndex ?>_NoticeTime" value="<?php echo HtmlEncode($notices->NoticeTime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notices" data-field="x_NoticeTime" name="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_NoticeTime" value="<?php echo HtmlEncode($notices->NoticeTime->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_NoticeTime" name="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_NoticeTime" value="<?php echo HtmlEncode($notices->NoticeTime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($notices->PostMan->Visible) { // PostMan ?>
		<td data-name="PostMan"<?php echo $notices->PostMan->cellAttributes() ?>>
<?php if ($notices->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_PostMan" class="form-group notices_PostMan">
<input type="text" data-table="notices" data-field="x_PostMan" name="x<?php echo $notices_grid->RowIndex ?>_PostMan" id="x<?php echo $notices_grid->RowIndex ?>_PostMan" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($notices->PostMan->getPlaceHolder()) ?>" value="<?php echo $notices->PostMan->EditValue ?>"<?php echo $notices->PostMan->editAttributes() ?>>
</span>
<input type="hidden" data-table="notices" data-field="x_PostMan" name="o<?php echo $notices_grid->RowIndex ?>_PostMan" id="o<?php echo $notices_grid->RowIndex ?>_PostMan" value="<?php echo HtmlEncode($notices->PostMan->OldValue) ?>">
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_PostMan" class="form-group notices_PostMan">
<input type="text" data-table="notices" data-field="x_PostMan" name="x<?php echo $notices_grid->RowIndex ?>_PostMan" id="x<?php echo $notices_grid->RowIndex ?>_PostMan" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($notices->PostMan->getPlaceHolder()) ?>" value="<?php echo $notices->PostMan->EditValue ?>"<?php echo $notices->PostMan->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($notices->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notices_grid->RowCnt ?>_notices_PostMan" class="notices_PostMan">
<span<?php echo $notices->PostMan->viewAttributes() ?>>
<?php echo $notices->PostMan->getViewValue() ?></span>
</span>
<?php if (!$notices->isConfirm()) { ?>
<input type="hidden" data-table="notices" data-field="x_PostMan" name="x<?php echo $notices_grid->RowIndex ?>_PostMan" id="x<?php echo $notices_grid->RowIndex ?>_PostMan" value="<?php echo HtmlEncode($notices->PostMan->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_PostMan" name="o<?php echo $notices_grid->RowIndex ?>_PostMan" id="o<?php echo $notices_grid->RowIndex ?>_PostMan" value="<?php echo HtmlEncode($notices->PostMan->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notices" data-field="x_PostMan" name="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_PostMan" id="fnoticesgrid$x<?php echo $notices_grid->RowIndex ?>_PostMan" value="<?php echo HtmlEncode($notices->PostMan->FormValue) ?>">
<input type="hidden" data-table="notices" data-field="x_PostMan" name="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_PostMan" id="fnoticesgrid$o<?php echo $notices_grid->RowIndex ?>_PostMan" value="<?php echo HtmlEncode($notices->PostMan->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$notices_grid->ListOptions->render("body", "right", $notices_grid->RowCnt);
?>
	</tr>
<?php if ($notices->RowType == ROWTYPE_ADD || $notices->RowType == ROWTYPE_EDIT) { ?>
<script>
fnoticesgrid.updateLists(<?php echo $notices_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$notices->isGridAdd() || $notices->CurrentMode == "copy")
		if (!$notices_grid->Recordset->EOF)
			$notices_grid->Recordset->moveNext();
}
?>
<?php
	if ($notices->CurrentMode == "add" || $notices->CurrentMode == "copy" || $notices->CurrentMode == "edit") {
		$notices_grid->RowIndex = '$rowindex$';
		$notices_grid->loadRowValues();

		// Set row properties
		$notices->resetAttributes();
		$notices->RowAttrs = array_merge($notices->RowAttrs, array('data-rowindex'=>$notices_grid->RowIndex, 'id'=>'r0_notices', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($notices->RowAttrs["class"], "ew-template");
		$notices->RowType = ROWTYPE_ADD;

		// Render row
		$notices_grid->renderRow();

		// Render list options
		$notices_grid->renderListOptions();
		$notices_grid->StartRowCnt = 0;
?>
	<tr<?php echo $notices->rowAttributes() ?>>
<?php

// Render list options (body, left)
$notices_grid->ListOptions->render("body", "left", $notices_grid->RowIndex);
?>
	<?php if ($notices->CaseID->Visible) { // CaseID ?>
		<td data-name="CaseID">
<?php if (!$notices->isConfirm()) { ?>
<?php if ($notices->CaseID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_notices_CaseID" class="form-group notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $notices_grid->RowIndex ?>_CaseID" name="x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_notices_CaseID" class="form-group notices_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$notices->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$notices->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $notices_grid->RowIndex ?>_CaseID" class="text-nowrap" style="z-index: <?php echo (9000 - $notices_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $notices_grid->RowIndex ?>_CaseID" id="sv_x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo RemoveHtml($notices->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>"<?php echo $notices->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($notices->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $notices_grid->RowIndex ?>_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($notices->CaseID->ReadOnly || $notices->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="notices" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $notices->CaseID->displayValueSeparatorAttribute() ?>" name="x<?php echo $notices_grid->RowIndex ?>_CaseID" id="x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fnoticesgrid.createAutoSuggest({"id":"x<?php echo $notices_grid->RowIndex ?>_CaseID","forceSelect":true});
</script>
<?php echo $notices->CaseID->Lookup->getParamTag("p_x" . $notices_grid->RowIndex . "_CaseID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_notices_CaseID" class="form-group notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notices" data-field="x_CaseID" name="x<?php echo $notices_grid->RowIndex ?>_CaseID" id="x<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notices" data-field="x_CaseID" name="o<?php echo $notices_grid->RowIndex ?>_CaseID" id="o<?php echo $notices_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($notices->CaseID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($notices->Notice->Visible) { // Notice ?>
		<td data-name="Notice">
<?php if (!$notices->isConfirm()) { ?>
<span id="el$rowindex$_notices_Notice" class="form-group notices_Notice">
<textarea data-table="notices" data-field="x_Notice" name="x<?php echo $notices_grid->RowIndex ?>_Notice" id="x<?php echo $notices_grid->RowIndex ?>_Notice" cols="35" rows="2" placeholder="<?php echo HtmlEncode($notices->Notice->getPlaceHolder()) ?>"<?php echo $notices->Notice->editAttributes() ?>><?php echo $notices->Notice->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el$rowindex$_notices_Notice" class="form-group notices_Notice">
<span<?php echo $notices->Notice->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->Notice->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notices" data-field="x_Notice" name="x<?php echo $notices_grid->RowIndex ?>_Notice" id="x<?php echo $notices_grid->RowIndex ?>_Notice" value="<?php echo HtmlEncode($notices->Notice->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notices" data-field="x_Notice" name="o<?php echo $notices_grid->RowIndex ?>_Notice" id="o<?php echo $notices_grid->RowIndex ?>_Notice" value="<?php echo HtmlEncode($notices->Notice->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
		<td data-name="NoticeDate">
<?php if (!$notices->isConfirm()) { ?>
<span id="el$rowindex$_notices_NoticeDate" class="form-group notices_NoticeDate">
<input type="text" data-table="notices" data-field="x_NoticeDate" data-format="7" name="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" placeholder="<?php echo HtmlEncode($notices->NoticeDate->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeDate->EditValue ?>"<?php echo $notices->NoticeDate->editAttributes() ?>>
<?php if (!$notices->NoticeDate->ReadOnly && !$notices->NoticeDate->Disabled && !isset($notices->NoticeDate->EditAttrs["readonly"]) && !isset($notices->NoticeDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnoticesgrid", "x<?php echo $notices_grid->RowIndex ?>_NoticeDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_notices_NoticeDate" class="form-group notices_NoticeDate">
<span<?php echo $notices->NoticeDate->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->NoticeDate->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notices" data-field="x_NoticeDate" name="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="x<?php echo $notices_grid->RowIndex ?>_NoticeDate" value="<?php echo HtmlEncode($notices->NoticeDate->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notices" data-field="x_NoticeDate" name="o<?php echo $notices_grid->RowIndex ?>_NoticeDate" id="o<?php echo $notices_grid->RowIndex ?>_NoticeDate" value="<?php echo HtmlEncode($notices->NoticeDate->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
		<td data-name="NoticeTime">
<?php if (!$notices->isConfirm()) { ?>
<span id="el$rowindex$_notices_NoticeTime" class="form-group notices_NoticeTime">
<input type="text" data-table="notices" data-field="x_NoticeTime" name="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" placeholder="<?php echo HtmlEncode($notices->NoticeTime->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeTime->EditValue ?>"<?php echo $notices->NoticeTime->editAttributes() ?>>
<?php if (!$notices->NoticeTime->ReadOnly && !$notices->NoticeTime->Disabled && !isset($notices->NoticeTime->EditAttrs["readonly"]) && !isset($notices->NoticeTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fnoticesgrid", "x<?php echo $notices_grid->RowIndex ?>_NoticeTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_notices_NoticeTime" class="form-group notices_NoticeTime">
<span<?php echo $notices->NoticeTime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->NoticeTime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notices" data-field="x_NoticeTime" name="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="x<?php echo $notices_grid->RowIndex ?>_NoticeTime" value="<?php echo HtmlEncode($notices->NoticeTime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notices" data-field="x_NoticeTime" name="o<?php echo $notices_grid->RowIndex ?>_NoticeTime" id="o<?php echo $notices_grid->RowIndex ?>_NoticeTime" value="<?php echo HtmlEncode($notices->NoticeTime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($notices->PostMan->Visible) { // PostMan ?>
		<td data-name="PostMan">
<?php if (!$notices->isConfirm()) { ?>
<span id="el$rowindex$_notices_PostMan" class="form-group notices_PostMan">
<input type="text" data-table="notices" data-field="x_PostMan" name="x<?php echo $notices_grid->RowIndex ?>_PostMan" id="x<?php echo $notices_grid->RowIndex ?>_PostMan" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($notices->PostMan->getPlaceHolder()) ?>" value="<?php echo $notices->PostMan->EditValue ?>"<?php echo $notices->PostMan->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_notices_PostMan" class="form-group notices_PostMan">
<span<?php echo $notices->PostMan->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notices->PostMan->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notices" data-field="x_PostMan" name="x<?php echo $notices_grid->RowIndex ?>_PostMan" id="x<?php echo $notices_grid->RowIndex ?>_PostMan" value="<?php echo HtmlEncode($notices->PostMan->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notices" data-field="x_PostMan" name="o<?php echo $notices_grid->RowIndex ?>_PostMan" id="o<?php echo $notices_grid->RowIndex ?>_PostMan" value="<?php echo HtmlEncode($notices->PostMan->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$notices_grid->ListOptions->render("body", "right", $notices_grid->RowIndex);
?>
<script>
fnoticesgrid.updateLists(<?php echo $notices_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($notices->CurrentMode == "add" || $notices->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $notices_grid->FormKeyCountName ?>" id="<?php echo $notices_grid->FormKeyCountName ?>" value="<?php echo $notices_grid->KeyCount ?>">
<?php echo $notices_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($notices->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $notices_grid->FormKeyCountName ?>" id="<?php echo $notices_grid->FormKeyCountName ?>" value="<?php echo $notices_grid->KeyCount ?>">
<?php echo $notices_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($notices->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fnoticesgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($notices_grid->Recordset)
	$notices_grid->Recordset->Close();
?>
</div>
<?php if ($notices_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $notices_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($notices_grid->TotalRecs == 0 && !$notices->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $notices_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$notices_grid->terminate();
?>
<?php if (!$notices->isExport()) { ?>
<script>
ew.scrollableTable("gmp_notices", "1250px", "");
</script>
<?php } ?>
