<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$notices_preview = new notices_preview();

// Run the page
$notices_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notices_preview->Page_Render();
?>
<?php $notices_preview->showPageHeader(); ?>
<div class="card ew-grid notices"><!-- .card -->
<?php if ($notices_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$notices_preview->renderListOptions();

// Render list options (header, left)
$notices_preview->ListOptions->render("header", "left");
?>
<?php if ($notices->CaseID->Visible) { // CaseID ?>
	<?php if ($notices->SortUrl($notices->CaseID) == "") { ?>
		<th class="<?php echo $notices->CaseID->headerCellClass() ?>"><?php echo $notices->CaseID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notices->CaseID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notices->CaseID->Name ?>" data-sort-order="<?php echo $notices_preview->SortField == $notices->CaseID->Name && $notices_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notices->CaseID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notices_preview->SortField == $notices->CaseID->Name) { ?><?php if ($notices_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notices_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->Notice->Visible) { // Notice ?>
	<?php if ($notices->SortUrl($notices->Notice) == "") { ?>
		<th class="<?php echo $notices->Notice->headerCellClass() ?>"><?php echo $notices->Notice->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notices->Notice->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notices->Notice->Name ?>" data-sort-order="<?php echo $notices_preview->SortField == $notices->Notice->Name && $notices_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notices->Notice->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notices_preview->SortField == $notices->Notice->Name) { ?><?php if ($notices_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notices_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
	<?php if ($notices->SortUrl($notices->NoticeDate) == "") { ?>
		<th class="<?php echo $notices->NoticeDate->headerCellClass() ?>"><?php echo $notices->NoticeDate->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notices->NoticeDate->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notices->NoticeDate->Name ?>" data-sort-order="<?php echo $notices_preview->SortField == $notices->NoticeDate->Name && $notices_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notices->NoticeDate->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notices_preview->SortField == $notices->NoticeDate->Name) { ?><?php if ($notices_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notices_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
	<?php if ($notices->SortUrl($notices->NoticeTime) == "") { ?>
		<th class="<?php echo $notices->NoticeTime->headerCellClass() ?>"><?php echo $notices->NoticeTime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notices->NoticeTime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notices->NoticeTime->Name ?>" data-sort-order="<?php echo $notices_preview->SortField == $notices->NoticeTime->Name && $notices_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notices->NoticeTime->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notices_preview->SortField == $notices->NoticeTime->Name) { ?><?php if ($notices_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notices_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->PostMan->Visible) { // PostMan ?>
	<?php if ($notices->SortUrl($notices->PostMan) == "") { ?>
		<th class="<?php echo $notices->PostMan->headerCellClass() ?>"><?php echo $notices->PostMan->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notices->PostMan->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notices->PostMan->Name ?>" data-sort-order="<?php echo $notices_preview->SortField == $notices->PostMan->Name && $notices_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notices->PostMan->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notices_preview->SortField == $notices->PostMan->Name) { ?><?php if ($notices_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notices_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$notices_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$notices_preview->RecCount = 0;
$notices_preview->RowCnt = 0;
while ($notices_preview->Recordset && !$notices_preview->Recordset->EOF) {

	// Init row class and style
	$notices_preview->RecCount++;
	$notices_preview->RowCnt++;
	$notices_preview->CssStyle = "";
	$notices_preview->loadListRowValues($notices_preview->Recordset);

	// Render row
	$notices_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$notices_preview->resetAttributes();
	$notices_preview->renderListRow();

	// Render list options
	$notices_preview->renderListOptions();
?>
	<tr<?php echo $notices_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$notices_preview->ListOptions->render("body", "left", $notices_preview->RowCnt);
?>
<?php if ($notices->CaseID->Visible) { // CaseID ?>
		<!-- CaseID -->
		<td<?php echo $notices->CaseID->cellAttributes() ?>>
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<?php echo $notices->CaseID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($notices->Notice->Visible) { // Notice ?>
		<!-- Notice -->
		<td<?php echo $notices->Notice->cellAttributes() ?>>
<span<?php echo $notices->Notice->viewAttributes() ?>>
<?php echo $notices->Notice->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
		<!-- NoticeDate -->
		<td<?php echo $notices->NoticeDate->cellAttributes() ?>>
<span<?php echo $notices->NoticeDate->viewAttributes() ?>>
<?php echo $notices->NoticeDate->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
		<!-- NoticeTime -->
		<td<?php echo $notices->NoticeTime->cellAttributes() ?>>
<span<?php echo $notices->NoticeTime->viewAttributes() ?>>
<?php echo $notices->NoticeTime->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($notices->PostMan->Visible) { // PostMan ?>
		<!-- PostMan -->
		<td<?php echo $notices->PostMan->cellAttributes() ?>>
<span<?php echo $notices->PostMan->viewAttributes() ?>>
<?php echo $notices->PostMan->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$notices_preview->ListOptions->render("body", "right", $notices_preview->RowCnt);
?>
	</tr>
<?php
	$notices_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($notices_preview->TotalRecs > 0) { ?>
<?php if (!isset($notices_preview->Pager)) $notices_preview->Pager = new PrevNextPager($notices_preview->StartRec, $notices_preview->DisplayRecs, $notices_preview->TotalRecs) ?>
<?php if ($notices_preview->Pager->RecordCount > 0 && $notices_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($notices_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $notices_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($notices_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $notices_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($notices_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $notices_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($notices_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $notices_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $notices_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $notices_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $notices_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($notices_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$notices_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($notices_preview->Recordset)
	$notices_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$notices_preview->terminate();
?>
