<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$notices_view = new notices_view();

// Run the page
$notices_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notices_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$notices->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fnoticesview = currentForm = new ew.Form("fnoticesview", "view");

// Form_CustomValidate event
fnoticesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnoticesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnoticesview.lists["x_CaseID"] = <?php echo $notices_view->CaseID->Lookup->toClientList() ?>;
fnoticesview.lists["x_CaseID"].options = <?php echo JsonEncode($notices_view->CaseID->lookupOptions()) ?>;
fnoticesview.autoSuggests["x_CaseID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fnoticesview.lists["x_LawyerID"] = <?php echo $notices_view->LawyerID->Lookup->toClientList() ?>;
fnoticesview.lists["x_LawyerID"].options = <?php echo JsonEncode($notices_view->LawyerID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$notices->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $notices_view->ExportOptions->render("body") ?>
<?php $notices_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $notices_view->showPageHeader(); ?>
<?php
$notices_view->showMessage();
?>
<?php if (!$notices_view->IsModal) { ?>
<?php if (!$notices->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($notices_view->Pager)) $notices_view->Pager = new PrevNextPager($notices_view->StartRec, $notices_view->DisplayRecs, $notices_view->TotalRecs, $notices_view->AutoHidePager) ?>
<?php if ($notices_view->Pager->RecordCount > 0 && $notices_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($notices_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $notices_view->pageUrl() ?>start=<?php echo $notices_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($notices_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $notices_view->pageUrl() ?>start=<?php echo $notices_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $notices_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($notices_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $notices_view->pageUrl() ?>start=<?php echo $notices_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($notices_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $notices_view->pageUrl() ?>start=<?php echo $notices_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $notices_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fnoticesview" id="fnoticesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($notices_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $notices_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="notices">
<input type="hidden" name="modal" value="<?php echo (int)$notices_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($notices->NoticeID->Visible) { // NoticeID ?>
	<tr id="r_NoticeID">
		<td class="<?php echo $notices_view->TableLeftColumnClass ?>"><span id="elh_notices_NoticeID"><?php echo $notices->NoticeID->caption() ?></span></td>
		<td data-name="NoticeID"<?php echo $notices->NoticeID->cellAttributes() ?>>
<span id="el_notices_NoticeID">
<span<?php echo $notices->NoticeID->viewAttributes() ?>>
<?php echo $notices->NoticeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($notices->CaseID->Visible) { // CaseID ?>
	<tr id="r_CaseID">
		<td class="<?php echo $notices_view->TableLeftColumnClass ?>"><span id="elh_notices_CaseID"><?php echo $notices->CaseID->caption() ?></span></td>
		<td data-name="CaseID"<?php echo $notices->CaseID->cellAttributes() ?>>
<span id="el_notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<?php echo $notices->CaseID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($notices->Notice->Visible) { // Notice ?>
	<tr id="r_Notice">
		<td class="<?php echo $notices_view->TableLeftColumnClass ?>"><span id="elh_notices_Notice"><?php echo $notices->Notice->caption() ?></span></td>
		<td data-name="Notice"<?php echo $notices->Notice->cellAttributes() ?>>
<span id="el_notices_Notice">
<span<?php echo $notices->Notice->viewAttributes() ?>>
<?php echo $notices->Notice->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
	<tr id="r_NoticeDate">
		<td class="<?php echo $notices_view->TableLeftColumnClass ?>"><span id="elh_notices_NoticeDate"><?php echo $notices->NoticeDate->caption() ?></span></td>
		<td data-name="NoticeDate"<?php echo $notices->NoticeDate->cellAttributes() ?>>
<span id="el_notices_NoticeDate">
<span<?php echo $notices->NoticeDate->viewAttributes() ?>>
<?php echo $notices->NoticeDate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
	<tr id="r_NoticeTime">
		<td class="<?php echo $notices_view->TableLeftColumnClass ?>"><span id="elh_notices_NoticeTime"><?php echo $notices->NoticeTime->caption() ?></span></td>
		<td data-name="NoticeTime"<?php echo $notices->NoticeTime->cellAttributes() ?>>
<span id="el_notices_NoticeTime">
<span<?php echo $notices->NoticeTime->viewAttributes() ?>>
<?php echo $notices->NoticeTime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($notices->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $notices_view->TableLeftColumnClass ?>"><span id="elh_notices_Notes"><?php echo $notices->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $notices->Notes->cellAttributes() ?>>
<span id="el_notices_Notes">
<span<?php echo $notices->Notes->viewAttributes() ?>>
<?php echo $notices->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($notices->PostMan->Visible) { // PostMan ?>
	<tr id="r_PostMan">
		<td class="<?php echo $notices_view->TableLeftColumnClass ?>"><span id="elh_notices_PostMan"><?php echo $notices->PostMan->caption() ?></span></td>
		<td data-name="PostMan"<?php echo $notices->PostMan->cellAttributes() ?>>
<span id="el_notices_PostMan">
<span<?php echo $notices->PostMan->viewAttributes() ?>>
<?php echo $notices->PostMan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($notices->LawyerID->Visible) { // LawyerID ?>
	<tr id="r_LawyerID">
		<td class="<?php echo $notices_view->TableLeftColumnClass ?>"><span id="elh_notices_LawyerID"><?php echo $notices->LawyerID->caption() ?></span></td>
		<td data-name="LawyerID"<?php echo $notices->LawyerID->cellAttributes() ?>>
<span id="el_notices_LawyerID">
<span<?php echo $notices->LawyerID->viewAttributes() ?>>
<?php echo $notices->LawyerID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$notices_view->IsModal) { ?>
<?php if (!$notices->isExport()) { ?>
<?php if (!isset($notices_view->Pager)) $notices_view->Pager = new PrevNextPager($notices_view->StartRec, $notices_view->DisplayRecs, $notices_view->TotalRecs, $notices_view->AutoHidePager) ?>
<?php if ($notices_view->Pager->RecordCount > 0 && $notices_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($notices_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $notices_view->pageUrl() ?>start=<?php echo $notices_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($notices_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $notices_view->pageUrl() ?>start=<?php echo $notices_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $notices_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($notices_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $notices_view->pageUrl() ?>start=<?php echo $notices_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($notices_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $notices_view->pageUrl() ?>start=<?php echo $notices_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $notices_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$notices_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$notices->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$notices_view->terminate();
?>
