<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$register = new register();

// Run the page
$register->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$register->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "register";
var fregister = currentForm = new ew.Form("fregister", "register");

// Validate form
fregister.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($register->Username->Required) { ?>
			elm = this.getElements("x" + infix + "_Username");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, ew.language.phrase("EnterUserName"));
		<?php } ?>
		<?php if ($register->Password->Required) { ?>
			elm = this.getElements("x" + infix + "_Password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, ew.language.phrase("EnterPassword"));
		<?php } ?>
			if (fobj.c_Password.value != fobj.x_Password.value)
				return this.onError(fobj.c_Password, ew.language.phrase("MismatchPassword"));
		<?php if ($register->FirstName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirstName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->FirstName->caption(), $employees->FirstName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($register->MiddleName->Required) { ?>
			elm = this.getElements("x" + infix + "_MiddleName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->MiddleName->caption(), $employees->MiddleName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($register->LastName->Required) { ?>
			elm = this.getElements("x" + infix + "_LastName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->LastName->caption(), $employees->LastName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($register->BirthDate->Required) { ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->BirthDate->caption(), $employees->BirthDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($employees->BirthDate->errorMessage()) ?>");
		<?php if ($register->Gender->Required) { ?>
			elm = this.getElements("x" + infix + "_Gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->Gender->caption(), $employees->Gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($register->_Email->Required) { ?>
			elm = this.getElements("x" + infix + "__Email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employees->_Email->caption(), $employees->_Email->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
		if (grecaptcha && grecaptcha.getResponse() == "") {
			ew.alert(ew.language.phrase("ClickReCaptcha"));
			return false;
		}
	return true;
}

// Form_CustomValidate event
fregister.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fregister.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fregister.lists["x_Gender"] = <?php echo $register->Gender->Lookup->toClientList() ?>;
fregister.lists["x_Gender"].options = <?php echo JsonEncode($register->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $register->showPageHeader(); ?>
<?php
$register->showMessage();
?>
<form name="fregister" id="fregister" class="<?php echo $register->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($register->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $register->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employees">
<input type="hidden" name="action" id="action" value="insert">
<!-- Fields to prevent google autofill -->
<input type="hidden" type="text" name="<?php echo Encrypt(Random()) ?>">
<input type="hidden" type="password" name="<?php echo Encrypt(Random()) ?>">
<?php if ($employees->isConfirm()) { // Confirm page ?>
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } ?>
<?php if (!IsMobile()) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if (IsMobile()) { ?>
<div class="ew-register-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_register" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($employees->Username->Visible) { // Username ?>
<?php if (IsMobile()) { ?>
	<div id="r_Username" class="form-group row">
		<label id="elh_employees_Username" for="x_Username" class="<?php echo $register->LeftColumnClass ?>"><?php echo $employees->Username->caption() ?><?php echo ($employees->Username->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->Username->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_Username">
<input type="text" data-table="employees" data-field="x_Username" name="x_Username" id="x_Username" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->Username->getPlaceHolder()) ?>" value="<?php echo $employees->Username->EditValue ?>"<?php echo $employees->Username->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_Username">
<span<?php echo $employees->Username->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->Username->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_Username" name="x_Username" id="x_Username" value="<?php echo HtmlEncode($employees->Username->FormValue) ?>">
<?php } ?>
<?php echo $employees->Username->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Username">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_employees_Username"><?php echo $employees->Username->caption() ?><?php echo ($employees->Username->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Username->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_Username">
<input type="text" data-table="employees" data-field="x_Username" name="x_Username" id="x_Username" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->Username->getPlaceHolder()) ?>" value="<?php echo $employees->Username->EditValue ?>"<?php echo $employees->Username->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_Username">
<span<?php echo $employees->Username->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->Username->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_Username" name="x_Username" id="x_Username" value="<?php echo HtmlEncode($employees->Username->FormValue) ?>">
<?php } ?>
<?php echo $employees->Username->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Password->Visible) { // Password ?>
<?php if (IsMobile()) { ?>
	<div id="r_Password" class="form-group row">
		<label id="elh_employees_Password" for="x_Password" class="<?php echo $register->LeftColumnClass ?>"><?php echo $employees->Password->caption() ?><?php echo ($employees->Password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->Password->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_Password">
<input type="password" data-field="x_Password" name="x_Password" id="x_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employees->Password->getPlaceHolder()) ?>"<?php echo $employees->Password->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_Password">
<span<?php echo $employees->Password->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->Password->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_Password" name="x_Password" id="x_Password" value="<?php echo HtmlEncode($employees->Password->FormValue) ?>">
<?php } ?>
<?php echo $employees->Password->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Password">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_employees_Password"><?php echo $employees->Password->caption() ?><?php echo ($employees->Password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Password->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_Password">
<input type="password" data-field="x_Password" name="x_Password" id="x_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employees->Password->getPlaceHolder()) ?>"<?php echo $employees->Password->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_Password">
<span<?php echo $employees->Password->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->Password->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_Password" name="x_Password" id="x_Password" value="<?php echo HtmlEncode($employees->Password->FormValue) ?>">
<?php } ?>
<?php echo $employees->Password->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Password->Visible) { // Password ?>
<?php if (IsMobile()) { ?>
	<div id="r_c_Password" class="form-group row">
		<label id="elh_c_employees_Password" for="c_Password" class="<?php echo $register->LeftColumnClass ?>"><?php echo $Language->phrase("Confirm") ?> <?php echo $employees->Password->caption() ?><?php echo ($employees->Password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->Password->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_c_employees_Password">
<input type="password" data-field="c_Password" name="c_Password" id="c_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employees->Password->getPlaceHolder()) ?>"<?php echo $employees->Password->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_c_employees_Password">
<span<?php echo $employees->Password->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->Password->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="c_Password" name="c_Password" id="c_Password" value="<?php echo HtmlEncode($employees->Password->FormValue) ?>">
<?php } ?>
</div></div>
	</div>
<?php } else { ?>
	<tr id="r_c_Password">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_c_employees_Password" class="ew-confirm-password"><?php echo $Language->phrase("Confirm") ?> <?php echo $employees->Password->caption() ?><?php echo ($employees->Password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Password->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_c_employees_Password">
<input type="password" data-field="c_Password" name="c_Password" id="c_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employees->Password->getPlaceHolder()) ?>"<?php echo $employees->Password->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_c_employees_Password">
<span<?php echo $employees->Password->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->Password->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="c_Password" name="c_Password" id="c_Password" value="<?php echo HtmlEncode($employees->Password->FormValue) ?>">
<?php } ?>
</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->FirstName->Visible) { // FirstName ?>
<?php if (IsMobile()) { ?>
	<div id="r_FirstName" class="form-group row">
		<label id="elh_employees_FirstName" for="x_FirstName" class="<?php echo $register->LeftColumnClass ?>"><?php echo $employees->FirstName->caption() ?><?php echo ($employees->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->FirstName->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_FirstName">
<input type="text" data-table="employees" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->FirstName->getPlaceHolder()) ?>" value="<?php echo $employees->FirstName->EditValue ?>"<?php echo $employees->FirstName->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_FirstName">
<span<?php echo $employees->FirstName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->FirstName->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" value="<?php echo HtmlEncode($employees->FirstName->FormValue) ?>">
<?php } ?>
<?php echo $employees->FirstName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_employees_FirstName"><?php echo $employees->FirstName->caption() ?><?php echo ($employees->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->FirstName->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_FirstName">
<input type="text" data-table="employees" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->FirstName->getPlaceHolder()) ?>" value="<?php echo $employees->FirstName->EditValue ?>"<?php echo $employees->FirstName->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_FirstName">
<span<?php echo $employees->FirstName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->FirstName->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" value="<?php echo HtmlEncode($employees->FirstName->FormValue) ?>">
<?php } ?>
<?php echo $employees->FirstName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->MiddleName->Visible) { // MiddleName ?>
<?php if (IsMobile()) { ?>
	<div id="r_MiddleName" class="form-group row">
		<label id="elh_employees_MiddleName" for="x_MiddleName" class="<?php echo $register->LeftColumnClass ?>"><?php echo $employees->MiddleName->caption() ?><?php echo ($employees->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->MiddleName->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_MiddleName">
<input type="text" data-table="employees" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->MiddleName->getPlaceHolder()) ?>" value="<?php echo $employees->MiddleName->EditValue ?>"<?php echo $employees->MiddleName->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_MiddleName">
<span<?php echo $employees->MiddleName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->MiddleName->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" value="<?php echo HtmlEncode($employees->MiddleName->FormValue) ?>">
<?php } ?>
<?php echo $employees->MiddleName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_employees_MiddleName"><?php echo $employees->MiddleName->caption() ?><?php echo ($employees->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->MiddleName->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_MiddleName">
<input type="text" data-table="employees" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->MiddleName->getPlaceHolder()) ?>" value="<?php echo $employees->MiddleName->EditValue ?>"<?php echo $employees->MiddleName->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_MiddleName">
<span<?php echo $employees->MiddleName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->MiddleName->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" value="<?php echo HtmlEncode($employees->MiddleName->FormValue) ?>">
<?php } ?>
<?php echo $employees->MiddleName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->LastName->Visible) { // LastName ?>
<?php if (IsMobile()) { ?>
	<div id="r_LastName" class="form-group row">
		<label id="elh_employees_LastName" for="x_LastName" class="<?php echo $register->LeftColumnClass ?>"><?php echo $employees->LastName->caption() ?><?php echo ($employees->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->LastName->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_LastName">
<input type="text" data-table="employees" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->LastName->getPlaceHolder()) ?>" value="<?php echo $employees->LastName->EditValue ?>"<?php echo $employees->LastName->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_LastName">
<span<?php echo $employees->LastName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->LastName->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_LastName" name="x_LastName" id="x_LastName" value="<?php echo HtmlEncode($employees->LastName->FormValue) ?>">
<?php } ?>
<?php echo $employees->LastName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_employees_LastName"><?php echo $employees->LastName->caption() ?><?php echo ($employees->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->LastName->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_LastName">
<input type="text" data-table="employees" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($employees->LastName->getPlaceHolder()) ?>" value="<?php echo $employees->LastName->EditValue ?>"<?php echo $employees->LastName->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees_LastName">
<span<?php echo $employees->LastName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->LastName->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_LastName" name="x_LastName" id="x_LastName" value="<?php echo HtmlEncode($employees->LastName->FormValue) ?>">
<?php } ?>
<?php echo $employees->LastName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->BirthDate->Visible) { // BirthDate ?>
<?php if (IsMobile()) { ?>
	<div id="r_BirthDate" class="form-group row">
		<label id="elh_employees_BirthDate" for="x_BirthDate" class="<?php echo $register->LeftColumnClass ?>"><?php echo $employees->BirthDate->caption() ?><?php echo ($employees->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->BirthDate->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_BirthDate">
<input type="text" data-table="employees" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($employees->BirthDate->getPlaceHolder()) ?>" value="<?php echo $employees->BirthDate->EditValue ?>"<?php echo $employees->BirthDate->editAttributes() ?>>
<?php if (!$employees->BirthDate->ReadOnly && !$employees->BirthDate->Disabled && !isset($employees->BirthDate->EditAttrs["readonly"]) && !isset($employees->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fregister", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_employees_BirthDate">
<span<?php echo $employees->BirthDate->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->BirthDate->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" value="<?php echo HtmlEncode($employees->BirthDate->FormValue) ?>">
<?php } ?>
<?php echo $employees->BirthDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_employees_BirthDate"><?php echo $employees->BirthDate->caption() ?><?php echo ($employees->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->BirthDate->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_BirthDate">
<input type="text" data-table="employees" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($employees->BirthDate->getPlaceHolder()) ?>" value="<?php echo $employees->BirthDate->EditValue ?>"<?php echo $employees->BirthDate->editAttributes() ?>>
<?php if (!$employees->BirthDate->ReadOnly && !$employees->BirthDate->Disabled && !isset($employees->BirthDate->EditAttrs["readonly"]) && !isset($employees->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fregister", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_employees_BirthDate">
<span<?php echo $employees->BirthDate->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->BirthDate->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" value="<?php echo HtmlEncode($employees->BirthDate->FormValue) ?>">
<?php } ?>
<?php echo $employees->BirthDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->Gender->Visible) { // Gender ?>
<?php if (IsMobile()) { ?>
	<div id="r_Gender" class="form-group row">
		<label id="elh_employees_Gender" class="<?php echo $register->LeftColumnClass ?>"><?php echo $employees->Gender->caption() ?><?php echo ($employees->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->Gender->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="employees" data-field="x_Gender" data-value-separator="<?php echo $employees->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $employees->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employees->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php } else { ?>
<span id="el_employees_Gender">
<span<?php echo $employees->Gender->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->Gender->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_Gender" name="x_Gender" id="x_Gender" value="<?php echo HtmlEncode($employees->Gender->FormValue) ?>">
<?php } ?>
<?php echo $employees->Gender->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Gender">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_employees_Gender"><?php echo $employees->Gender->caption() ?><?php echo ($employees->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->Gender->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="employees" data-field="x_Gender" data-value-separator="<?php echo $employees->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $employees->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employees->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php } else { ?>
<span id="el_employees_Gender">
<span<?php echo $employees->Gender->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->Gender->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x_Gender" name="x_Gender" id="x_Gender" value="<?php echo HtmlEncode($employees->Gender->FormValue) ?>">
<?php } ?>
<?php echo $employees->Gender->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($employees->_Email->Visible) { // Email ?>
<?php if (IsMobile()) { ?>
	<div id="r__Email" class="form-group row">
		<label id="elh_employees__Email" for="x__Email" class="<?php echo $register->LeftColumnClass ?>"><?php echo $employees->_Email->caption() ?><?php echo ($employees->_Email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $employees->_Email->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees__Email">
<input type="text" data-table="employees" data-field="x__Email" name="x__Email" id="x__Email" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employees->_Email->getPlaceHolder()) ?>" value="<?php echo $employees->_Email->EditValue ?>"<?php echo $employees->_Email->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees__Email">
<span<?php echo $employees->_Email->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->_Email->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x__Email" name="x__Email" id="x__Email" value="<?php echo HtmlEncode($employees->_Email->FormValue) ?>">
<?php } ?>
<?php echo $employees->_Email->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r__Email">
		<td class="<?php echo $register->TableLeftColumnClass ?>"><span id="elh_employees__Email"><?php echo $employees->_Email->caption() ?><?php echo ($employees->_Email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $employees->_Email->cellAttributes() ?>>
<?php if (!$employees->isConfirm()) { ?>
<span id="el_employees__Email">
<input type="text" data-table="employees" data-field="x__Email" name="x__Email" id="x__Email" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($employees->_Email->getPlaceHolder()) ?>" value="<?php echo $employees->_Email->EditValue ?>"<?php echo $employees->_Email->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_employees__Email">
<span<?php echo $employees->_Email->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($employees->_Email->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="employees" data-field="x__Email" name="x__Email" id="x__Email" value="<?php echo HtmlEncode($employees->_Email->FormValue) ?>">
<?php } ?>
<?php echo $employees->_Email->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if (IsMobile()) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$employees->isConfirm()) { ?>
<!-- captcha html (begin) -->
<div class="form-group row ew-captcha">
	<div class="col-sm-10 offset-sm-2">
	<div class="g-recaptcha"></div>
	</div>
</div>
<?php } else { ?>
<input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response" value="<?php echo $register->Captcha ?>">
<?php } ?>
<!-- captcha html (end) -->
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $register->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$employees->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("RegisterBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php if (!IsMobile()) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$register->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$register->terminate();
?>
