<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sections_add = new sections_add();

// Run the page
$sections_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sections_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fsectionsadd = currentForm = new ew.Form("fsectionsadd", "add");

// Validate form
fsectionsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sections_add->Section->Required) { ?>
			elm = this.getElements("x" + infix + "_Section");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->Section->caption(), $sections->Section->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sections_add->SectionEn->Required) { ?>
			elm = this.getElements("x" + infix + "_SectionEn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->SectionEn->caption(), $sections->SectionEn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sections_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->Notes->caption(), $sections->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsectionsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsectionsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sections_add->showPageHeader(); ?>
<?php
$sections_add->showMessage();
?>
<form name="fsectionsadd" id="fsectionsadd" class="<?php echo $sections_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sections_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sections_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sections">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$sections_add->IsModal ?>">
<?php if (!$sections_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($sections_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_sectionsadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($sections->Section->Visible) { // Section ?>
<?php if ($sections_add->IsMobileOrModal) { ?>
	<div id="r_Section" class="form-group row">
		<label id="elh_sections_Section" for="x_Section" class="<?php echo $sections_add->LeftColumnClass ?>"><?php echo $sections->Section->caption() ?><?php echo ($sections->Section->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sections_add->RightColumnClass ?>"><div<?php echo $sections->Section->cellAttributes() ?>>
<span id="el_sections_Section">
<input type="text" data-table="sections" data-field="x_Section" name="x_Section" id="x_Section" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->Section->getPlaceHolder()) ?>" value="<?php echo $sections->Section->EditValue ?>"<?php echo $sections->Section->editAttributes() ?>>
</span>
<?php echo $sections->Section->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Section">
		<td class="<?php echo $sections_add->TableLeftColumnClass ?>"><span id="elh_sections_Section"><?php echo $sections->Section->caption() ?><?php echo ($sections->Section->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $sections->Section->cellAttributes() ?>>
<span id="el_sections_Section">
<input type="text" data-table="sections" data-field="x_Section" name="x_Section" id="x_Section" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->Section->getPlaceHolder()) ?>" value="<?php echo $sections->Section->EditValue ?>"<?php echo $sections->Section->editAttributes() ?>>
</span>
<?php echo $sections->Section->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($sections->SectionEn->Visible) { // SectionEn ?>
<?php if ($sections_add->IsMobileOrModal) { ?>
	<div id="r_SectionEn" class="form-group row">
		<label id="elh_sections_SectionEn" for="x_SectionEn" class="<?php echo $sections_add->LeftColumnClass ?>"><?php echo $sections->SectionEn->caption() ?><?php echo ($sections->SectionEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sections_add->RightColumnClass ?>"><div<?php echo $sections->SectionEn->cellAttributes() ?>>
<span id="el_sections_SectionEn">
<input type="text" data-table="sections" data-field="x_SectionEn" name="x_SectionEn" id="x_SectionEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->SectionEn->getPlaceHolder()) ?>" value="<?php echo $sections->SectionEn->EditValue ?>"<?php echo $sections->SectionEn->editAttributes() ?>>
</span>
<?php echo $sections->SectionEn->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_SectionEn">
		<td class="<?php echo $sections_add->TableLeftColumnClass ?>"><span id="elh_sections_SectionEn"><?php echo $sections->SectionEn->caption() ?><?php echo ($sections->SectionEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $sections->SectionEn->cellAttributes() ?>>
<span id="el_sections_SectionEn">
<input type="text" data-table="sections" data-field="x_SectionEn" name="x_SectionEn" id="x_SectionEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->SectionEn->getPlaceHolder()) ?>" value="<?php echo $sections->SectionEn->EditValue ?>"<?php echo $sections->SectionEn->editAttributes() ?>>
</span>
<?php echo $sections->SectionEn->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($sections->Notes->Visible) { // Notes ?>
<?php if ($sections_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_sections_Notes" for="x_Notes" class="<?php echo $sections_add->LeftColumnClass ?>"><?php echo $sections->Notes->caption() ?><?php echo ($sections->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sections_add->RightColumnClass ?>"><div<?php echo $sections->Notes->cellAttributes() ?>>
<span id="el_sections_Notes">
<textarea data-table="sections" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sections->Notes->getPlaceHolder()) ?>"<?php echo $sections->Notes->editAttributes() ?>><?php echo $sections->Notes->EditValue ?></textarea>
</span>
<?php echo $sections->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $sections_add->TableLeftColumnClass ?>"><span id="elh_sections_Notes"><?php echo $sections->Notes->caption() ?><?php echo ($sections->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $sections->Notes->cellAttributes() ?>>
<span id="el_sections_Notes">
<textarea data-table="sections" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sections->Notes->getPlaceHolder()) ?>"<?php echo $sections->Notes->editAttributes() ?>><?php echo $sections->Notes->EditValue ?></textarea>
</span>
<?php echo $sections->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($sections_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$sections_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sections_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $sections_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$sections_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$sections_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sections_add->terminate();
?>
