<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sections_list = new sections_list();

// Run the page
$sections_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sections_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sections->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsectionslist = currentForm = new ew.Form("fsectionslist", "list");
fsectionslist.formKeyCountName = '<?php echo $sections_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsectionslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsectionslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fsectionslistsrch = currentSearchForm = new ew.Form("fsectionslistsrch");

// Filters
fsectionslistsrch.filterList = <?php echo $sections_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sections->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sections_list->TotalRecs > 0 && $sections_list->ExportOptions->visible()) { ?>
<?php $sections_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sections_list->ImportOptions->visible()) { ?>
<?php $sections_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sections_list->SearchOptions->visible()) { ?>
<?php $sections_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sections_list->FilterOptions->visible()) { ?>
<?php $sections_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sections_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sections->isExport() && !$sections->CurrentAction) { ?>
<form name="fsectionslistsrch" id="fsectionslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sections_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fsectionslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sections">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sections_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sections_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sections_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sections_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sections_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sections_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sections_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sections_list->showPageHeader(); ?>
<?php
$sections_list->showMessage();
?>
<?php if ($sections_list->TotalRecs > 0 || $sections->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sections_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sections">
<?php if (!$sections->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sections->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sections_list->Pager)) $sections_list->Pager = new PrevNextPager($sections_list->StartRec, $sections_list->DisplayRecs, $sections_list->TotalRecs, $sections_list->AutoHidePager) ?>
<?php if ($sections_list->Pager->RecordCount > 0 && $sections_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sections_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sections_list->pageUrl() ?>start=<?php echo $sections_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sections_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sections_list->pageUrl() ?>start=<?php echo $sections_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sections_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sections_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sections_list->pageUrl() ?>start=<?php echo $sections_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sections_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sections_list->pageUrl() ?>start=<?php echo $sections_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sections_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sections_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sections_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sections_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sections_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sections_list->TotalRecs > 0 && (!$sections_list->AutoHidePageSizeSelector || $sections_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sections">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($sections_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($sections_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sections_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($sections_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($sections_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($sections_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sections_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($sections_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($sections_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($sections->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sections_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsectionslist" id="fsectionslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sections_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sections_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sections">
<div id="gmp_sections" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sections_list->TotalRecs > 0 || $sections->isGridEdit()) { ?>
<table id="tbl_sectionslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sections_list->RowType = ROWTYPE_HEADER;

// Render list options
$sections_list->renderListOptions();

// Render list options (header, left)
$sections_list->ListOptions->render("header", "left");
?>
<?php if ($sections->Section->Visible) { // Section ?>
	<?php if ($sections->sortUrl($sections->Section) == "") { ?>
		<th data-name="Section" class="<?php echo $sections->Section->headerCellClass() ?>"><div id="elh_sections_Section" class="sections_Section"><div class="ew-table-header-caption"><?php echo $sections->Section->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Section" class="<?php echo $sections->Section->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sections->SortUrl($sections->Section) ?>',2);"><div id="elh_sections_Section" class="sections_Section">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sections->Section->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sections->Section->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sections->Section->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sections->SectionEn->Visible) { // SectionEn ?>
	<?php if ($sections->sortUrl($sections->SectionEn) == "") { ?>
		<th data-name="SectionEn" class="<?php echo $sections->SectionEn->headerCellClass() ?>"><div id="elh_sections_SectionEn" class="sections_SectionEn"><div class="ew-table-header-caption"><?php echo $sections->SectionEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SectionEn" class="<?php echo $sections->SectionEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sections->SortUrl($sections->SectionEn) ?>',2);"><div id="elh_sections_SectionEn" class="sections_SectionEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sections->SectionEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sections->SectionEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sections->SectionEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sections_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sections->ExportAll && $sections->isExport()) {
	$sections_list->StopRec = $sections_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sections_list->TotalRecs > $sections_list->StartRec + $sections_list->DisplayRecs - 1)
		$sections_list->StopRec = $sections_list->StartRec + $sections_list->DisplayRecs - 1;
	else
		$sections_list->StopRec = $sections_list->TotalRecs;
}
$sections_list->RecCnt = $sections_list->StartRec - 1;
if ($sections_list->Recordset && !$sections_list->Recordset->EOF) {
	$sections_list->Recordset->moveFirst();
	$selectLimit = $sections_list->UseSelectLimit;
	if (!$selectLimit && $sections_list->StartRec > 1)
		$sections_list->Recordset->move($sections_list->StartRec - 1);
} elseif (!$sections->AllowAddDeleteRow && $sections_list->StopRec == 0) {
	$sections_list->StopRec = $sections->GridAddRowCount;
}

// Initialize aggregate
$sections->RowType = ROWTYPE_AGGREGATEINIT;
$sections->resetAttributes();
$sections_list->renderRow();
while ($sections_list->RecCnt < $sections_list->StopRec) {
	$sections_list->RecCnt++;
	if ($sections_list->RecCnt >= $sections_list->StartRec) {
		$sections_list->RowCnt++;

		// Set up key count
		$sections_list->KeyCount = $sections_list->RowIndex;

		// Init row class and style
		$sections->resetAttributes();
		$sections->CssClass = "";
		if ($sections->isGridAdd()) {
		} else {
			$sections_list->loadRowValues($sections_list->Recordset); // Load row values
		}
		$sections->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sections->RowAttrs = array_merge($sections->RowAttrs, array('data-rowindex'=>$sections_list->RowCnt, 'id'=>'r' . $sections_list->RowCnt . '_sections', 'data-rowtype'=>$sections->RowType));

		// Render row
		$sections_list->renderRow();

		// Render list options
		$sections_list->renderListOptions();
?>
	<tr<?php echo $sections->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sections_list->ListOptions->render("body", "left", $sections_list->RowCnt);
?>
	<?php if ($sections->Section->Visible) { // Section ?>
		<td data-name="Section"<?php echo $sections->Section->cellAttributes() ?>>
<span id="el<?php echo $sections_list->RowCnt ?>_sections_Section" class="sections_Section">
<span<?php echo $sections->Section->viewAttributes() ?>>
<?php echo $sections->Section->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sections->SectionEn->Visible) { // SectionEn ?>
		<td data-name="SectionEn"<?php echo $sections->SectionEn->cellAttributes() ?>>
<span id="el<?php echo $sections_list->RowCnt ?>_sections_SectionEn" class="sections_SectionEn">
<span<?php echo $sections->SectionEn->viewAttributes() ?>>
<?php echo $sections->SectionEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sections_list->ListOptions->render("body", "right", $sections_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sections->isGridAdd())
		$sections_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sections->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sections_list->Recordset)
	$sections_list->Recordset->Close();
?>
<?php if (!$sections->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sections->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sections_list->Pager)) $sections_list->Pager = new PrevNextPager($sections_list->StartRec, $sections_list->DisplayRecs, $sections_list->TotalRecs, $sections_list->AutoHidePager) ?>
<?php if ($sections_list->Pager->RecordCount > 0 && $sections_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sections_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sections_list->pageUrl() ?>start=<?php echo $sections_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sections_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sections_list->pageUrl() ?>start=<?php echo $sections_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sections_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sections_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sections_list->pageUrl() ?>start=<?php echo $sections_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sections_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sections_list->pageUrl() ?>start=<?php echo $sections_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sections_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sections_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sections_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sections_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sections_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sections_list->TotalRecs > 0 && (!$sections_list->AutoHidePageSizeSelector || $sections_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sections">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($sections_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($sections_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sections_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($sections_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($sections_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($sections_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sections_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($sections_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($sections_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($sections->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sections_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sections_list->TotalRecs == 0 && !$sections->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sections_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sections_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sections->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sections->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sections", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sections_list->terminate();
?>
