<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$users_edit = new users_edit();

// Run the page
$users_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$users_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fusersedit = currentForm = new ew.Form("fusersedit", "edit");

// Validate form
fusersedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($users_edit->_UserID->Required) { ?>
			elm = this.getElements("x" + infix + "__UserID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->_UserID->caption(), $users->_UserID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Username->Required) { ?>
			elm = this.getElements("x" + infix + "_Username");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Username->caption(), $users->Username->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Password->Required) { ?>
			elm = this.getElements("x" + infix + "_Password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Password->caption(), $users->Password->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->LastName->Required) { ?>
			elm = this.getElements("x" + infix + "_LastName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->LastName->caption(), $users->LastName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->FirstName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirstName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->FirstName->caption(), $users->FirstName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Title->Required) { ?>
			elm = this.getElements("x" + infix + "_Title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Title->caption(), $users->Title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->TitleOfCourtesy->Required) { ?>
			elm = this.getElements("x" + infix + "_TitleOfCourtesy");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->TitleOfCourtesy->caption(), $users->TitleOfCourtesy->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->BirthDate->Required) { ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->BirthDate->caption(), $users->BirthDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($users->BirthDate->errorMessage()) ?>");
		<?php if ($users_edit->HireDate->Required) { ?>
			elm = this.getElements("x" + infix + "_HireDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->HireDate->caption(), $users->HireDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_HireDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($users->HireDate->errorMessage()) ?>");
		<?php if ($users_edit->Address->Required) { ?>
			elm = this.getElements("x" + infix + "_Address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Address->caption(), $users->Address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->City->Required) { ?>
			elm = this.getElements("x" + infix + "_City");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->City->caption(), $users->City->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Region->Required) { ?>
			elm = this.getElements("x" + infix + "_Region");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Region->caption(), $users->Region->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->PostalCode->Required) { ?>
			elm = this.getElements("x" + infix + "_PostalCode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->PostalCode->caption(), $users->PostalCode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Country->Required) { ?>
			elm = this.getElements("x" + infix + "_Country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Country->caption(), $users->Country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->HomePhone->Required) { ?>
			elm = this.getElements("x" + infix + "_HomePhone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->HomePhone->caption(), $users->HomePhone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Extension->Required) { ?>
			elm = this.getElements("x" + infix + "_Extension");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Extension->caption(), $users->Extension->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->_Email->Required) { ?>
			elm = this.getElements("x" + infix + "__Email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->_Email->caption(), $users->_Email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Photo->Required) { ?>
			felm = this.getElements("x" + infix + "_Photo");
			elm = this.getElements("fn_x" + infix + "_Photo");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $users->Photo->caption(), $users->Photo->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Notes->caption(), $users->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->ReportsTo->Required) { ?>
			elm = this.getElements("x" + infix + "_ReportsTo");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->ReportsTo->caption(), $users->ReportsTo->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ReportsTo");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($users->ReportsTo->errorMessage()) ?>");
		<?php if ($users_edit->UserLevel->Required) { ?>
			elm = this.getElements("x" + infix + "_UserLevel");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->UserLevel->caption(), $users->UserLevel->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_UserLevel");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($users->UserLevel->errorMessage()) ?>");
		<?php if ($users_edit->Activated->Required) { ?>
			elm = this.getElements("x" + infix + "_Activated[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Activated->caption(), $users->Activated->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Profile->Required) { ?>
			elm = this.getElements("x" + infix + "_Profile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Profile->caption(), $users->Profile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Type->Required) { ?>
			elm = this.getElements("x" + infix + "_Type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Type->caption(), $users->Type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Gender->Required) { ?>
			elm = this.getElements("x" + infix + "_Gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Gender->caption(), $users->Gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->MobilePhone->Required) { ?>
			elm = this.getElements("x" + infix + "_MobilePhone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->MobilePhone->caption(), $users->MobilePhone->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_MobilePhone");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($users->MobilePhone->errorMessage()) ?>");
		<?php if ($users_edit->Address2->Required) { ?>
			elm = this.getElements("x" + infix + "_Address2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Address2->caption(), $users->Address2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Locked->Required) { ?>
			elm = this.getElements("x" + infix + "_Locked[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Locked->caption(), $users->Locked->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Theme->Required) { ?>
			elm = this.getElements("x" + infix + "_Theme");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Theme->caption(), $users->Theme->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Menu_Horizontal->Required) { ?>
			elm = this.getElements("x" + infix + "_Menu_Horizontal[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Menu_Horizontal->caption(), $users->Menu_Horizontal->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->_Language->Required) { ?>
			elm = this.getElements("x" + infix + "__Language");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->_Language->caption(), $users->_Language->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($users_edit->Current_URL->Required) { ?>
			elm = this.getElements("x" + infix + "_Current_URL");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $users->Current_URL->caption(), $users->Current_URL->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fusersedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fusersedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fusersedit.lists["x_Activated[]"] = <?php echo $users_edit->Activated->Lookup->toClientList() ?>;
fusersedit.lists["x_Activated[]"].options = <?php echo JsonEncode($users_edit->Activated->options(FALSE, TRUE)) ?>;
fusersedit.lists["x_Type"] = <?php echo $users_edit->Type->Lookup->toClientList() ?>;
fusersedit.lists["x_Type"].options = <?php echo JsonEncode($users_edit->Type->options(FALSE, TRUE)) ?>;
fusersedit.lists["x_Gender"] = <?php echo $users_edit->Gender->Lookup->toClientList() ?>;
fusersedit.lists["x_Gender"].options = <?php echo JsonEncode($users_edit->Gender->options(FALSE, TRUE)) ?>;
fusersedit.lists["x_Locked[]"] = <?php echo $users_edit->Locked->Lookup->toClientList() ?>;
fusersedit.lists["x_Locked[]"].options = <?php echo JsonEncode($users_edit->Locked->options(FALSE, TRUE)) ?>;
fusersedit.lists["x_Menu_Horizontal[]"] = <?php echo $users_edit->Menu_Horizontal->Lookup->toClientList() ?>;
fusersedit.lists["x_Menu_Horizontal[]"].options = <?php echo JsonEncode($users_edit->Menu_Horizontal->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $users_edit->showPageHeader(); ?>
<?php
$users_edit->showMessage();
?>
<?php if (!$users_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($users_edit->Pager)) $users_edit->Pager = new PrevNextPager($users_edit->StartRec, $users_edit->DisplayRecs, $users_edit->TotalRecs, $users_edit->AutoHidePager) ?>
<?php if ($users_edit->Pager->RecordCount > 0 && $users_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($users_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $users_edit->pageUrl() ?>start=<?php echo $users_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($users_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $users_edit->pageUrl() ?>start=<?php echo $users_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $users_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($users_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $users_edit->pageUrl() ?>start=<?php echo $users_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($users_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $users_edit->pageUrl() ?>start=<?php echo $users_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $users_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fusersedit" id="fusersedit" class="<?php echo $users_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($users_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $users_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="users">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$users_edit->IsModal ?>">
<?php if (!$users_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_usersedit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($users->_UserID->Visible) { // UserID ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r__UserID" class="form-group row">
		<label id="elh_users__UserID" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->_UserID->caption() ?><?php echo ($users->_UserID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->_UserID->cellAttributes() ?>>
<span id="el_users__UserID">
<span<?php echo $users->_UserID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($users->_UserID->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="users" data-field="x__UserID" name="x__UserID" id="x__UserID" value="<?php echo HtmlEncode($users->_UserID->CurrentValue) ?>">
<?php echo $users->_UserID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r__UserID">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users__UserID"><?php echo $users->_UserID->caption() ?><?php echo ($users->_UserID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->_UserID->cellAttributes() ?>>
<span id="el_users__UserID">
<span<?php echo $users->_UserID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($users->_UserID->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="users" data-field="x__UserID" name="x__UserID" id="x__UserID" value="<?php echo HtmlEncode($users->_UserID->CurrentValue) ?>">
<?php echo $users->_UserID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Username->Visible) { // Username ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Username" class="form-group row">
		<label id="elh_users_Username" for="x_Username" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Username->caption() ?><?php echo ($users->Username->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Username->cellAttributes() ?>>
<span id="el_users_Username">
<input type="text" data-table="users" data-field="x_Username" name="x_Username" id="x_Username" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($users->Username->getPlaceHolder()) ?>" value="<?php echo $users->Username->EditValue ?>"<?php echo $users->Username->editAttributes() ?>>
</span>
<?php echo $users->Username->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Username">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Username"><?php echo $users->Username->caption() ?><?php echo ($users->Username->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Username->cellAttributes() ?>>
<span id="el_users_Username">
<input type="text" data-table="users" data-field="x_Username" name="x_Username" id="x_Username" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($users->Username->getPlaceHolder()) ?>" value="<?php echo $users->Username->EditValue ?>"<?php echo $users->Username->editAttributes() ?>>
</span>
<?php echo $users->Username->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Password->Visible) { // Password ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Password" class="form-group row">
		<label id="elh_users_Password" for="x_Password" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Password->caption() ?><?php echo ($users->Password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Password->cellAttributes() ?>>
<span id="el_users_Password">
<input type="text" data-table="users" data-field="x_Password" name="x_Password" id="x_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($users->Password->getPlaceHolder()) ?>" value="<?php echo $users->Password->EditValue ?>"<?php echo $users->Password->editAttributes() ?>>
</span>
<?php echo $users->Password->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Password">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Password"><?php echo $users->Password->caption() ?><?php echo ($users->Password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Password->cellAttributes() ?>>
<span id="el_users_Password">
<input type="text" data-table="users" data-field="x_Password" name="x_Password" id="x_Password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($users->Password->getPlaceHolder()) ?>" value="<?php echo $users->Password->EditValue ?>"<?php echo $users->Password->editAttributes() ?>>
</span>
<?php echo $users->Password->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->LastName->Visible) { // LastName ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_LastName" class="form-group row">
		<label id="elh_users_LastName" for="x_LastName" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->LastName->caption() ?><?php echo ($users->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->LastName->cellAttributes() ?>>
<span id="el_users_LastName">
<input type="text" data-table="users" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($users->LastName->getPlaceHolder()) ?>" value="<?php echo $users->LastName->EditValue ?>"<?php echo $users->LastName->editAttributes() ?>>
</span>
<?php echo $users->LastName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_LastName"><?php echo $users->LastName->caption() ?><?php echo ($users->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->LastName->cellAttributes() ?>>
<span id="el_users_LastName">
<input type="text" data-table="users" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($users->LastName->getPlaceHolder()) ?>" value="<?php echo $users->LastName->EditValue ?>"<?php echo $users->LastName->editAttributes() ?>>
</span>
<?php echo $users->LastName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->FirstName->Visible) { // FirstName ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_FirstName" class="form-group row">
		<label id="elh_users_FirstName" for="x_FirstName" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->FirstName->caption() ?><?php echo ($users->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->FirstName->cellAttributes() ?>>
<span id="el_users_FirstName">
<input type="text" data-table="users" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($users->FirstName->getPlaceHolder()) ?>" value="<?php echo $users->FirstName->EditValue ?>"<?php echo $users->FirstName->editAttributes() ?>>
</span>
<?php echo $users->FirstName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_FirstName"><?php echo $users->FirstName->caption() ?><?php echo ($users->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->FirstName->cellAttributes() ?>>
<span id="el_users_FirstName">
<input type="text" data-table="users" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($users->FirstName->getPlaceHolder()) ?>" value="<?php echo $users->FirstName->EditValue ?>"<?php echo $users->FirstName->editAttributes() ?>>
</span>
<?php echo $users->FirstName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Title->Visible) { // Title ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Title" class="form-group row">
		<label id="elh_users_Title" for="x_Title" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Title->caption() ?><?php echo ($users->Title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Title->cellAttributes() ?>>
<span id="el_users_Title">
<input type="text" data-table="users" data-field="x_Title" name="x_Title" id="x_Title" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($users->Title->getPlaceHolder()) ?>" value="<?php echo $users->Title->EditValue ?>"<?php echo $users->Title->editAttributes() ?>>
</span>
<?php echo $users->Title->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Title">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Title"><?php echo $users->Title->caption() ?><?php echo ($users->Title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Title->cellAttributes() ?>>
<span id="el_users_Title">
<input type="text" data-table="users" data-field="x_Title" name="x_Title" id="x_Title" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($users->Title->getPlaceHolder()) ?>" value="<?php echo $users->Title->EditValue ?>"<?php echo $users->Title->editAttributes() ?>>
</span>
<?php echo $users->Title->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->TitleOfCourtesy->Visible) { // TitleOfCourtesy ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_TitleOfCourtesy" class="form-group row">
		<label id="elh_users_TitleOfCourtesy" for="x_TitleOfCourtesy" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->TitleOfCourtesy->caption() ?><?php echo ($users->TitleOfCourtesy->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->TitleOfCourtesy->cellAttributes() ?>>
<span id="el_users_TitleOfCourtesy">
<input type="text" data-table="users" data-field="x_TitleOfCourtesy" name="x_TitleOfCourtesy" id="x_TitleOfCourtesy" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($users->TitleOfCourtesy->getPlaceHolder()) ?>" value="<?php echo $users->TitleOfCourtesy->EditValue ?>"<?php echo $users->TitleOfCourtesy->editAttributes() ?>>
</span>
<?php echo $users->TitleOfCourtesy->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_TitleOfCourtesy">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_TitleOfCourtesy"><?php echo $users->TitleOfCourtesy->caption() ?><?php echo ($users->TitleOfCourtesy->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->TitleOfCourtesy->cellAttributes() ?>>
<span id="el_users_TitleOfCourtesy">
<input type="text" data-table="users" data-field="x_TitleOfCourtesy" name="x_TitleOfCourtesy" id="x_TitleOfCourtesy" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($users->TitleOfCourtesy->getPlaceHolder()) ?>" value="<?php echo $users->TitleOfCourtesy->EditValue ?>"<?php echo $users->TitleOfCourtesy->editAttributes() ?>>
</span>
<?php echo $users->TitleOfCourtesy->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->BirthDate->Visible) { // BirthDate ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_BirthDate" class="form-group row">
		<label id="elh_users_BirthDate" for="x_BirthDate" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->BirthDate->caption() ?><?php echo ($users->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->BirthDate->cellAttributes() ?>>
<span id="el_users_BirthDate">
<input type="text" data-table="users" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($users->BirthDate->getPlaceHolder()) ?>" value="<?php echo $users->BirthDate->EditValue ?>"<?php echo $users->BirthDate->editAttributes() ?>>
<?php if (!$users->BirthDate->ReadOnly && !$users->BirthDate->Disabled && !isset($users->BirthDate->EditAttrs["readonly"]) && !isset($users->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fusersedit", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $users->BirthDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_BirthDate"><?php echo $users->BirthDate->caption() ?><?php echo ($users->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->BirthDate->cellAttributes() ?>>
<span id="el_users_BirthDate">
<input type="text" data-table="users" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($users->BirthDate->getPlaceHolder()) ?>" value="<?php echo $users->BirthDate->EditValue ?>"<?php echo $users->BirthDate->editAttributes() ?>>
<?php if (!$users->BirthDate->ReadOnly && !$users->BirthDate->Disabled && !isset($users->BirthDate->EditAttrs["readonly"]) && !isset($users->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fusersedit", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $users->BirthDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->HireDate->Visible) { // HireDate ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_HireDate" class="form-group row">
		<label id="elh_users_HireDate" for="x_HireDate" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->HireDate->caption() ?><?php echo ($users->HireDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->HireDate->cellAttributes() ?>>
<span id="el_users_HireDate">
<input type="text" data-table="users" data-field="x_HireDate" name="x_HireDate" id="x_HireDate" placeholder="<?php echo HtmlEncode($users->HireDate->getPlaceHolder()) ?>" value="<?php echo $users->HireDate->EditValue ?>"<?php echo $users->HireDate->editAttributes() ?>>
<?php if (!$users->HireDate->ReadOnly && !$users->HireDate->Disabled && !isset($users->HireDate->EditAttrs["readonly"]) && !isset($users->HireDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fusersedit", "x_HireDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $users->HireDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_HireDate">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_HireDate"><?php echo $users->HireDate->caption() ?><?php echo ($users->HireDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->HireDate->cellAttributes() ?>>
<span id="el_users_HireDate">
<input type="text" data-table="users" data-field="x_HireDate" name="x_HireDate" id="x_HireDate" placeholder="<?php echo HtmlEncode($users->HireDate->getPlaceHolder()) ?>" value="<?php echo $users->HireDate->EditValue ?>"<?php echo $users->HireDate->editAttributes() ?>>
<?php if (!$users->HireDate->ReadOnly && !$users->HireDate->Disabled && !isset($users->HireDate->EditAttrs["readonly"]) && !isset($users->HireDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fusersedit", "x_HireDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $users->HireDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Address->Visible) { // Address ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Address" class="form-group row">
		<label id="elh_users_Address" for="x_Address" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Address->caption() ?><?php echo ($users->Address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Address->cellAttributes() ?>>
<span id="el_users_Address">
<input type="text" data-table="users" data-field="x_Address" name="x_Address" id="x_Address" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($users->Address->getPlaceHolder()) ?>" value="<?php echo $users->Address->EditValue ?>"<?php echo $users->Address->editAttributes() ?>>
</span>
<?php echo $users->Address->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Address">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Address"><?php echo $users->Address->caption() ?><?php echo ($users->Address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Address->cellAttributes() ?>>
<span id="el_users_Address">
<input type="text" data-table="users" data-field="x_Address" name="x_Address" id="x_Address" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($users->Address->getPlaceHolder()) ?>" value="<?php echo $users->Address->EditValue ?>"<?php echo $users->Address->editAttributes() ?>>
</span>
<?php echo $users->Address->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->City->Visible) { // City ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_City" class="form-group row">
		<label id="elh_users_City" for="x_City" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->City->caption() ?><?php echo ($users->City->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->City->cellAttributes() ?>>
<span id="el_users_City">
<input type="text" data-table="users" data-field="x_City" name="x_City" id="x_City" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($users->City->getPlaceHolder()) ?>" value="<?php echo $users->City->EditValue ?>"<?php echo $users->City->editAttributes() ?>>
</span>
<?php echo $users->City->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_City">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_City"><?php echo $users->City->caption() ?><?php echo ($users->City->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->City->cellAttributes() ?>>
<span id="el_users_City">
<input type="text" data-table="users" data-field="x_City" name="x_City" id="x_City" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($users->City->getPlaceHolder()) ?>" value="<?php echo $users->City->EditValue ?>"<?php echo $users->City->editAttributes() ?>>
</span>
<?php echo $users->City->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Region->Visible) { // Region ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Region" class="form-group row">
		<label id="elh_users_Region" for="x_Region" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Region->caption() ?><?php echo ($users->Region->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Region->cellAttributes() ?>>
<span id="el_users_Region">
<input type="text" data-table="users" data-field="x_Region" name="x_Region" id="x_Region" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($users->Region->getPlaceHolder()) ?>" value="<?php echo $users->Region->EditValue ?>"<?php echo $users->Region->editAttributes() ?>>
</span>
<?php echo $users->Region->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Region">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Region"><?php echo $users->Region->caption() ?><?php echo ($users->Region->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Region->cellAttributes() ?>>
<span id="el_users_Region">
<input type="text" data-table="users" data-field="x_Region" name="x_Region" id="x_Region" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($users->Region->getPlaceHolder()) ?>" value="<?php echo $users->Region->EditValue ?>"<?php echo $users->Region->editAttributes() ?>>
</span>
<?php echo $users->Region->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->PostalCode->Visible) { // PostalCode ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_PostalCode" class="form-group row">
		<label id="elh_users_PostalCode" for="x_PostalCode" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->PostalCode->caption() ?><?php echo ($users->PostalCode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->PostalCode->cellAttributes() ?>>
<span id="el_users_PostalCode">
<input type="text" data-table="users" data-field="x_PostalCode" name="x_PostalCode" id="x_PostalCode" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($users->PostalCode->getPlaceHolder()) ?>" value="<?php echo $users->PostalCode->EditValue ?>"<?php echo $users->PostalCode->editAttributes() ?>>
</span>
<?php echo $users->PostalCode->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_PostalCode">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_PostalCode"><?php echo $users->PostalCode->caption() ?><?php echo ($users->PostalCode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->PostalCode->cellAttributes() ?>>
<span id="el_users_PostalCode">
<input type="text" data-table="users" data-field="x_PostalCode" name="x_PostalCode" id="x_PostalCode" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($users->PostalCode->getPlaceHolder()) ?>" value="<?php echo $users->PostalCode->EditValue ?>"<?php echo $users->PostalCode->editAttributes() ?>>
</span>
<?php echo $users->PostalCode->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Country->Visible) { // Country ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Country" class="form-group row">
		<label id="elh_users_Country" for="x_Country" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Country->caption() ?><?php echo ($users->Country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Country->cellAttributes() ?>>
<span id="el_users_Country">
<input type="text" data-table="users" data-field="x_Country" name="x_Country" id="x_Country" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($users->Country->getPlaceHolder()) ?>" value="<?php echo $users->Country->EditValue ?>"<?php echo $users->Country->editAttributes() ?>>
</span>
<?php echo $users->Country->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Country">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Country"><?php echo $users->Country->caption() ?><?php echo ($users->Country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Country->cellAttributes() ?>>
<span id="el_users_Country">
<input type="text" data-table="users" data-field="x_Country" name="x_Country" id="x_Country" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($users->Country->getPlaceHolder()) ?>" value="<?php echo $users->Country->EditValue ?>"<?php echo $users->Country->editAttributes() ?>>
</span>
<?php echo $users->Country->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->HomePhone->Visible) { // HomePhone ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_HomePhone" class="form-group row">
		<label id="elh_users_HomePhone" for="x_HomePhone" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->HomePhone->caption() ?><?php echo ($users->HomePhone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->HomePhone->cellAttributes() ?>>
<span id="el_users_HomePhone">
<input type="text" data-table="users" data-field="x_HomePhone" name="x_HomePhone" id="x_HomePhone" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($users->HomePhone->getPlaceHolder()) ?>" value="<?php echo $users->HomePhone->EditValue ?>"<?php echo $users->HomePhone->editAttributes() ?>>
</span>
<?php echo $users->HomePhone->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_HomePhone">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_HomePhone"><?php echo $users->HomePhone->caption() ?><?php echo ($users->HomePhone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->HomePhone->cellAttributes() ?>>
<span id="el_users_HomePhone">
<input type="text" data-table="users" data-field="x_HomePhone" name="x_HomePhone" id="x_HomePhone" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($users->HomePhone->getPlaceHolder()) ?>" value="<?php echo $users->HomePhone->EditValue ?>"<?php echo $users->HomePhone->editAttributes() ?>>
</span>
<?php echo $users->HomePhone->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Extension->Visible) { // Extension ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Extension" class="form-group row">
		<label id="elh_users_Extension" for="x_Extension" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Extension->caption() ?><?php echo ($users->Extension->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Extension->cellAttributes() ?>>
<span id="el_users_Extension">
<input type="text" data-table="users" data-field="x_Extension" name="x_Extension" id="x_Extension" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($users->Extension->getPlaceHolder()) ?>" value="<?php echo $users->Extension->EditValue ?>"<?php echo $users->Extension->editAttributes() ?>>
</span>
<?php echo $users->Extension->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Extension">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Extension"><?php echo $users->Extension->caption() ?><?php echo ($users->Extension->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Extension->cellAttributes() ?>>
<span id="el_users_Extension">
<input type="text" data-table="users" data-field="x_Extension" name="x_Extension" id="x_Extension" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($users->Extension->getPlaceHolder()) ?>" value="<?php echo $users->Extension->EditValue ?>"<?php echo $users->Extension->editAttributes() ?>>
</span>
<?php echo $users->Extension->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->_Email->Visible) { // Email ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r__Email" class="form-group row">
		<label id="elh_users__Email" for="x__Email" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->_Email->caption() ?><?php echo ($users->_Email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->_Email->cellAttributes() ?>>
<span id="el_users__Email">
<input type="text" data-table="users" data-field="x__Email" name="x__Email" id="x__Email" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($users->_Email->getPlaceHolder()) ?>" value="<?php echo $users->_Email->EditValue ?>"<?php echo $users->_Email->editAttributes() ?>>
</span>
<?php echo $users->_Email->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r__Email">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users__Email"><?php echo $users->_Email->caption() ?><?php echo ($users->_Email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->_Email->cellAttributes() ?>>
<span id="el_users__Email">
<input type="text" data-table="users" data-field="x__Email" name="x__Email" id="x__Email" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($users->_Email->getPlaceHolder()) ?>" value="<?php echo $users->_Email->EditValue ?>"<?php echo $users->_Email->editAttributes() ?>>
</span>
<?php echo $users->_Email->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Photo->Visible) { // Photo ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Photo" class="form-group row">
		<label id="elh_users_Photo" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Photo->caption() ?><?php echo ($users->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Photo->cellAttributes() ?>>
<span id="el_users_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $users->Photo->title() ? $users->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($users->Photo->ReadOnly || $users->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="users" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $users->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $users->Photo->Upload->FileName ?>">
<?php if (Post("fa_x_Photo") == "0") { ?>
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="1">
<?php } ?>
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $users->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $users->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $users->Photo->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Photo">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Photo"><?php echo $users->Photo->caption() ?><?php echo ($users->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Photo->cellAttributes() ?>>
<span id="el_users_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $users->Photo->title() ? $users->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($users->Photo->ReadOnly || $users->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="users" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $users->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $users->Photo->Upload->FileName ?>">
<?php if (Post("fa_x_Photo") == "0") { ?>
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="1">
<?php } ?>
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $users->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $users->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $users->Photo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Notes->Visible) { // Notes ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_users_Notes" for="x_Notes" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Notes->caption() ?><?php echo ($users->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Notes->cellAttributes() ?>>
<span id="el_users_Notes">
<textarea data-table="users" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($users->Notes->getPlaceHolder()) ?>"<?php echo $users->Notes->editAttributes() ?>><?php echo $users->Notes->EditValue ?></textarea>
</span>
<?php echo $users->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Notes"><?php echo $users->Notes->caption() ?><?php echo ($users->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Notes->cellAttributes() ?>>
<span id="el_users_Notes">
<textarea data-table="users" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($users->Notes->getPlaceHolder()) ?>"<?php echo $users->Notes->editAttributes() ?>><?php echo $users->Notes->EditValue ?></textarea>
</span>
<?php echo $users->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->ReportsTo->Visible) { // ReportsTo ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_ReportsTo" class="form-group row">
		<label id="elh_users_ReportsTo" for="x_ReportsTo" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->ReportsTo->caption() ?><?php echo ($users->ReportsTo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->ReportsTo->cellAttributes() ?>>
<span id="el_users_ReportsTo">
<input type="text" data-table="users" data-field="x_ReportsTo" name="x_ReportsTo" id="x_ReportsTo" size="30" placeholder="<?php echo HtmlEncode($users->ReportsTo->getPlaceHolder()) ?>" value="<?php echo $users->ReportsTo->EditValue ?>"<?php echo $users->ReportsTo->editAttributes() ?>>
</span>
<?php echo $users->ReportsTo->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ReportsTo">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_ReportsTo"><?php echo $users->ReportsTo->caption() ?><?php echo ($users->ReportsTo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->ReportsTo->cellAttributes() ?>>
<span id="el_users_ReportsTo">
<input type="text" data-table="users" data-field="x_ReportsTo" name="x_ReportsTo" id="x_ReportsTo" size="30" placeholder="<?php echo HtmlEncode($users->ReportsTo->getPlaceHolder()) ?>" value="<?php echo $users->ReportsTo->EditValue ?>"<?php echo $users->ReportsTo->editAttributes() ?>>
</span>
<?php echo $users->ReportsTo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->UserLevel->Visible) { // UserLevel ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_UserLevel" class="form-group row">
		<label id="elh_users_UserLevel" for="x_UserLevel" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->UserLevel->caption() ?><?php echo ($users->UserLevel->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->UserLevel->cellAttributes() ?>>
<span id="el_users_UserLevel">
<input type="text" data-table="users" data-field="x_UserLevel" name="x_UserLevel" id="x_UserLevel" size="30" placeholder="<?php echo HtmlEncode($users->UserLevel->getPlaceHolder()) ?>" value="<?php echo $users->UserLevel->EditValue ?>"<?php echo $users->UserLevel->editAttributes() ?>>
</span>
<?php echo $users->UserLevel->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_UserLevel">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_UserLevel"><?php echo $users->UserLevel->caption() ?><?php echo ($users->UserLevel->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->UserLevel->cellAttributes() ?>>
<span id="el_users_UserLevel">
<input type="text" data-table="users" data-field="x_UserLevel" name="x_UserLevel" id="x_UserLevel" size="30" placeholder="<?php echo HtmlEncode($users->UserLevel->getPlaceHolder()) ?>" value="<?php echo $users->UserLevel->EditValue ?>"<?php echo $users->UserLevel->editAttributes() ?>>
</span>
<?php echo $users->UserLevel->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Activated->Visible) { // Activated ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Activated" class="form-group row">
		<label id="elh_users_Activated" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Activated->caption() ?><?php echo ($users->Activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Activated->cellAttributes() ?>>
<span id="el_users_Activated">
<?php
$selwrk = (ConvertToBool($users->Activated->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $users->Activated->editAttributes() ?>>
</span>
<?php echo $users->Activated->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Activated">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Activated"><?php echo $users->Activated->caption() ?><?php echo ($users->Activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Activated->cellAttributes() ?>>
<span id="el_users_Activated">
<?php
$selwrk = (ConvertToBool($users->Activated->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $users->Activated->editAttributes() ?>>
</span>
<?php echo $users->Activated->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Profile->Visible) { // Profile ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Profile" class="form-group row">
		<label id="elh_users_Profile" for="x_Profile" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Profile->caption() ?><?php echo ($users->Profile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Profile->cellAttributes() ?>>
<span id="el_users_Profile">
<textarea data-table="users" data-field="x_Profile" name="x_Profile" id="x_Profile" cols="35" rows="4" placeholder="<?php echo HtmlEncode($users->Profile->getPlaceHolder()) ?>"<?php echo $users->Profile->editAttributes() ?>><?php echo $users->Profile->EditValue ?></textarea>
</span>
<?php echo $users->Profile->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Profile">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Profile"><?php echo $users->Profile->caption() ?><?php echo ($users->Profile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Profile->cellAttributes() ?>>
<span id="el_users_Profile">
<textarea data-table="users" data-field="x_Profile" name="x_Profile" id="x_Profile" cols="35" rows="4" placeholder="<?php echo HtmlEncode($users->Profile->getPlaceHolder()) ?>"<?php echo $users->Profile->editAttributes() ?>><?php echo $users->Profile->EditValue ?></textarea>
</span>
<?php echo $users->Profile->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Type->Visible) { // Type ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Type" class="form-group row">
		<label id="elh_users_Type" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Type->caption() ?><?php echo ($users->Type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Type->cellAttributes() ?>>
<span id="el_users_Type">
<div id="tp_x_Type" class="ew-template"><input type="radio" class="form-check-input" data-table="users" data-field="x_Type" data-value-separator="<?php echo $users->Type->displayValueSeparatorAttribute() ?>" name="x_Type" id="x_Type" value="{value}"<?php echo $users->Type->editAttributes() ?>></div>
<div id="dsl_x_Type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $users->Type->radioButtonListHtml(FALSE, "x_Type") ?>
</div></div>
</span>
<?php echo $users->Type->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Type">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Type"><?php echo $users->Type->caption() ?><?php echo ($users->Type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Type->cellAttributes() ?>>
<span id="el_users_Type">
<div id="tp_x_Type" class="ew-template"><input type="radio" class="form-check-input" data-table="users" data-field="x_Type" data-value-separator="<?php echo $users->Type->displayValueSeparatorAttribute() ?>" name="x_Type" id="x_Type" value="{value}"<?php echo $users->Type->editAttributes() ?>></div>
<div id="dsl_x_Type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $users->Type->radioButtonListHtml(FALSE, "x_Type") ?>
</div></div>
</span>
<?php echo $users->Type->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Gender->Visible) { // Gender ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Gender" class="form-group row">
		<label id="elh_users_Gender" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Gender->caption() ?><?php echo ($users->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Gender->cellAttributes() ?>>
<span id="el_users_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="users" data-field="x_Gender" data-value-separator="<?php echo $users->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $users->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $users->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $users->Gender->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Gender">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Gender"><?php echo $users->Gender->caption() ?><?php echo ($users->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Gender->cellAttributes() ?>>
<span id="el_users_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="users" data-field="x_Gender" data-value-separator="<?php echo $users->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $users->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $users->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $users->Gender->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->MobilePhone->Visible) { // MobilePhone ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_MobilePhone" class="form-group row">
		<label id="elh_users_MobilePhone" for="x_MobilePhone" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->MobilePhone->caption() ?><?php echo ($users->MobilePhone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->MobilePhone->cellAttributes() ?>>
<span id="el_users_MobilePhone">
<input type="text" data-table="users" data-field="x_MobilePhone" name="x_MobilePhone" id="x_MobilePhone" size="30" placeholder="<?php echo HtmlEncode($users->MobilePhone->getPlaceHolder()) ?>" value="<?php echo $users->MobilePhone->EditValue ?>"<?php echo $users->MobilePhone->editAttributes() ?>>
</span>
<?php echo $users->MobilePhone->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_MobilePhone">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_MobilePhone"><?php echo $users->MobilePhone->caption() ?><?php echo ($users->MobilePhone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->MobilePhone->cellAttributes() ?>>
<span id="el_users_MobilePhone">
<input type="text" data-table="users" data-field="x_MobilePhone" name="x_MobilePhone" id="x_MobilePhone" size="30" placeholder="<?php echo HtmlEncode($users->MobilePhone->getPlaceHolder()) ?>" value="<?php echo $users->MobilePhone->EditValue ?>"<?php echo $users->MobilePhone->editAttributes() ?>>
</span>
<?php echo $users->MobilePhone->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Address2->Visible) { // Address2 ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Address2" class="form-group row">
		<label id="elh_users_Address2" for="x_Address2" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Address2->caption() ?><?php echo ($users->Address2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Address2->cellAttributes() ?>>
<span id="el_users_Address2">
<textarea data-table="users" data-field="x_Address2" name="x_Address2" id="x_Address2" cols="35" rows="4" placeholder="<?php echo HtmlEncode($users->Address2->getPlaceHolder()) ?>"<?php echo $users->Address2->editAttributes() ?>><?php echo $users->Address2->EditValue ?></textarea>
</span>
<?php echo $users->Address2->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Address2">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Address2"><?php echo $users->Address2->caption() ?><?php echo ($users->Address2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Address2->cellAttributes() ?>>
<span id="el_users_Address2">
<textarea data-table="users" data-field="x_Address2" name="x_Address2" id="x_Address2" cols="35" rows="4" placeholder="<?php echo HtmlEncode($users->Address2->getPlaceHolder()) ?>"<?php echo $users->Address2->editAttributes() ?>><?php echo $users->Address2->EditValue ?></textarea>
</span>
<?php echo $users->Address2->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Locked->Visible) { // Locked ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Locked" class="form-group row">
		<label id="elh_users_Locked" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Locked->caption() ?><?php echo ($users->Locked->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Locked->cellAttributes() ?>>
<span id="el_users_Locked">
<?php
$selwrk = (ConvertToBool($users->Locked->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Locked" name="x_Locked[]" id="x_Locked[]" value="1"<?php echo $selwrk ?><?php echo $users->Locked->editAttributes() ?>>
</span>
<?php echo $users->Locked->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Locked">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Locked"><?php echo $users->Locked->caption() ?><?php echo ($users->Locked->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Locked->cellAttributes() ?>>
<span id="el_users_Locked">
<?php
$selwrk = (ConvertToBool($users->Locked->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Locked" name="x_Locked[]" id="x_Locked[]" value="1"<?php echo $selwrk ?><?php echo $users->Locked->editAttributes() ?>>
</span>
<?php echo $users->Locked->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Theme->Visible) { // Theme ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Theme" class="form-group row">
		<label id="elh_users_Theme" for="x_Theme" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Theme->caption() ?><?php echo ($users->Theme->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Theme->cellAttributes() ?>>
<span id="el_users_Theme">
<input type="text" data-table="users" data-field="x_Theme" name="x_Theme" id="x_Theme" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($users->Theme->getPlaceHolder()) ?>" value="<?php echo $users->Theme->EditValue ?>"<?php echo $users->Theme->editAttributes() ?>>
</span>
<?php echo $users->Theme->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Theme">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Theme"><?php echo $users->Theme->caption() ?><?php echo ($users->Theme->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Theme->cellAttributes() ?>>
<span id="el_users_Theme">
<input type="text" data-table="users" data-field="x_Theme" name="x_Theme" id="x_Theme" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($users->Theme->getPlaceHolder()) ?>" value="<?php echo $users->Theme->EditValue ?>"<?php echo $users->Theme->editAttributes() ?>>
</span>
<?php echo $users->Theme->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Menu_Horizontal->Visible) { // Menu_Horizontal ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Menu_Horizontal" class="form-group row">
		<label id="elh_users_Menu_Horizontal" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Menu_Horizontal->caption() ?><?php echo ($users->Menu_Horizontal->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Menu_Horizontal->cellAttributes() ?>>
<span id="el_users_Menu_Horizontal">
<?php
$selwrk = (ConvertToBool($users->Menu_Horizontal->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Menu_Horizontal" name="x_Menu_Horizontal[]" id="x_Menu_Horizontal[]" value="1"<?php echo $selwrk ?><?php echo $users->Menu_Horizontal->editAttributes() ?>>
</span>
<?php echo $users->Menu_Horizontal->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Menu_Horizontal">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Menu_Horizontal"><?php echo $users->Menu_Horizontal->caption() ?><?php echo ($users->Menu_Horizontal->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Menu_Horizontal->cellAttributes() ?>>
<span id="el_users_Menu_Horizontal">
<?php
$selwrk = (ConvertToBool($users->Menu_Horizontal->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Menu_Horizontal" name="x_Menu_Horizontal[]" id="x_Menu_Horizontal[]" value="1"<?php echo $selwrk ?><?php echo $users->Menu_Horizontal->editAttributes() ?>>
</span>
<?php echo $users->Menu_Horizontal->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->_Language->Visible) { // Language ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r__Language" class="form-group row">
		<label id="elh_users__Language" for="x__Language" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->_Language->caption() ?><?php echo ($users->_Language->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->_Language->cellAttributes() ?>>
<span id="el_users__Language">
<input type="text" data-table="users" data-field="x__Language" name="x__Language" id="x__Language" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($users->_Language->getPlaceHolder()) ?>" value="<?php echo $users->_Language->EditValue ?>"<?php echo $users->_Language->editAttributes() ?>>
</span>
<?php echo $users->_Language->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r__Language">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users__Language"><?php echo $users->_Language->caption() ?><?php echo ($users->_Language->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->_Language->cellAttributes() ?>>
<span id="el_users__Language">
<input type="text" data-table="users" data-field="x__Language" name="x__Language" id="x__Language" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($users->_Language->getPlaceHolder()) ?>" value="<?php echo $users->_Language->EditValue ?>"<?php echo $users->_Language->editAttributes() ?>>
</span>
<?php echo $users->_Language->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users->Current_URL->Visible) { // Current_URL ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
	<div id="r_Current_URL" class="form-group row">
		<label id="elh_users_Current_URL" for="x_Current_URL" class="<?php echo $users_edit->LeftColumnClass ?>"><?php echo $users->Current_URL->caption() ?><?php echo ($users->Current_URL->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $users_edit->RightColumnClass ?>"><div<?php echo $users->Current_URL->cellAttributes() ?>>
<span id="el_users_Current_URL">
<textarea data-table="users" data-field="x_Current_URL" name="x_Current_URL" id="x_Current_URL" cols="35" rows="4" placeholder="<?php echo HtmlEncode($users->Current_URL->getPlaceHolder()) ?>"<?php echo $users->Current_URL->editAttributes() ?>><?php echo $users->Current_URL->EditValue ?></textarea>
</span>
<?php echo $users->Current_URL->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Current_URL">
		<td class="<?php echo $users_edit->TableLeftColumnClass ?>"><span id="elh_users_Current_URL"><?php echo $users->Current_URL->caption() ?><?php echo ($users->Current_URL->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $users->Current_URL->cellAttributes() ?>>
<span id="el_users_Current_URL">
<textarea data-table="users" data-field="x_Current_URL" name="x_Current_URL" id="x_Current_URL" cols="35" rows="4" placeholder="<?php echo HtmlEncode($users->Current_URL->getPlaceHolder()) ?>"<?php echo $users->Current_URL->editAttributes() ?>><?php echo $users->Current_URL->EditValue ?></textarea>
</span>
<?php echo $users->Current_URL->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($users_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$users_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $users_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $users_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$users_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$users_edit->IsModal) { ?>
<?php if (!isset($users_edit->Pager)) $users_edit->Pager = new PrevNextPager($users_edit->StartRec, $users_edit->DisplayRecs, $users_edit->TotalRecs, $users_edit->AutoHidePager) ?>
<?php if ($users_edit->Pager->RecordCount > 0 && $users_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($users_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $users_edit->pageUrl() ?>start=<?php echo $users_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($users_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $users_edit->pageUrl() ?>start=<?php echo $users_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $users_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($users_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $users_edit->pageUrl() ?>start=<?php echo $users_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($users_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $users_edit->pageUrl() ?>start=<?php echo $users_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $users_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$users_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$users_edit->terminate();
?>
